/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.reduction;

import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray16Image;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ReduceShadesOfGray
extends ImageToImageOperation {
    private Integer destBits;
    private int[] lut;

    private void createLut(int inDepth) {
        int outDepth = this.destBits;
        this.lut = new int[1 << inDepth];
        int SHIFT = inDepth - outDepth;
        int MAX_IN_VALUE = (1 << inDepth) - 1;
        int MAX_OUT_VALUE = (1 << outDepth) - 1;
        for (int i = 0; i < this.lut.length; ++i) {
            int value = i >> SHIFT;
            this.lut[i] = value * MAX_IN_VALUE / MAX_OUT_VALUE;
        }
    }

    private void process(GrayIntegerImage in, int MASK, BilevelImage out) {
        if (out == null) {
            out = new MemoryBilevelImage(in.getWidth(), in.getHeight());
        }
        out.clear(0);
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                if ((in.getSample(x, y) & MASK) == 0) continue;
                out.putWhite(x, y);
            }
            this.setProgress(y, in.getHeight());
        }
        this.setOutputImage(out);
    }

    private void process(GrayIntegerImage in, GrayIntegerImage out) {
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                out.putSample(x, y, this.lut[in.getSample(0, x, y)]);
            }
            this.setProgress(y, in.getHeight());
        }
        this.setOutputImage(out);
    }

    public void process() throws MissingParameterException, WrongParameterException {
        if (this.destBits == null) {
            throw new MissingParameterException("The number of destination bits has not been specified.");
        }
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        boolean gray8 = in instanceof Gray8Image;
        boolean gray16 = in instanceof Gray16Image;
        if (!gray8 && !gray16) {
            throw new WrongParameterException("Input image must be either Gray8Image or Gray16Image.");
        }
        if (this.destBits == 1) {
            this.process((GrayIntegerImage)in, gray8 ? 128 : 32768, (BilevelImage)this.getOutputImage());
        } else if (gray8) {
            if (this.destBits > 7) {
                throw new WrongParameterException("For a Gray8Image destination bits must be 7 or less.");
            }
            PixelImage out = this.getOutputImage();
            if (out == null) {
                out = new MemoryGray8Image(in.getWidth(), in.getHeight());
            } else if (!(out instanceof Gray8Image)) {
                throw new WrongParameterException("For this input image, output image must be a Gray8Image.");
            }
            this.createLut(8);
            this.process((GrayIntegerImage)in, (GrayIntegerImage)out);
        } else if (gray16) {
            PixelImage out = this.getOutputImage();
            if (out == null) {
                out = new MemoryGray16Image(in.getWidth(), in.getHeight());
            } else {
                if (this.destBits <= 8 && !(out instanceof Gray8Image)) {
                    throw new WrongParameterException("For this input image, output image must be a Gray8Image.");
                }
                if (this.destBits <= 15 && !(out instanceof Gray16Image)) {
                    throw new WrongParameterException("For this input image, output image must be a Gray16Image.");
                }
            }
            this.createLut(16);
            this.process((GrayIntegerImage)in, (GrayIntegerImage)out);
        }
    }

    public void setBits(int bits) {
        if (bits < 1) {
            throw new IllegalArgumentException("Number of bits must be 1 or larger.");
        }
        if (bits > 15) {
            throw new IllegalArgumentException("Number of bits must be 15 or smaller.");
        }
        this.destBits = new Integer(bits);
    }
}

