/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.reduction;

import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.MemoryGray16Image;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class RGBToGrayConversion
extends ImageToImageOperation {
    public static final float DEFAULT_RED_WEIGHT = 0.3f;
    public static final float DEFAULT_GREEN_WEIGHT = 0.59f;
    public static final float DEFAULT_BLUE_WEIGHT = 0.11f;
    private float redWeight = 0.3f;
    private float greenWeight = 0.59f;
    private float blueWeight = 0.11f;

    public static PixelImage convert(PixelImage rgbImage) throws MissingParameterException, WrongParameterException {
        RGBToGrayConversion op = new RGBToGrayConversion();
        op.setInputImage(rgbImage);
        op.process();
        return op.getOutputImage();
    }

    private void process(RGBIntegerImage in, GrayIntegerImage out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                int red = in.getSample(0, x, y);
                int green = in.getSample(1, x, y);
                int blue = in.getSample(2, x, y);
                out.putSample(x, y, (int)((float)red * this.redWeight + (float)green * this.greenWeight + (float)blue * this.blueWeight));
            }
            this.setProgress(y, HEIGHT);
        }
        this.setOutputImage(out);
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        if (in instanceof RGB24Image) {
            this.process((RGB24Image)in);
        } else if (in instanceof RGB48Image) {
            this.process((RGB48Image)in);
        } else if (in instanceof Paletted8Image) {
            this.process((Paletted8Image)in);
        } else {
            throw new WrongParameterException("Type of input image unsupported: " + in.getImageType().getName());
        }
    }

    private void process(Paletted8Image in) throws MissingParameterException, WrongParameterException {
        PixelImage image = this.getOutputImage();
        Gray8Image out = null;
        if (image == null) {
            out = new MemoryGray8Image(in.getWidth(), in.getHeight());
        } else {
            if (!(image instanceof Gray8Image)) {
                throw new WrongParameterException("Specified output image must be of type Gray8Image for input image of type Paletted8Image.");
            }
            out = (Gray8Image)image;
            this.ensureImagesHaveSameResolution();
        }
        Palette palette = in.getPalette();
        int[] lut = new int[palette.getNumEntries()];
        for (int i = 0; i < lut.length; ++i) {
            int red = palette.getSample(0, i);
            int green = palette.getSample(1, i);
            int blue = palette.getSample(2, i);
            lut[i] = (int)((float)red * this.redWeight + (float)green * this.greenWeight + (float)blue * this.blueWeight);
        }
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                try {
                    out.putSample(0, x, y, lut[in.getSample(0, x, y)]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            this.setProgress(y, HEIGHT);
        }
        this.setOutputImage(out);
    }

    private void process(RGB24Image in) throws WrongParameterException {
        PixelImage out = this.getOutputImage();
        if (out == null) {
            out = new MemoryGray8Image(in.getWidth(), in.getHeight());
        } else {
            if (!(out instanceof Gray8Image)) {
                throw new WrongParameterException("Specified output image must be of type Gray8Image for input image of type RGB24Image.");
            }
            this.ensureImagesHaveSameResolution();
        }
        this.process(in, (GrayIntegerImage)out);
    }

    private void process(RGB48Image in) throws WrongParameterException {
        PixelImage out = this.getOutputImage();
        if (out == null) {
            out = new MemoryGray16Image(in.getWidth(), in.getHeight());
        } else {
            if (!(out instanceof Gray16Image)) {
                throw new WrongParameterException("Specified output image must be of type Gray16Image for input image of type RGB48Image.");
            }
            this.ensureImagesHaveSameResolution();
        }
        this.process(in, (GrayIntegerImage)out);
    }

    public void setColorWeights(float red, float green, float blue) {
        if (red < 0.0f) {
            throw new IllegalArgumentException("The red weight must be larger than or equal to 0; got " + red);
        }
        if (green < 0.0f) {
            throw new IllegalArgumentException("The green weight must be larger than or equal to 0; got " + green);
        }
        if (blue < 0.0f) {
            throw new IllegalArgumentException("The blue weight must be larger than or equal to 0; got " + blue);
        }
        if (red > 1.0f) {
            throw new IllegalArgumentException("The red weight must be smaller than or equal to 1.0f; got " + red);
        }
        if (green > 1.0f) {
            throw new IllegalArgumentException("The green weight must be smaller than or equal to 1.0f; got " + green);
        }
        if (blue > 1.0f) {
            throw new IllegalArgumentException("The blue weight must be smaller than or equal to 1.0f; got " + blue);
        }
        float sum = red + green + blue;
        if (sum > 1.0f) {
            throw new IllegalArgumentException("The sum of the three weights must be smaller than or equal to 1.0f; got " + sum);
        }
        this.redWeight = red;
        this.greenWeight = green;
        this.blueWeight = blue;
    }
}

