/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.color.data.Histogram3D;
import net.sourceforge.jiu.color.quantization.RGBColor;
import net.sourceforge.jiu.color.quantization.RGBColorComparator;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.util.ComparatorInterface;
import net.sourceforge.jiu.util.Sort;

public class RGBColorList
implements RGBIndex {
    private RGBColor[] list;
    private final int numEntries;

    private RGBColorList(int NUM_ENTRIES) {
        if (NUM_ENTRIES < 1) {
            throw new IllegalArgumentException("RGBColorList must have at least one entry; got " + NUM_ENTRIES);
        }
        this.numEntries = NUM_ENTRIES;
        this.list = new RGBColor[NUM_ENTRIES];
    }

    public RGBColorList(Histogram3D hist) {
        this(hist.getNumUsedEntries());
        int i = 0;
        int MAX_RED = hist.getMaxValue(0);
        int MAX_GREEN = hist.getMaxValue(1);
        int MAX_BLUE = hist.getMaxValue(2);
        for (int r = 0; r <= MAX_RED; ++r) {
            for (int g = 0; g <= MAX_GREEN; ++g) {
                for (int b = 0; b <= MAX_BLUE; ++b) {
                    int counter = hist.getEntry(r, g, b);
                    if (counter <= 0) continue;
                    this.list[i++] = new RGBColor(r, g, b, counter);
                }
            }
        }
    }

    public int[] findExtrema(int i1, int i2) {
        int i;
        if (i1 < 0 || i1 >= this.numEntries || i2 < 0 || i2 >= this.numEntries || i1 > i2) {
            return null;
        }
        int[] max = new int[3];
        int[] min = new int[3];
        RGBColor c = this.list[i1];
        for (i = 0; i < 3; ++i) {
            min[i] = max[i] = c.getSample(i);
        }
        i = i1 + 1;
        while (i < i2) {
            c = this.list[i++];
            for (int j = 0; j < 3; ++j) {
                int cSample = c.getSample(j);
                if (cSample < min[j]) {
                    min[j] = cSample;
                    continue;
                }
                if (cSample <= max[j]) continue;
                max[j] = cSample;
            }
        }
        int[] result = new int[2];
        result[1] = -1;
        result[0] = -1;
        for (i = 0; i < 3; ++i) {
            int newDiff = max[i] - min[i];
            if (newDiff <= result[1]) continue;
            result[0] = i;
            result[1] = newDiff;
        }
        return result;
    }

    public RGBColor getColor(int index) {
        return this.list[index];
    }

    public int getNumEntries() {
        return this.list.length;
    }

    public void sortByAxis(int index1, int index2, int axis) {
        Sort.sort(this.list, index1, index2, new RGBColorComparator(axis));
    }

    public void sortByCounter(int index1, int index2) {
        Sort.sort(this.list, index1, index2, new ComparatorInterface(){

            public int compare(Object obj1, Object obj2) {
                RGBColor col1 = (RGBColor)obj1;
                RGBColor col2 = (RGBColor)obj2;
                return col1.getCounter() - col2.getCounter();
            }
        });
    }
}

