/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.data.RGBIndex;

public class RGBColor
implements RGBIndex {
    private int[] samples = new int[3];
    private int counter;

    public RGBColor(int red, int green, int blue) {
        this(red, green, blue, 0);
    }

    public RGBColor(int red, int green, int blue, int counter) {
        this.samples[0] = red;
        this.samples[1] = green;
        this.samples[2] = blue;
        this.counter = counter;
    }

    public int compareTo(RGBColor c, int sortOrder) {
        int s1 = this.samples[sortOrder];
        int s2 = c.samples[sortOrder];
        if (s1 < s2) {
            return -1;
        }
        if (s1 == s2) {
            return 0;
        }
        return 1;
    }

    public static double computeDistance(int r1, int g1, int b1, int r2, int g2, int b2) {
        int r = r1 - r2;
        int g = g1 - g2;
        int b = b1 - b2;
        return Math.sqrt(r * r + g * g + b * b);
    }

    public boolean equals(Object obj) {
        RGBColor c = (RGBColor)obj;
        return this.samples[0] == c.samples[0] && this.samples[1] == c.samples[1] && this.samples[2] == c.samples[2];
    }

    public int getCounter() {
        return this.counter;
    }

    public int getSample(int index) {
        return this.samples[index];
    }

    public String toString() {
        return "(" + this.samples[0] + ", " + this.samples[1] + ", " + this.samples[2] + ")";
    }
}

