/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.util.ComparatorInterface;

public class OctreeNode
implements ComparatorInterface,
RGBIndex {
    private int paletteIndex;
    private int pixelCount;
    private int redSum;
    private int greenSum;
    private int blueSum;
    private int red;
    private int green;
    private int blue;
    private OctreeNode[] children;

    public static boolean add(OctreeNode root, int red, int green, int blue, int bitsPerSample) {
        OctreeNode node = root;
        boolean newColor = false;
        for (int shift = bitsPerSample - 1; shift >= 0; --shift) {
            int index;
            OctreeNode[] children = node.children;
            if (children == null) {
                node.children = children = new OctreeNode[8];
            }
            if ((node = children[index = OctreeNode.computeIndex(red, green, blue, shift)]) != null) continue;
            children[index] = node = new OctreeNode();
            newColor = true;
        }
        node.update(red, green, blue);
        return newColor;
    }

    public int compare(Object o1, Object o2) {
        OctreeNode n1 = (OctreeNode)o1;
        OctreeNode n2 = (OctreeNode)o2;
        int pc1 = n1.pixelCount;
        int pc2 = n2.pixelCount;
        if (pc1 < pc2) {
            return -1;
        }
        if (pc1 == pc2) {
            return 0;
        }
        return 1;
    }

    private static int computeIndex(int red, int green, int blue, int shift) {
        return (red >> shift & 1) << 2 | (green >> shift & 1) << 1 | blue >> shift & 1;
    }

    public void copyChildSums() {
        if (this.children == null) {
            return;
        }
        this.redSum = 0;
        this.greenSum = 0;
        this.blueSum = 0;
        this.pixelCount = 0;
        for (int i = 0; i < this.children.length; ++i) {
            OctreeNode child = this.children[i];
            if (child == null) continue;
            child.copyChildSums();
            this.redSum += child.redSum;
            this.greenSum += child.greenSum;
            this.blueSum += child.blueSum;
            this.pixelCount += child.pixelCount;
        }
    }

    public void determineRepresentativeColor() {
        if (this.pixelCount > 0) {
            this.red = this.redSum / this.pixelCount;
            this.green = this.greenSum / this.pixelCount;
            this.blue = this.blueSum / this.pixelCount;
        }
    }

    public int getBlue() {
        return this.blue;
    }

    public OctreeNode[] getChildren() {
        return this.children;
    }

    public int getGreen() {
        return this.green;
    }

    public int getNumChildren() {
        int result = 0;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                ++result;
            }
        }
        return result;
    }

    public int getPaletteIndex() {
        return this.paletteIndex;
    }

    public int getRed() {
        return this.red;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public int map(int[] origRgb, int[] quantizedRgb) {
        return this.map(origRgb[0], origRgb[1], origRgb[2], 7, quantizedRgb);
    }

    private final int map(int r, int g, int b, int shift, int[] quantizedRgb) {
        if (this.children == null) {
            quantizedRgb[0] = this.red;
            quantizedRgb[1] = this.green;
            quantizedRgb[2] = this.blue;
            return this.paletteIndex;
        }
        int index = OctreeNode.computeIndex(r, g, b, shift);
        OctreeNode node = this.children[index];
        if (node == null) {
            return -1;
        }
        return node.map(r, g, b, shift - 1, quantizedRgb);
    }

    public void setChildren(OctreeNode[] newChildren) {
        this.children = newChildren;
    }

    public void setPaletteIndex(int index) {
        this.paletteIndex = index;
    }

    private void update(int red, int green, int blue) {
        this.redSum += red;
        this.greenSum += green;
        this.blueSum += blue;
        ++this.pixelCount;
    }
}

