/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.color.quantization.OctreeNode;
import net.sourceforge.jiu.color.quantization.RGBQuantizer;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;
import net.sourceforge.jiu.util.Sort;

public class OctreeColorQuantizer
extends ImageToImageOperation
implements RGBIndex,
RGBQuantizer {
    public static final int DEFAULT_PALETTE_SIZE = 256;
    private int paletteSize = 256;
    private OctreeNode root;
    private Palette palette;
    private int[] redValues;
    private int[] greenValues;
    private int[] blueValues;

    private int assignPaletteIndexValues(OctreeNode node, int index) {
        if (node == null) {
            return index;
        }
        if (node.isLeaf()) {
            node.setPaletteIndex(index);
            node.determineRepresentativeColor();
            return index + 1;
        }
        OctreeNode[] children = node.getChildren();
        if (children != null) {
            for (int i = 0; i < 8; ++i) {
                if (children[i] == null) continue;
                index = this.assignPaletteIndexValues(children[i], index);
            }
        }
        return index;
    }

    public Palette createPalette() {
        if (this.palette == null) {
            int numValues = this.assignPaletteIndexValues(this.root, 0);
            this.palette = new Palette(numValues);
            this.initPalette(this.root, this.palette);
            this.redValues = new int[numValues];
            this.greenValues = new int[numValues];
            this.blueValues = new int[numValues];
            for (int i = 0; i < numValues; ++i) {
                this.redValues[i] = this.palette.getSample(0, i);
                this.greenValues[i] = this.palette.getSample(1, i);
                this.blueValues[i] = this.palette.getSample(2, i);
            }
            return this.palette;
        }
        return (Palette)this.palette.clone();
    }

    public void init() throws MissingParameterException, WrongParameterException {
        PixelImage pi = this.getInputImage();
        if (pi == null) {
            throw new MissingParameterException("Input image needed.");
        }
        if (!(pi instanceof RGB24Image)) {
            throw new WrongParameterException("Input image must be of type RGB24Image.");
        }
        this.initOctree();
        this.pruneOctree();
    }

    private int initOctree() {
        int numUniqueColors = 0;
        this.root = new OctreeNode();
        RGB24Image in = (RGB24Image)this.getInputImage();
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                int blue;
                int green;
                int red = in.getSample(0, x, y);
                if (!OctreeNode.add(this.root, red, green = in.getSample(1, x, y), blue = in.getSample(2, x, y), 8)) continue;
                ++numUniqueColors;
            }
        }
        this.root.copyChildSums();
        return numUniqueColors;
    }

    private void initPalette(OctreeNode node, Palette palette) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            int index = node.getPaletteIndex();
            palette.put(index, node.getRed(), node.getGreen(), node.getBlue());
            return;
        }
        OctreeNode[] children = node.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            OctreeNode child = children[i];
            if (child == null) continue;
            this.initPalette(child, palette);
        }
    }

    public int map(int[] origRgb, int[] quantizedRgb) {
        int result = this.root.map(origRgb, quantizedRgb);
        if (result == -1) {
            int minIndex = 0;
            int minDistance = Integer.MAX_VALUE;
            int red = origRgb[0];
            int green = origRgb[1];
            int blue = origRgb[2];
            for (int i = 0; i < this.redValues.length; ++i) {
                int v = this.redValues[i] - red;
                int sum = v * v;
                v = this.greenValues[i] - green;
                sum += v * v;
                v = this.blueValues[i] - blue;
                if ((sum += v * v) >= minDistance) continue;
                minIndex = i;
                minDistance = sum;
            }
            quantizedRgb[0] = this.redValues[minIndex];
            quantizedRgb[1] = this.greenValues[minIndex];
            quantizedRgb[2] = this.blueValues[minIndex];
            return minIndex;
        }
        return result;
    }

    private void mapImage() {
        RGB24Image in = (RGB24Image)this.getInputImage();
        Palette palette = this.createPalette();
        MemoryPaletted8Image out = new MemoryPaletted8Image(in.getWidth(), in.getHeight(), palette);
        int[] origRgb = new int[3];
        int[] quantizedRgb = new int[3];
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                origRgb[0] = in.getSample(0, x, y);
                origRgb[1] = in.getSample(1, x, y);
                origRgb[2] = in.getSample(2, x, y);
                int index = this.map(origRgb, quantizedRgb);
                out.putSample(0, x, y, index);
            }
        }
        this.setOutputImage(out);
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.init();
        this.mapImage();
    }

    private void pruneOctree() {
        Object[] a = new OctreeNode[this.paletteSize];
        a[0] = this.root;
        int length = 1;
        OctreeNode comparator = new OctreeNode();
        while (length < this.paletteSize) {
            int index;
            Sort.sort(a, 0, length - 1, comparator);
            for (index = length - 1; index >= 0; --index) {
                Object node = a[index];
                int numChildren = ((OctreeNode)node).getNumChildren();
                if (numChildren <= 0 || length - 1 + numChildren >= this.paletteSize) continue;
                if (index < length - 1) {
                    System.arraycopy(a, index + 1, a, index, length - index - 1);
                }
                --length;
                OctreeNode[] children = ((OctreeNode)node).getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] == null) continue;
                    a[length++] = children[i];
                }
                break;
            }
            if (index != -1) continue;
            break;
        }
        this.paletteSize = length;
        for (int i = 0; i < length; ++i) {
            ((OctreeNode)a[i]).setChildren(null);
        }
    }

    public void setPaletteSize(int newPaletteSize) {
        if (newPaletteSize < 1) {
            throw new IllegalArgumentException("Palette size must be 1 or larger.");
        }
        if (newPaletteSize > 256) {
            throw new IllegalArgumentException("Palette size must be 256 or smaller.");
        }
        this.paletteSize = newPaletteSize;
    }
}

