/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.color.analysis.Histogram3DCreator;
import net.sourceforge.jiu.color.data.Histogram3D;
import net.sourceforge.jiu.color.quantization.MedianCutNode;
import net.sourceforge.jiu.color.quantization.RGBColor;
import net.sourceforge.jiu.color.quantization.RGBColorList;
import net.sourceforge.jiu.color.quantization.RGBQuantizer;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class MedianCutQuantizer
extends ImageToImageOperation
implements RGBIndex,
RGBQuantizer {
    public static final int METHOD_REPR_COLOR_AVERAGE = 0;
    public static final int METHOD_REPR_COLOR_WEIGHTED_AVERAGE = 1;
    public static final int METHOD_REPR_COLOR_MEDIAN = 2;
    public static final int DEFAULT_METHOD_REPR_COLOR = 2;
    private boolean doNotMap = false;
    private RGBColorList list;
    private int maxValue = 255;
    private int method = 0;
    private boolean outputTruecolor = false;
    private int paletteSize = 256;
    private MedianCutNode root;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addNodes(MedianCutNode[] nodeList, MedianCutNode node) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            int index = node.getPaletteIndex();
            if (index < 0 || index >= nodeList.length) throw new IllegalStateException("A node's index is invalid.");
            nodeList[index] = node;
            return;
        } else {
            this.addNodes(nodeList, node.getLeftSuccessor());
            this.addNodes(nodeList, node.getRightSuccessor());
        }
    }

    private RGBColorList createColorList(RGB24Image image) throws OperationFailedException {
        Histogram3DCreator hc = new Histogram3DCreator();
        hc.setImage(image, 0, 1, 2);
        hc.process();
        Histogram3D hist = hc.getHistogram();
        if (hist == null) {
            throw new OperationFailedException("Could not create histogram from input image.");
        }
        int numUniqueColors = hist.getNumUsedEntries();
        if (numUniqueColors <= this.paletteSize) {
            throw new WrongParameterException("Input image has only " + numUniqueColors + " unique color(s), so it cannot be reduced to " + this.paletteSize + " color(s).");
        }
        return new RGBColorList(hist);
    }

    public MedianCutNode[] createLeafList() {
        MedianCutNode[] result = new MedianCutNode[this.paletteSize];
        this.addNodes(result, this.root);
        return result;
    }

    public Palette createPalette() {
        MedianCutNode[] leaves = this.createLeafList();
        Palette result = new Palette(leaves.length);
        for (int i = 0; i < leaves.length; ++i) {
            int[] reprColor = leaves[i].getRepresentativeColor();
            result.putSample(0, i, reprColor[0]);
            result.putSample(1, i, reprColor[1]);
            result.putSample(2, i, reprColor[2]);
        }
        return result;
    }

    private MedianCutNode findLeafToBeSplit(MedianCutNode node) {
        boolean canSplit2;
        if (node == null) {
            return null;
        }
        if (node.canBeSplit()) {
            if (!node.isAxisDetermined()) {
                int[] pairAxisDiff = this.list.findExtrema(node.getLeftIndex(), node.getRightIndex());
                if (pairAxisDiff == null) {
                    return null;
                }
                node.setLargestDistribution(pairAxisDiff[0], pairAxisDiff[1]);
            }
            return node;
        }
        MedianCutNode node1 = this.findLeafToBeSplit(node.getLeftSuccessor());
        boolean canSplit1 = node1 != null && node1.canBeSplit();
        MedianCutNode node2 = this.findLeafToBeSplit(node.getRightSuccessor());
        boolean bl = canSplit2 = node2 != null && node2.canBeSplit();
        if (canSplit1) {
            if (canSplit2) {
                if (node1.getDifferenceOfLargestDistribution() >= node2.getDifferenceOfLargestDistribution()) {
                    return node1;
                }
                return node2;
            }
            return node1;
        }
        if (canSplit2) {
            return node2;
        }
        return null;
    }

    public MedianCutNode findNearestNeighbor(int[] rgb) {
        MedianCutNode result = this.root;
        while (!result.isLeaf()) {
            result = result.getSuccessor(rgb);
        }
        return result;
    }

    public int findNearestNeighbor(MedianCutNode[] nodes, int red, int green, int blue) {
        int index = -1;
        double distance = 1000000.0;
        for (int i = 0; i < nodes.length; ++i) {
            MedianCutNode node = nodes[i];
            int[] reprColor = node.getRepresentativeColor();
            double d = RGBColor.computeDistance(red, green, blue, reprColor[0], reprColor[1], reprColor[2]);
            if (!(d < distance)) continue;
            distance = d;
            index = i;
        }
        return index;
    }

    public void findPalette() {
        for (int colorsLeft = this.paletteSize - 1; colorsLeft > 0; --colorsLeft) {
            MedianCutNode node = this.findLeafToBeSplit(this.root);
            this.splitNode(node);
        }
        this.findRepresentativeColors(this.root);
        this.setAllPaletteIndexValues();
    }

    public void findAllRepresentativeColors() {
        this.findRepresentativeColors(this.root);
    }

    private int[] findRepresentativeColor(int index1, int index2) {
        int[] result = new int[3];
        long[] temp = new long[]{0L, 0L, 0L};
        switch (this.method) {
            case 0: {
                int num = index2 - index1 + 1;
                for (int i = index1; i <= index2; ++i) {
                    RGBColor color = this.list.getColor(i);
                    temp[0] = temp[0] + (long)color.getSample(0);
                    temp[1] = temp[1] + (long)color.getSample(1);
                    temp[2] = temp[2] + (long)color.getSample(2);
                }
                result[0] = (int)(temp[0] / (long)num);
                result[1] = (int)(temp[1] / (long)num);
                result[2] = (int)(temp[2] / (long)num);
                return result;
            }
            case 1: {
                long num = 0L;
                for (int i = index1; i <= index2; ++i) {
                    RGBColor color = this.list.getColor(i);
                    int counter = color.getCounter();
                    temp[0] = temp[0] + (long)(color.getSample(0) * counter);
                    temp[1] = temp[1] + (long)(color.getSample(1) * counter);
                    temp[2] = temp[2] + (long)(color.getSample(2) * counter);
                    num += (long)counter;
                }
                if (num == 0L) {
                    return null;
                }
                result[0] = (int)(temp[0] / num);
                result[1] = (int)(temp[1] / num);
                result[2] = (int)(temp[2] / num);
                return result;
            }
            case 2: {
                RGBColor color = this.list.getColor((index1 + index2) / 2);
                result[0] = color.getSample(0);
                result[1] = color.getSample(1);
                result[2] = color.getSample(2);
                return result;
            }
        }
        throw new IllegalStateException("Unknown method for determining a representative color.");
    }

    private void findRepresentativeColors(MedianCutNode node) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            node.setRepresentativeColor(this.findRepresentativeColor(node.getLeftIndex(), node.getRightIndex()));
        } else {
            this.findRepresentativeColors(node.getLeftSuccessor());
            this.findRepresentativeColors(node.getRightSuccessor());
        }
    }

    public int getMethodToDetermineRepresentativeColors() {
        return this.method;
    }

    public int getPaletteSize() {
        return this.paletteSize;
    }

    public boolean getTruecolorOutput() {
        return this.outputTruecolor;
    }

    public int map(int[] origRgb, int[] quantizedRgb) {
        MedianCutNode node = this.findNearestNeighbor(origRgb);
        int[] reprColor = node.getRepresentativeColor();
        quantizedRgb[0] = reprColor[0];
        quantizedRgb[1] = reprColor[1];
        quantizedRgb[2] = reprColor[2];
        return node.getPaletteIndex();
    }

    public void mapImage(RGB24Image in, RGB24Image out) {
        int[] rgb = new int[3];
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                rgb[0] = in.getSample(0, x, y);
                rgb[1] = in.getSample(1, x, y);
                rgb[2] = in.getSample(2, x, y);
                MedianCutNode node = this.findNearestNeighbor(rgb);
                int[] reprColor = node.getRepresentativeColor();
                out.putSample(0, x, y, reprColor[0]);
                out.putSample(1, x, y, reprColor[1]);
                out.putSample(2, x, y, reprColor[2]);
            }
        }
    }

    public void mapImage(RGB24Image in, Paletted8Image out) {
        int[] rgb = new int[3];
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                rgb[0] = in.getSample(0, x, y);
                rgb[1] = in.getSample(1, x, y);
                rgb[2] = in.getSample(2, x, y);
                MedianCutNode node = this.findNearestNeighbor(rgb);
                out.putSample(0, x, y, node.getPaletteIndex());
            }
        }
    }

    public void process() throws MissingParameterException, OperationFailedException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        if (!(in instanceof RGB24Image)) {
            throw new WrongParameterException("Input image must implement RGB24Image.");
        }
        this.list = this.createColorList((RGB24Image)in);
        this.root = new MedianCutNode(null, 0, this.list.getNumEntries() - 1);
        this.root.setMinColor(0, 0, 0);
        this.root.setMaxColor(this.maxValue, this.maxValue, this.maxValue);
        this.findPalette();
        if (this.doNotMap) {
            return;
        }
        PixelImage out = this.getOutputImage();
        if (this.getTruecolorOutput()) {
            if (out == null) {
                out = in.createCompatibleImage(in.getWidth(), in.getHeight());
                this.setOutputImage(out);
            } else if (!(out instanceof RGB24Image)) {
                throw new WrongParameterException("Output image must implement RGB24Image.");
            }
            this.mapImage((RGB24Image)in, (RGB24Image)out);
        } else {
            Palette palette = this.createPalette();
            if (out == null) {
                out = new MemoryPaletted8Image(in.getWidth(), in.getHeight(), palette);
                this.setOutputImage(out);
            } else if (out instanceof Paletted8Image) {
                ((Paletted8Image)out).setPalette(palette);
            } else {
                throw new WrongParameterException("Output image must implement Paletted8Image.");
            }
            this.mapImage((RGB24Image)in, (Paletted8Image)out);
        }
    }

    public void setAllPaletteIndexValues() {
        int paletteEntriesAssigned = this.setPaletteIndexValues(this.root, 0);
        if (paletteEntriesAssigned != this.paletteSize) {
            throw new IllegalStateException("Assigning palette values did not result in correct number of entries.");
        }
    }

    public void setMapping(boolean doMap) {
        this.doNotMap = !doMap;
    }

    public void setMethodToDetermineRepresentativeColors(int newMethod) {
        if (newMethod != 0 && newMethod != 1 && newMethod != 2) {
            throw new IllegalArgumentException("Method must be one of the METHOD_xyz constants.");
        }
        this.method = newMethod;
    }

    private int setPaletteIndexValues(MedianCutNode node, int index) {
        if (node.isLeaf()) {
            node.setPaletteIndex(index);
            return ++index;
        }
        index = this.setPaletteIndexValues(node.getLeftSuccessor(), index);
        return this.setPaletteIndexValues(node.getRightSuccessor(), index);
    }

    public void setPaletteSize(int newPaletteSize) {
        if (newPaletteSize < 1) {
            throw new IllegalArgumentException("Palette size must be 1 or larger.");
        }
        if (newPaletteSize > 256) {
            throw new IllegalArgumentException("Palette size must be at most 256.");
        }
        this.paletteSize = newPaletteSize;
    }

    public void setTruecolorOutput(boolean useTruecolor) {
        this.outputTruecolor = useTruecolor;
    }

    public void splitNode(MedianCutNode node) {
        if (!node.isAxisDetermined()) {
            int[] pairAxisDiff = this.list.findExtrema(node.getLeftIndex(), node.getRightIndex());
            node.setLargestDistribution(pairAxisDiff[0], pairAxisDiff[1]);
        }
        this.list.sortByAxis(node.getLeftIndex(), node.getRightIndex(), node.getAxisOfLargestDistribution());
        int middleIndex = node.getMiddleIndex();
        int leftIndex = node.getLeftIndex();
        int rightIndex = node.getRightIndex();
        RGBColor color = this.list.getColor(middleIndex);
        int axis = node.getAxisOfLargestDistribution();
        int medianValue = color.getSample(axis);
        node.setMedianValue(medianValue);
        if (leftIndex == rightIndex) {
            throw new IllegalArgumentException("Cannot split leaf that only holds one color. This should never happen.");
        }
        MedianCutNode left = new MedianCutNode(node, leftIndex, middleIndex);
        MedianCutNode right = new MedianCutNode(node, middleIndex + 1, rightIndex);
        node.setSuccessors(left, right);
        for (int i = 0; i < 3; ++i) {
            int max = node.getMaxColorSample(i);
            left.setMaxColorSample(i, max);
            right.setMaxColorSample(i, max);
            int min = node.getMinColorSample(i);
            left.setMinColorSample(i, min);
            right.setMinColorSample(i, min);
        }
        left.setMaxColorSample(axis, medianValue);
        right.setMinColorSample(axis, medianValue + 1);
    }
}

