/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.promotion;

import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class PromotionRGB24
extends ImageToImageOperation {
    private void prepare(PixelImage in) throws MissingParameterException, WrongParameterException {
        if (in == null) {
            throw new MissingParameterException("Missing input image.");
        }
        if (!(in instanceof BilevelImage || in instanceof Paletted8Image || in instanceof Gray8Image)) {
            throw new WrongParameterException("Unsupported input image type: " + in.getClass().getName());
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            this.setOutputImage(new MemoryRGB24Image(in.getWidth(), in.getHeight()));
        } else {
            if (!(out instanceof RGB24Image)) {
                throw new WrongParameterException("Specified output image type must be of class RGB24Image; got " + in.getClass().getName());
            }
            if (in.getWidth() != out.getWidth()) {
                throw new WrongParameterException("Specified output image must have same width as input image.");
            }
            if (in.getHeight() != out.getHeight()) {
                throw new WrongParameterException("Specified output image must have same height as input image.");
            }
        }
    }

    private void process(BilevelImage in, RGB24Image out) {
        int HEIGHT = in.getHeight();
        int MAX = -1;
        boolean MIN = false;
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                if (in.isBlack(x, y)) {
                    out.putByteSample(0, x, y, (byte)0);
                    out.putByteSample(1, x, y, (byte)0);
                    out.putByteSample(2, x, y, (byte)0);
                    continue;
                }
                out.putByteSample(0, x, y, (byte)-1);
                out.putByteSample(1, x, y, (byte)-1);
                out.putByteSample(2, x, y, (byte)-1);
            }
            this.setProgress(y, HEIGHT);
        }
    }

    private void process(Paletted8Image in, RGB24Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        Palette PAL = in.getPalette();
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                int value = in.getSample(0, x, y);
                out.putSample(0, x, y, PAL.getSample(0, value));
                out.putSample(1, x, y, PAL.getSample(1, value));
                out.putSample(2, x, y, PAL.getSample(2, value));
            }
            this.setProgress(y, HEIGHT);
        }
    }

    private void process(Gray8Image in, RGB24Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                int value = in.getSample(0, x, y);
                out.putSample(0, x, y, value);
                out.putSample(1, x, y, value);
                out.putSample(2, x, y, value);
            }
            this.setProgress(y, HEIGHT);
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        PixelImage in = this.getInputImage();
        this.prepare(in);
        RGB24Image out = (RGB24Image)this.getOutputImage();
        if (in instanceof BilevelImage) {
            this.process((BilevelImage)in, out);
        } else if (in instanceof Gray8Image) {
            this.process((Gray8Image)in, out);
        } else if (in instanceof Paletted8Image) {
            this.process((Paletted8Image)in, out);
        }
    }
}

