/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.dithering;

import net.sourceforge.jiu.color.quantization.UniformPaletteQuantizer;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class OrderedDither
extends ImageToImageOperation
implements RGBIndex {
    private int[] values;
    private int valueWidth;
    private int valueHeight;
    private int grayBits = 3;
    private int redBits = 3;
    private int greenBits = 3;
    private int blueBits = 2;

    private void process(Gray8Image in, Gray8Image out) {
        if (out == null) {
            out = new MemoryGray8Image(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        int D1 = 4;
        int D2 = 4;
        int D1D2 = D1 * D2;
        int[] DITHER_MATRIX = new int[]{0, 8, 2, 10, 12, 4, 14, 6, 3, 11, 1, 9, 15, 7, 13, 5};
        int SPACE = 255 / ((1 << this.grayBits) - 1);
        int SHIFT = 8 - this.grayBits;
        int NUM_VALUES = 1 << this.grayBits;
        byte[] OUTPUT_SAMPLES = new byte[NUM_VALUES];
        for (int i = 0; i < OUTPUT_SAMPLES.length; ++i) {
            OUTPUT_SAMPLES[i] = (byte)(i * 255 / NUM_VALUES);
        }
        int[] DITHER_SIGNAL = new int[D1D2];
        for (int i = 0; i < D1D2; ++i) {
            DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * SPACE / (2 * D1D2);
        }
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int rowOffset = 0;
        for (int y = 0; y < HEIGHT; ++y) {
            int offset = rowOffset;
            int MAX_OFFSET = rowOffset + D1;
            for (int x = 0; x < WIDTH; ++x) {
                int sample = in.getSample(0, x, y);
                sample += DITHER_SIGNAL[offset++];
                if (offset == MAX_OFFSET) {
                    offset = rowOffset;
                }
                if (sample < 0) {
                    sample = 0;
                } else if (sample > 255) {
                    sample = 255;
                }
                out.putByteSample(0, x, y, OUTPUT_SAMPLES[sample >> SHIFT]);
            }
            if ((rowOffset += D1) >= DITHER_SIGNAL.length) {
                rowOffset = 0;
            }
            this.setProgress(y, HEIGHT);
        }
    }

    private void process(Gray8Image in, BilevelImage out) {
        if (out == null) {
            out = new MemoryBilevelImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        if (this.values == null) {
            this.setStandardThresholdValues();
        }
        out.clear(0);
        int rowOffset = 0;
        int HEIGHT = in.getHeight();
        for (int y = 0; y < HEIGHT; ++y) {
            int offset = rowOffset;
            int MAX_OFFSET = rowOffset + this.valueWidth;
            for (int x = 0; x < in.getWidth(); ++x) {
                if (in.getSample(x, y) >= this.values[offset++]) {
                    out.putWhite(x, y);
                }
                if (offset != MAX_OFFSET) continue;
                offset = rowOffset;
            }
            this.setProgress(y, HEIGHT);
            if ((rowOffset += this.valueWidth) < this.values.length) continue;
            rowOffset = 0;
        }
    }

    private void process(RGB24Image in, Paletted8Image out) {
        UniformPaletteQuantizer upq = new UniformPaletteQuantizer(this.redBits, this.greenBits, this.blueBits);
        if (out == null) {
            out = new MemoryPaletted8Image(in.getWidth(), in.getHeight(), upq.createPalette());
            this.setOutputImage(out);
        }
        int D1 = 4;
        int D2 = 4;
        int D1D2 = D1 * D2;
        int[] DITHER_MATRIX = new int[]{0, 8, 2, 10, 12, 4, 14, 6, 3, 11, 1, 9, 15, 7, 13, 5};
        int RED_SPACE = 255 / ((1 << this.redBits) - 1);
        int GREEN_SPACE = 255 / ((1 << this.greenBits) - 1);
        int BLUE_SPACE = 255 / ((1 << this.blueBits) - 1);
        int[] RED_DITHER_SIGNAL = new int[D1D2];
        int[] GREEN_DITHER_SIGNAL = new int[D1D2];
        int[] BLUE_DITHER_SIGNAL = new int[D1D2];
        for (int i = 0; i < D1D2; ++i) {
            RED_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * RED_SPACE / (2 * D1D2);
            GREEN_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * GREEN_SPACE / (2 * D1D2);
            BLUE_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * BLUE_SPACE / (2 * D1D2);
        }
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int rowOffset = 0;
        for (int y = 0; y < HEIGHT; ++y) {
            int offset = rowOffset;
            int MAX_OFFSET = rowOffset + D1;
            for (int x = 0; x < WIDTH; ++x) {
                int redSample = in.getSample(0, x, y);
                if ((redSample += RED_DITHER_SIGNAL[offset]) < 0) {
                    redSample = 0;
                } else if (redSample > 255) {
                    redSample = 255;
                }
                int greenSample = in.getSample(1, x, y);
                if ((greenSample += GREEN_DITHER_SIGNAL[offset]) < 0) {
                    greenSample = 0;
                } else if (greenSample > 255) {
                    greenSample = 255;
                }
                int blueSample = in.getSample(2, x, y);
                if ((blueSample += BLUE_DITHER_SIGNAL[offset]) < 0) {
                    blueSample = 0;
                } else if (blueSample > 255) {
                    blueSample = 255;
                }
                out.putSample(0, x, y, upq.mapToIndex(redSample, greenSample, blueSample));
                if (++offset != MAX_OFFSET) continue;
                offset = rowOffset;
            }
            if ((rowOffset += D1) >= DITHER_MATRIX.length) {
                rowOffset = 0;
            }
            this.setProgress(y, HEIGHT);
        }
    }

    private void process(RGB24Image in, RGB24Image out) {
        if (out == null) {
            out = new MemoryRGB24Image(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        int D1 = 4;
        int D2 = 4;
        int D1D2 = D1 * D2;
        int[] DITHER_MATRIX = new int[]{0, 8, 2, 10, 12, 4, 14, 6, 3, 11, 1, 9, 15, 7, 13, 5};
        int RED_SPACE = 255 / ((1 << this.redBits) - 1);
        int GREEN_SPACE = 255 / ((1 << this.greenBits) - 1);
        int BLUE_SPACE = 255 / ((1 << this.blueBits) - 1);
        int RED_SHIFT = 8 - this.redBits;
        int GREEN_SHIFT = 8 - this.greenBits;
        int BLUE_SHIFT = 8 - this.blueBits;
        int MAX_RED = (1 << this.redBits) - 1;
        int MAX_GREEN = (1 << this.greenBits) - 1;
        int MAX_BLUE = (1 << this.blueBits) - 1;
        int[] RED_DITHER_SIGNAL = new int[D1D2];
        int[] GREEN_DITHER_SIGNAL = new int[D1D2];
        int[] BLUE_DITHER_SIGNAL = new int[D1D2];
        for (int i = 0; i < D1D2; ++i) {
            RED_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * RED_SPACE / (2 * D1D2);
            GREEN_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * GREEN_SPACE / (2 * D1D2);
            BLUE_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * BLUE_SPACE / (2 * D1D2);
        }
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int rowOffset = 0;
        for (int y = 0; y < HEIGHT; ++y) {
            int offset = rowOffset;
            int MAX_OFFSET = rowOffset + D1;
            for (int x = 0; x < WIDTH; ++x) {
                int redSample = in.getSample(0, x, y);
                if ((redSample += RED_DITHER_SIGNAL[offset]) < 0) {
                    redSample = 0;
                } else if (redSample > 255) {
                    redSample = 255;
                }
                out.putSample(0, x, y, (redSample >>= RED_SHIFT) * 255 / MAX_RED);
                int greenSample = in.getSample(1, x, y);
                if ((greenSample += GREEN_DITHER_SIGNAL[offset]) < 0) {
                    greenSample = 0;
                } else if (greenSample > 255) {
                    greenSample = 255;
                }
                out.putSample(1, x, y, (greenSample >>= GREEN_SHIFT) * 255 / MAX_GREEN);
                int blueSample = in.getSample(2, x, y);
                if ((blueSample += BLUE_DITHER_SIGNAL[offset]) < 0) {
                    blueSample = 0;
                } else if (blueSample > 255) {
                    blueSample = 255;
                }
                out.putSample(2, x, y, (blueSample >>= BLUE_SHIFT) * 255 / MAX_BLUE);
                if (++offset != MAX_OFFSET) continue;
                offset = rowOffset;
            }
            if ((rowOffset += D1) >= DITHER_MATRIX.length) {
                rowOffset = 0;
            }
            this.setProgress(y, HEIGHT);
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        PixelImage out = this.getOutputImage();
        if (in instanceof RGB24Image) {
            int sum = this.redBits + this.greenBits + this.blueBits;
            if (sum > 8) {
                this.process((RGB24Image)in, (RGB24Image)out);
            } else {
                this.process((RGB24Image)in, (Paletted8Image)out);
            }
        } else if (this.grayBits == 1) {
            this.process((Gray8Image)in, (BilevelImage)out);
        } else if (this.grayBits >= 2 && this.grayBits <= 7) {
            this.process((Gray8Image)in, (Gray8Image)out);
        }
    }

    public void setOutputBits(int bits) {
        if (bits < 1 || bits > 7) {
            throw new IllegalArgumentException("Grayscale output bits must be from 1..7; got " + bits);
        }
        this.grayBits = bits;
    }

    public void setRgbBits(int red, int green, int blue) {
        if (red <= 0 || green <= 0 || blue <= 0) {
            throw new IllegalArgumentException("All parameters must be 1 or larger.");
        }
        this.redBits = red;
        this.greenBits = green;
        this.blueBits = blue;
    }

    public void setStandardThresholdValues() {
        int[] VALUES = new int[]{0, 192, 48, 240, 12, 204, 60, 252, 3, 195, 51, 243, 15, 207, 63, 255, 128, 64, 176, 112, 140, 76, 188, 124, 131, 67, 179, 115, 143, 79, 191, 127, 32, 224, 16, 208, 44, 236, 28, 220, 35, 227, 19, 211, 47, 239, 31, 223, 160, 96, 144, 80, 172, 108, 156, 92, 163, 99, 147, 83, 175, 111, 159, 95, 8, 200, 56, 248, 4, 196, 52, 244, 11, 203, 59, 251, 7, 199, 55, 247, 136, 72, 184, 120, 132, 68, 180, 116, 139, 75, 187, 123, 135, 71, 183, 119, 40, 232, 24, 216, 36, 228, 20, 212, 43, 235, 27, 219, 39, 231, 23, 215, 168, 104, 152, 88, 164, 100, 148, 84, 171, 107, 155, 91, 167, 103, 151, 87, 2, 194, 50, 242, 14, 206, 62, 254, 1, 193, 49, 241, 13, 205, 61, 253, 130, 66, 178, 114, 142, 78, 190, 126, 129, 65, 177, 113, 141, 77, 189, 125, 34, 226, 18, 210, 46, 238, 30, 222, 33, 225, 17, 209, 45, 237, 29, 221, 162, 98, 146, 82, 174, 110, 158, 94, 161, 97, 145, 81, 173, 109, 157, 93, 10, 202, 58, 250, 6, 198, 54, 246, 9, 201, 57, 249, 5, 197, 53, 245, 138, 74, 186, 122, 134, 70, 182, 118, 137, 73, 185, 121, 133, 69, 181, 117, 42, 234, 26, 218, 38, 230, 22, 214, 41, 233, 25, 217, 37, 229, 21, 213, 170, 106, 154, 90, 166, 102, 150, 86, 169, 105, 153, 89, 165, 101, 149, 85};
        this.setThresholdValues(VALUES, 16, 16);
    }

    public void setThresholdValues(int[] values, int valueWidth, int valueHeight) {
        if (values == null) {
            throw new IllegalArgumentException("The value array must be non-null.");
        }
        if (valueWidth < 1) {
            throw new IllegalArgumentException("The width argument must be at least 1.");
        }
        if (valueHeight < 1) {
            throw new IllegalArgumentException("The height argument must be at least 1.");
        }
        this.values = values;
        this.valueWidth = valueWidth;
        this.valueHeight = valueHeight;
        if (this.valueHeight * this.valueWidth < this.values.length) {
            throw new IllegalArgumentException("The array must have at least valuesWidth * valuesHeight elements..");
        }
    }
}

