/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.dithering;

import net.sourceforge.jiu.color.quantization.RGBQuantizer;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ErrorDiffusionDithering
extends ImageToImageOperation
implements RGBIndex {
    public static final int TYPE_FLOYD_STEINBERG = 0;
    public static final int TYPE_STUCKI = 1;
    public static final int TYPE_BURKES = 2;
    public static final int TYPE_SIERRA = 3;
    public static final int TYPE_JARVIS_JUDICE_NINKE = 4;
    public static final int TYPE_STEVENSON_ARCE = 5;
    public static final int DEFAULT_TYPE = 0;
    public static final int INDEX_X_POS = 0;
    public static final int INDEX_Y_POS = 1;
    public static final int INDEX_ERROR_NUMERATOR = 2;
    public static final int INDEX_ERROR_DENOMINATOR = 3;
    private static final int[][] FLOYD_STEINBERG_DATA = new int[][]{{1, 0, 7, 16}, {-1, 1, 3, 16}, {0, 1, 5, 16}, {1, 1, 1, 16}};
    private static final int[][] STUCKI_DATA = new int[][]{{1, 0, 8, 42}, {2, 0, 4, 42}, {-2, 1, 2, 42}, {-1, 1, 4, 42}, {0, 1, 8, 42}, {1, 1, 4, 42}, {2, 1, 2, 42}, {-2, 2, 1, 42}, {-1, 2, 2, 42}, {0, 2, 4, 42}, {1, 2, 2, 42}, {2, 2, 1, 42}};
    private static final int[][] BURKES_DATA = new int[][]{{1, 0, 8, 32}, {2, 0, 4, 32}, {-2, 1, 2, 32}, {-1, 1, 4, 32}, {0, 1, 8, 32}, {1, 1, 4, 32}, {2, 1, 2, 32}};
    private static final int[][] SIERRA_DATA = new int[][]{{1, 0, 5, 32}, {2, 1, 3, 32}, {-2, 1, 2, 32}, {-1, 1, 4, 32}, {0, 1, 5, 32}, {1, 1, 4, 32}, {2, 1, 2, 32}, {-1, 2, 2, 32}, {0, 2, 3, 32}, {1, 2, 2, 32}};
    private static final int[][] JARVIS_JUDICE_NINKE_DATA = new int[][]{{1, 0, 7, 48}, {2, 0, 5, 48}, {-2, 1, 3, 48}, {-1, 1, 5, 48}, {0, 1, 7, 48}, {1, 1, 5, 48}, {2, 1, 3, 48}, {-2, 2, 1, 48}, {-1, 2, 3, 48}, {0, 2, 5, 48}, {1, 2, 3, 48}, {2, 2, 1, 48}};
    private static final int[][] STEVENSON_ARCE_DATA = new int[][]{{2, 0, 32, 200}, {-3, 1, 12, 200}, {-1, 1, 26, 200}, {1, 1, 30, 200}, {3, 1, 16, 200}, {-2, 2, 12, 200}, {0, 2, 26, 200}, {2, 2, 12, 200}, {-3, 3, 5, 200}, {-1, 3, 12, 200}, {1, 3, 12, 200}, {3, 3, 5, 200}};
    private int grayBits;
    private int imageWidth;
    private int leftColumns;
    private int rightColumns;
    private int newWidth;
    private int numRows;
    private int[][] templateData;
    private int[] errorNum;
    private int[] errorDen;
    private int[] indexLut;
    private RGBQuantizer quantizer;
    private boolean useTruecolorOutput;

    public ErrorDiffusionDithering() {
        this.setTemplateType(0);
    }

    private static int adjust(int value, int max) {
        if (value <= 0) {
            return 0;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    private void fillBuffer(int channelIndex, int rowIndex, int[] dest, int destOffset) {
        IntegerImage in = (IntegerImage)this.getInputImage();
        int LAST = destOffset + this.imageWidth;
        int x = 0;
        while (destOffset != LAST) {
            dest[destOffset++] = in.getSample(channelIndex, x++, rowIndex);
        }
    }

    private void init(int[][] data, int imageWidth) {
        int i;
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        if (imageWidth < 1) {
            throw new IllegalArgumentException("Image width must be larger than 0.");
        }
        this.imageWidth = imageWidth;
        this.leftColumns = 0;
        this.rightColumns = 0;
        this.numRows = 1;
        this.errorNum = new int[data.length];
        this.errorDen = new int[data.length];
        for (i = 0; i < data.length; ++i) {
            int y;
            if (data[i] == null) {
                throw new IllegalArgumentException("Each int[] array of data must be initialized; array #" + i + " is not.");
            }
            if (data[i].length != 4) {
                throw new IllegalArgumentException("Each int[] array of data must be of length 4; array #" + i + " has length " + data[i].length + ".");
            }
            int x = data[i][0];
            if (x < 0) {
                if ((x = -x) > this.leftColumns) {
                    this.leftColumns = x;
                }
            } else if (x > 0 && x > this.rightColumns) {
                this.rightColumns = x;
            }
            if ((y = data[i][1]) < 0) {
                throw new IllegalArgumentException("The y values must be >= 0; that is not true for array index #" + i + ".");
            }
            if (y > this.numRows - 1) {
                this.numRows = y + 1;
            }
            if (x <= 0 && y == 0) {
                throw new IllegalArgumentException("If y is equal to 0, x must not be <= 0; this is true for array index #" + i + ".");
            }
            if (data[i][2] == 0 || data[i][3] == 0) {
                throw new IllegalArgumentException("Neither numerator nor denominator can be 0; this is the case for array index #" + i + ".");
            }
            this.errorNum[i] = data[i][2];
            this.errorDen[i] = data[i][3];
        }
        this.newWidth = imageWidth + this.leftColumns + this.rightColumns;
        this.indexLut = new int[data.length];
        for (i = 0; i < this.indexLut.length; ++i) {
            this.indexLut[i] = data[i][1] * this.newWidth + data[i][0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        PixelImage out = this.getOutputImage();
        if (in instanceof Gray8Image) {
            this.init(this.templateData, in.getWidth());
            if (this.grayBits == 1) {
                this.process((Gray8Image)in, (BilevelImage)out);
                return;
            } else {
                if (this.grayBits <= 1 || this.grayBits >= 8) throw new WrongParameterException("Cannot handle gray bits other than 1..7.");
                this.process((Gray8Image)in, (Gray8Image)out);
            }
            return;
        } else {
            if (!(in instanceof RGB24Image)) throw new WrongParameterException("Cannot handle this image: " + in.toString());
            this.init(this.templateData, in.getWidth());
            if (this.quantizer == null) {
                throw new MissingParameterException("No quantizer was specified.");
            }
            if (this.useTruecolorOutput) {
                this.process((RGB24Image)in, (RGB24Image)out);
                return;
            } else {
                this.process((RGB24Image)in, (Paletted8Image)out);
            }
        }
    }

    private void process(Gray8Image in, BilevelImage out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        if (out == null) {
            out = new MemoryBilevelImage(WIDTH, HEIGHT);
        }
        int NUM_ERROR_PIXELS = this.errorNum.length;
        int[] buffer = new int[this.newWidth * this.numRows];
        int n = Math.min(this.numRows, HEIGHT);
        int offset = this.leftColumns;
        int bufferYIndex = 0;
        while (n-- > 0) {
            this.fillBuffer(0, bufferYIndex++, buffer, offset);
            offset += this.newWidth;
        }
        int bufferLastRowOffset = offset - this.newWidth;
        out.clear(0);
        for (int y = 0; y < HEIGHT; ++y) {
            int bufferIndex = this.leftColumns;
            for (int x = 0; x < WIDTH; ++x) {
                int error;
                int value = buffer[bufferIndex];
                if (value < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                if ((value & 0x80) == 0) {
                    error = value;
                } else {
                    out.putWhite(x, y);
                    error = value - 255;
                }
                for (int i = 0; i < NUM_ERROR_PIXELS; ++i) {
                    int errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n2 = bufferIndex + this.indexLut[i];
                    buffer[n2] = buffer[n2] + errorPart;
                }
                ++bufferIndex;
            }
            int i = 0;
            for (int j = this.newWidth; j < buffer.length; ++j) {
                buffer[i] = buffer[j];
                ++i;
            }
            if (bufferYIndex < HEIGHT) {
                this.fillBuffer(0, bufferYIndex++, buffer, bufferLastRowOffset);
            }
            this.setProgress(y, HEIGHT);
        }
        this.setOutputImage(out);
    }

    private void process(Gray8Image in, Gray8Image out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int RIGHT_SHIFT = 8 - this.grayBits;
        int[] GRAY_LUT = new int[1 << this.grayBits];
        for (int i = 0; i < GRAY_LUT.length; ++i) {
            GRAY_LUT[i] = i * 255 / (GRAY_LUT.length - 1);
        }
        if (out == null) {
            out = new MemoryGray8Image(WIDTH, HEIGHT);
        }
        int NUM_ERROR_PIXELS = this.errorNum.length;
        int[] buffer = new int[this.newWidth * this.numRows];
        int n = Math.min(this.numRows, HEIGHT);
        int offset = this.leftColumns;
        int bufferYIndex = 0;
        while (n-- > 0) {
            this.fillBuffer(0, bufferYIndex++, buffer, offset);
            offset += this.newWidth;
        }
        int bufferLastRowOffset = offset - this.newWidth;
        for (int y = 0; y < HEIGHT; ++y) {
            int bufferIndex = this.leftColumns;
            for (int x = 0; x < WIDTH; ++x) {
                int value = buffer[bufferIndex];
                if (value < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                int quantized = GRAY_LUT[value >> RIGHT_SHIFT];
                out.putSample(0, x, y, quantized);
                int error = value - quantized;
                for (int i = 0; i < NUM_ERROR_PIXELS; ++i) {
                    int errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n2 = bufferIndex + this.indexLut[i];
                    buffer[n2] = buffer[n2] + errorPart;
                }
                ++bufferIndex;
            }
            int i = 0;
            for (int j = this.newWidth; j < buffer.length; ++j) {
                buffer[i] = buffer[j];
                ++i;
            }
            if (bufferYIndex < HEIGHT) {
                this.fillBuffer(0, bufferYIndex++, buffer, bufferLastRowOffset);
            }
            this.setProgress(y, HEIGHT);
        }
        this.setOutputImage(out);
    }

    private void process(RGB24Image in, Paletted8Image out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int MAX = 255;
        if (out == null) {
            out = new MemoryPaletted8Image(WIDTH, HEIGHT, this.quantizer.createPalette());
        }
        int NUM_ERROR_PIXELS = this.errorNum.length;
        int[] redBuffer = new int[this.newWidth * this.numRows];
        int[] greenBuffer = new int[this.newWidth * this.numRows];
        int[] blueBuffer = new int[this.newWidth * this.numRows];
        int n = Math.min(this.numRows, HEIGHT);
        int offset = this.leftColumns;
        int bufferYIndex = 0;
        while (n-- > 0) {
            this.fillBuffer(0, bufferYIndex, redBuffer, offset);
            this.fillBuffer(1, bufferYIndex, greenBuffer, offset);
            this.fillBuffer(2, bufferYIndex++, blueBuffer, offset);
            offset += this.newWidth;
        }
        int bufferLastRowOffset = offset - this.newWidth;
        int[] originalRgb = new int[3];
        int[] quantizedRgb = new int[3];
        for (int y = 0; y < HEIGHT; ++y) {
            int bufferIndex = this.leftColumns;
            for (int x = 0; x < WIDTH; ++x) {
                int errorPart;
                int i;
                originalRgb[0] = ErrorDiffusionDithering.adjust(redBuffer[bufferIndex], 255);
                originalRgb[1] = ErrorDiffusionDithering.adjust(greenBuffer[bufferIndex], 255);
                originalRgb[2] = ErrorDiffusionDithering.adjust(blueBuffer[bufferIndex], 255);
                int paletteIndex = this.quantizer.map(originalRgb, quantizedRgb);
                out.putSample(0, x, y, paletteIndex);
                int error = originalRgb[0] - quantizedRgb[0];
                for (i = 0; i < NUM_ERROR_PIXELS; ++i) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n2 = bufferIndex + this.indexLut[i];
                    redBuffer[n2] = redBuffer[n2] + errorPart;
                }
                error = originalRgb[1] - quantizedRgb[1];
                for (i = 0; i < NUM_ERROR_PIXELS; ++i) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n3 = bufferIndex + this.indexLut[i];
                    greenBuffer[n3] = greenBuffer[n3] + errorPart;
                }
                error = originalRgb[2] - quantizedRgb[2];
                for (i = 0; i < NUM_ERROR_PIXELS; ++i) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n4 = bufferIndex + this.indexLut[i];
                    blueBuffer[n4] = blueBuffer[n4] + errorPart;
                }
                ++bufferIndex;
            }
            System.arraycopy(redBuffer, this.newWidth, redBuffer, 0, redBuffer.length - this.newWidth);
            System.arraycopy(greenBuffer, this.newWidth, greenBuffer, 0, greenBuffer.length - this.newWidth);
            System.arraycopy(blueBuffer, this.newWidth, blueBuffer, 0, blueBuffer.length - this.newWidth);
            if (bufferYIndex < HEIGHT) {
                this.fillBuffer(0, bufferYIndex, redBuffer, bufferLastRowOffset);
                this.fillBuffer(1, bufferYIndex, greenBuffer, bufferLastRowOffset);
                this.fillBuffer(2, bufferYIndex++, blueBuffer, bufferLastRowOffset);
            }
            this.setProgress(y, HEIGHT);
        }
        this.setOutputImage(out);
    }

    private void process(RGB24Image in, RGB24Image out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int MAX = 255;
        if (out == null) {
            out = (RGB24Image)in.createCompatibleImage(WIDTH, HEIGHT);
        }
        int NUM_ERROR_PIXELS = this.errorNum.length;
        int[] redBuffer = new int[this.newWidth * this.numRows];
        int[] greenBuffer = new int[this.newWidth * this.numRows];
        int[] blueBuffer = new int[this.newWidth * this.numRows];
        int n = Math.min(this.numRows, HEIGHT);
        int offset = this.leftColumns;
        int bufferYIndex = 0;
        while (n-- > 0) {
            this.fillBuffer(0, bufferYIndex, redBuffer, offset);
            this.fillBuffer(1, bufferYIndex, greenBuffer, offset);
            this.fillBuffer(2, bufferYIndex++, blueBuffer, offset);
            offset += this.newWidth;
        }
        int bufferLastRowOffset = offset - this.newWidth;
        int[] originalRgb = new int[3];
        int[] quantizedRgb = new int[3];
        for (int y = 0; y < HEIGHT; ++y) {
            int bufferIndex = this.leftColumns;
            for (int x = 0; x < WIDTH; ++x) {
                int errorPart;
                int i;
                originalRgb[0] = ErrorDiffusionDithering.adjust(redBuffer[bufferIndex], 255);
                originalRgb[1] = ErrorDiffusionDithering.adjust(greenBuffer[bufferIndex], 255);
                originalRgb[2] = ErrorDiffusionDithering.adjust(blueBuffer[bufferIndex], 255);
                out.putSample(0, x, y, quantizedRgb[0]);
                out.putSample(1, x, y, quantizedRgb[1]);
                out.putSample(2, x, y, quantizedRgb[2]);
                int error = originalRgb[0] - quantizedRgb[0];
                for (i = 0; i < NUM_ERROR_PIXELS; ++i) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n2 = bufferIndex + this.indexLut[i];
                    redBuffer[n2] = redBuffer[n2] + errorPart;
                }
                error = originalRgb[1] - quantizedRgb[1];
                for (i = 0; i < NUM_ERROR_PIXELS; ++i) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n3 = bufferIndex + this.indexLut[i];
                    greenBuffer[n3] = greenBuffer[n3] + errorPart;
                }
                error = originalRgb[2] - quantizedRgb[2];
                for (i = 0; i < NUM_ERROR_PIXELS; ++i) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n4 = bufferIndex + this.indexLut[i];
                    blueBuffer[n4] = blueBuffer[n4] + errorPart;
                }
                ++bufferIndex;
            }
            System.arraycopy(redBuffer, this.newWidth, redBuffer, 0, redBuffer.length - this.newWidth);
            System.arraycopy(greenBuffer, this.newWidth, greenBuffer, 0, greenBuffer.length - this.newWidth);
            System.arraycopy(blueBuffer, this.newWidth, blueBuffer, 0, blueBuffer.length - this.newWidth);
            if (bufferYIndex < HEIGHT) {
                this.fillBuffer(0, bufferYIndex, redBuffer, bufferLastRowOffset);
                this.fillBuffer(1, bufferYIndex, greenBuffer, bufferLastRowOffset);
                this.fillBuffer(2, bufferYIndex++, blueBuffer, bufferLastRowOffset);
            }
            this.setProgress(y, HEIGHT);
        }
        this.setOutputImage(out);
    }

    public void setGrayscaleOutputBits(int numBits) {
        this.grayBits = numBits;
    }

    public void setQuantizer(RGBQuantizer q) {
        this.quantizer = q;
    }

    public void setTemplateData(int[][] data) {
        this.templateData = data;
    }

    public void setTruecolorOutput(boolean truecolor) {
        this.useTruecolorOutput = truecolor;
    }

    public void setTemplateType(int type) {
        switch (type) {
            case 0: {
                this.templateData = FLOYD_STEINBERG_DATA;
                break;
            }
            case 1: {
                this.templateData = STUCKI_DATA;
                break;
            }
            case 2: {
                this.templateData = BURKES_DATA;
                break;
            }
            case 3: {
                this.templateData = SIERRA_DATA;
                break;
            }
            case 4: {
                this.templateData = JARVIS_JUDICE_NINKE_DATA;
                break;
            }
            case 5: {
                this.templateData = STEVENSON_ARCE_DATA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown template type: " + type + ".");
            }
        }
    }
}

