/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.dithering;

import net.sourceforge.jiu.color.dithering.SpotFunction;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;
import net.sourceforge.jiu.util.ComparatorInterface;
import net.sourceforge.jiu.util.Sort;

public class ClusteredDotDither
extends ImageToImageOperation {
    private int ditherHeight;
    private int ditherWidth;
    private int[] ditherData;

    public void process() throws MissingParameterException, WrongParameterException {
        if (this.ditherData == null) {
            this.setDefaults();
        }
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        if (!(in instanceof GrayIntegerImage)) {
            throw new WrongParameterException("Input image must implement GrayIntegerImage.");
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            out = new MemoryBilevelImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        } else {
            if (!(out instanceof BilevelImage)) {
                throw new WrongParameterException("Output image must implement BilevelImage.");
            }
            this.ensureOutputImageResolution(in.getWidth(), in.getHeight());
        }
        this.process((GrayIntegerImage)in, (BilevelImage)out);
    }

    private void process(GrayIntegerImage in, BilevelImage out) {
        int maxTableValue = 1;
        for (int i = 0; i < this.ditherData.length; ++i) {
            if (this.ditherData[i] <= maxTableValue) continue;
            maxTableValue = this.ditherData[i];
        }
        ++maxTableValue;
        int MAX_SAMPLE = in.getMaxSample(0) + 1;
        int[] data = new int[this.ditherData.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.ditherData[i] * MAX_SAMPLE / maxTableValue;
        }
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        for (int y = 0; y < HEIGHT; ++y) {
            int ditherOffset = y % this.ditherHeight * this.ditherWidth;
            int samplesLeft = this.ditherWidth;
            for (int x = 0; x < WIDTH; ++x) {
                if (in.getSample(0, x, y) >= data[ditherOffset++]) {
                    out.putWhite(x, y);
                } else {
                    out.putBlack(x, y);
                }
                if (--samplesLeft != 0) continue;
                samplesLeft = this.ditherWidth;
                ditherOffset -= this.ditherWidth;
            }
            this.setProgress(y, HEIGHT);
        }
    }

    private void setDefaults() {
        this.setOrder3DitherMatrix();
    }

    public void setDitherMatrix(int width, int height, int[] data) {
        if (width < 1) {
            throw new IllegalArgumentException("Width must be one or larger.");
        }
        if (height < 1) {
            throw new IllegalArgumentException("Height must be one or larger.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        if (data.length < width * height) {
            throw new IllegalArgumentException("Data must have at least width times height entries.");
        }
        this.ditherWidth = width;
        this.ditherHeight = height;
        this.ditherData = data;
    }

    public void setDitherMatrix(int width, int height, SpotFunction f) {
        int[] data = new int[width * height];
        class MatrixElement
        implements ComparatorInterface {
            int index;
            double value;

            MatrixElement() {
            }

            public int compare(Object o1, Object o2) {
                MatrixElement e1 = (MatrixElement)o1;
                MatrixElement e2 = (MatrixElement)o2;
                if (e1.value < e2.value) {
                    return -1;
                }
                if (e1.value == e2.value) {
                    return 0;
                }
                return 1;
            }
        }
        Object[] matrixElements = new MatrixElement[data.length];
        for (int i = 0; i < data.length; ++i) {
            matrixElements[i] = new MatrixElement();
            matrixElements[i].index = i;
        }
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double sx = ((double)x / (double)(width - 1) - 0.5) * 2.0;
                double sy = ((double)y / (double)(height - 1) - 0.5) * 2.0;
                double value = f.compute(sx, sy);
                if (value < -1.0) {
                    value = -1.0;
                } else if (value > 1.0) {
                    value = 1.0;
                }
                ((MatrixElement)matrixElements[index++]).value = value;
            }
        }
        boolean balanced = f.isBalanced();
        if (!balanced) {
            Sort.sort(matrixElements, matrixElements[0]);
        }
        for (int i = 0; i < data.length; ++i) {
            Object elem = matrixElements[i];
            data[((MatrixElement)elem).index] = balanced ? (int)(((MatrixElement)elem).value * 254.0) : i * 255 / data.length;
        }
        this.setDitherMatrix(width, height, data);
    }

    public void setOrder3DitherMatrix() {
        this.setDitherMatrix(6, 6, new int[]{9, 11, 10, 8, 6, 7, 12, 17, 16, 5, 0, 1, 13, 14, 15, 4, 3, 2, 8, 6, 7, 9, 11, 10, 5, 0, 1, 12, 17, 16, 4, 3, 2, 13, 14, 15});
    }

    public void setOrder4DitherMatrix() {
        this.setDitherMatrix(8, 8, new int[]{18, 20, 19, 16, 13, 11, 12, 15, 27, 28, 29, 22, 4, 3, 2, 9, 26, 31, 30, 21, 5, 0, 1, 10, 23, 25, 24, 17, 8, 6, 7, 14, 13, 11, 12, 15, 18, 20, 19, 16, 4, 3, 2, 9, 27, 28, 29, 22, 5, 0, 1, 10, 26, 31, 30, 21, 8, 6, 7, 14, 23, 25, 24, 17});
    }

    public void setOrder8DitherMatrix() {
        this.setDitherMatrix(16, 16, new int[]{64, 69, 77, 87, 86, 76, 68, 67, 63, 58, 50, 40, 41, 51, 59, 60, 70, 94, 100, 109, 108, 99, 93, 75, 57, 33, 27, 18, 19, 28, 34, 52, 78, 101, 114, 116, 115, 112, 98, 83, 49, 26, 13, 11, 12, 15, 29, 44, 88, 110, 123, 124, 125, 118, 107, 85, 39, 17, 4, 3, 2, 9, 20, 42, 89, 111, 122, 127, 126, 117, 106, 84, 38, 16, 5, 0, 1, 10, 21, 43, 79, 102, 119, 121, 120, 113, 97, 82, 48, 25, 8, 6, 7, 14, 30, 45, 71, 95, 103, 104, 105, 96, 92, 74, 56, 32, 24, 23, 22, 31, 35, 53, 65, 72, 80, 90, 91, 81, 73, 66, 62, 55, 47, 37, 36, 46, 54, 61, 63, 58, 50, 40, 41, 51, 59, 60, 64, 69, 77, 87, 86, 76, 68, 67, 57, 33, 27, 18, 19, 28, 34, 52, 70, 94, 100, 109, 108, 99, 93, 75, 49, 26, 13, 11, 12, 15, 29, 44, 78, 101, 114, 116, 115, 112, 98, 83, 39, 17, 4, 3, 2, 9, 20, 42, 88, 110, 123, 124, 125, 118, 107, 85, 38, 16, 5, 0, 1, 10, 21, 43, 89, 111, 122, 127, 126, 117, 106, 84, 48, 25, 8, 6, 7, 14, 30, 45, 79, 102, 119, 121, 120, 113, 97, 82, 56, 32, 24, 23, 22, 31, 35, 53, 71, 95, 103, 104, 105, 96, 92, 74, 62, 55, 47, 37, 36, 46, 54, 61, 65, 72, 80, 90, 91, 81, 73, 66});
    }
}

