/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.data;

import java.util.Hashtable;
import net.sourceforge.jiu.color.data.Histogram3D;
import net.sourceforge.jiu.color.data.Histogram3DNode;

public class OnDemandHistogram3D
implements Histogram3D {
    private Hashtable hash;
    private int numUniqueValues;
    private final int maxValue1;
    private final int maxValue2;
    private final int maxValue3;

    public OnDemandHistogram3D(int max1, int max2, int max3) {
        if (max1 < 1 || max2 < 1 || max3 < 1) {
            throw new IllegalArgumentException("All max arguments must be 1 or larger.");
        }
        this.maxValue1 = max1;
        this.maxValue2 = max2;
        this.maxValue3 = max3;
        this.clear();
    }

    public void clear() {
        if (this.hash == null) {
            this.hash = new Hashtable();
        } else {
            this.hash.clear();
        }
        this.numUniqueValues = 0;
    }

    private Histogram3DNode createNode(int v1, int v2, int v3) {
        if (v1 >= 0 && v2 >= 0 && v3 >= 0 && v1 <= this.maxValue1 && v2 <= this.maxValue2 && v3 <= this.maxValue3) {
            return new Histogram3DNode(v1, v2, v3);
        }
        throw new IllegalArgumentException("At least one of the arguments was not in its valid 0..max range.");
    }

    public int getEntry(int index1, int index2, int index3) {
        Histogram3DNode searchNode = this.createNode(index1, index2, index3);
        Histogram3DNode counter = (Histogram3DNode)this.hash.get(searchNode);
        if (counter == null) {
            return 0;
        }
        return counter.getCounter();
    }

    public int getMaxValue(int index) throws IllegalArgumentException {
        switch (index) {
            case 0: {
                return this.maxValue1;
            }
            case 1: {
                return this.maxValue2;
            }
            case 2: {
                return this.maxValue3;
            }
        }
        throw new IllegalArgumentException("Not a valid index, must be from 0 to 2: " + index);
    }

    public int getNumUsedEntries() {
        return this.numUniqueValues;
    }

    public void increaseEntry(int index1, int index2, int index3) {
        Histogram3DNode searchNode = this.createNode(index1, index2, index3);
        Histogram3DNode counter = (Histogram3DNode)this.hash.get(searchNode);
        if (counter == null) {
            searchNode.setCounter(1);
            this.hash.put(searchNode, searchNode);
            ++this.numUniqueValues;
        } else {
            counter.increase();
        }
    }

    public void setEntry(int index1, int index2, int index3, int newValue) {
        Histogram3DNode searchNode = this.createNode(index1, index2, index3);
        Histogram3DNode counter = (Histogram3DNode)this.hash.get(searchNode);
        if (counter == null) {
            searchNode.setCounter(newValue);
            this.hash.put(searchNode, searchNode);
            ++this.numUniqueValues;
        } else {
            counter.setCounter(newValue);
        }
    }
}

