/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.data;

import net.sourceforge.jiu.color.data.Histogram3D;

public class NaiveHistogram3D
implements Histogram3D {
    private int[][][] data;
    private int[] values;

    public NaiveHistogram3D(int numValuesLevel1, int numValuesLevel2, int numValuesLevel3) throws IllegalArgumentException, OutOfMemoryError {
        if (numValuesLevel1 < 1) {
            throw new IllegalArgumentException("The number of values for level 1 must be at least 1; got " + numValuesLevel1);
        }
        if (numValuesLevel2 < 1) {
            throw new IllegalArgumentException("The number of values for level 2 must be at least 1; got " + numValuesLevel2);
        }
        if (numValuesLevel3 < 1) {
            throw new IllegalArgumentException("The number of values for level 3 must be at least 1; got " + numValuesLevel3);
        }
        this.values = new int[3];
        this.values[0] = numValuesLevel1;
        this.values[1] = numValuesLevel2;
        this.values[2] = numValuesLevel3;
        this.data = new int[this.values[0]][][];
        for (int i1 = 0; i1 < this.values[0]; ++i1) {
            this.data[i1] = new int[this.values[1]][];
            int i2 = 0;
            while (i2 < this.values[1]) {
                this.data[i1][i2] = new int[this.values[2]];
                ++i1;
            }
        }
        this.clear();
    }

    public NaiveHistogram3D(int numValues) throws IllegalArgumentException, OutOfMemoryError {
        this(numValues, numValues, numValues);
    }

    public void clear() {
        for (int i1 = 0; i1 < this.values[0]; ++i1) {
            for (int i2 = 0; i2 < this.values[1]; ++i2) {
                for (int i3 = 0; i3 < this.values[2]; ++i3) {
                    this.data[i1][i2][i3] = 0;
                }
            }
        }
    }

    public int getEntry(int index1, int index2, int index3) throws IllegalArgumentException {
        try {
            return this.data[index1][index2][index3];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Not a valid index (" + index1 + ", " + index2 + ", " + index3 + ")");
        }
    }

    public int getMaxValue(int index) throws IllegalArgumentException {
        if (index >= 0 && index <= 2) {
            return this.values[index] - 1;
        }
        throw new IllegalArgumentException("The index argument must be from 0 to 2; got " + index);
    }

    public int getNumUsedEntries() {
        int result = 0;
        for (int i1 = 0; i1 < this.values[0]; ++i1) {
            for (int i2 = 0; i2 < this.values[1]; ++i2) {
                for (int i3 = 0; i3 < this.values[2]; ++i3) {
                    if (this.data[i1][i2][i3] <= 0) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    public void increaseEntry(int index1, int index2, int index3) throws IllegalArgumentException {
        try {
            int[] nArray = this.data[index1][index2];
            int n = index3;
            nArray[n] = nArray[n] + 1;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Not a valid index (" + index1 + ", " + index2 + ", " + index3 + ")");
        }
    }

    public void setEntry(int index1, int index2, int index3, int newValue) throws IllegalArgumentException {
        try {
            this.data[index1][index2][index3] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Not a valid index (" + index1 + ", " + index2 + ", " + index3 + ")");
        }
    }
}

