/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.conversion;

public class LogLuvConversion {
    private static final double M_LN2 = 0.6931471805599453;
    private static final double UVSCALE = 410.0;
    private static final float UV_SQSIZ = 0.0035f;
    private static final int UV_NDIVS = 16289;
    private static final float UV_VSTART = 0.01694f;
    private static final int UV_NVS = 163;
    private static final double U_NEU = 0.210526316;
    private static final double V_NEU = 0.473684211;
    private static final double[] USTART = new double[]{0.247663, 0.243779, 0.241684, 0.237874, 0.235906, 0.232153, 0.228352, 0.226259, 0.222371, 0.22041, 0.21471, 0.212714, 0.210721, 0.204976, 0.202986, 0.199245, 0.195525, 0.19356, 0.189878, 0.186216, 0.186216, 0.182592, 0.179003, 0.175466, 0.172001, 0.172001, 0.168612, 0.168612, 0.163575, 0.158642, 0.158642, 0.158642, 0.153815, 0.153815, 0.149097, 0.149097, 0.142746, 0.142746, 0.142746, 0.13827, 0.13827, 0.13827, 0.132166, 0.132166, 0.126204, 0.126204, 0.126204, 0.120381, 0.120381, 0.120381, 0.120381, 0.112962, 0.112962, 0.112962, 0.10745, 0.10745, 0.10745, 0.10745, 0.100343, 0.100343, 0.100343, 0.095126, 0.095126, 0.095126, 0.095126, 0.088276, 0.088276, 0.088276, 0.088276, 0.081523, 0.081523, 0.081523, 0.081523, 0.074861, 0.074861, 0.074861, 0.074861, 0.06829, 0.06829, 0.06829, 0.06829, 0.063573, 0.063573, 0.063573, 0.063573, 0.057219, 0.057219, 0.057219, 0.057219, 0.050985, 0.050985, 0.050985, 0.050985, 0.050985, 0.044859, 0.044859, 0.044859, 0.044859, 0.040571, 0.040571, 0.040571, 0.040571, 0.036339, 0.036339, 0.036339, 0.036339, 0.032139, 0.032139, 0.032139, 0.032139, 0.027947, 0.027947, 0.027947, 0.023739, 0.023739, 0.023739, 0.023739, 0.019504, 0.019504, 0.019504, 0.016976, 0.016976, 0.016976, 0.016976, 0.012639, 0.012639, 0.012639, 0.009991, 0.009991, 0.009991, 0.009016, 0.009016, 0.009016, 0.006217, 0.006217, 0.005097, 0.005097, 0.005097, 0.003909, 0.003909, 0.00234, 0.002389, 0.001068, 0.001653, 7.17E-4, 0.001614, 2.7E-4, 4.84E-4, 0.001103, 0.001242, 0.001188, 0.001011, 7.09E-4, 3.01E-4, 0.002416, 0.003251, 0.003246, 0.004141, 0.005963, 0.008839, 0.01049, 0.016994, 0.023659};
    private static final short[] NCUM = new short[]{0, 4, 10, 17, 26, 36, 48, 62, 77, 94, 112, 133, 155, 178, 204, 231, 260, 291, 323, 357, 393, 429, 467, 507, 549, 593, 637, 683, 729, 778, 830, 882, 934, 989, 1044, 1102, 1160, 1222, 1284, 1346, 1411, 1476, 1541, 1610, 1679, 1752, 1825, 1898, 1975, 2052, 2129, 2206, 2288, 2370, 2452, 2538, 2624, 2710, 2796, 2887, 2978, 3069, 3164, 3259, 3354, 3449, 3549, 3649, 3749, 3849, 3954, 4059, 4164, 4269, 4379, 4489, 4599, 4709, 4824, 4939, 5054, 5169, 5288, 5407, 5526, 5645, 5769, 5893, 6017, 6141, 6270, 6399, 6528, 6657, 6786, 6920, 7054, 7188, 7322, 7460, 7598, 7736, 7874, 8016, 8158, 8300, 8442, 8588, 8734, 8880, 9026, 9176, 9326, 9476, 9630, 9784, 9938, 10092, 10250, 10408, 10566, 10727, 10888, 11049, 11210, 11375, 11540, 11705, 11873, 12041, 12209, 12379, 12549, 12719, 12892, 13065, 13240, 13415, 13590, 13767, 13944, 14121, 14291, 14455, 14612, 14762, 14905, 15041, 15170, 15293, 15408, 15517, 15620, 15717, 15806, 15888, 15964, 16033, 16095, 16150, 16197, 16237, 16268};

    private LogLuvConversion() {
    }

    public static double convertLogL10toY(int p10) {
        if (p10 == 0) {
            return 0.0;
        }
        return Math.exp(0.010830424696249145 * ((double)p10 + 0.5) - 8.317766166719343);
    }

    public static double convertLogL16toY(int p16) {
        int Le = p16 & Short.MAX_VALUE;
        if (Le == 0) {
            return 0.0;
        }
        double Y = Math.exp(0.0027076061740622863 * ((double)Le + 0.5) - 44.3614195558365);
        if ((p16 & 0x8000) == 0) {
            return Y;
        }
        return -Y;
    }

    private static byte convertDoubleToByte(double d) {
        if (d <= 0.0) {
            return 0;
        }
        if (d >= 1.0) {
            return -1;
        }
        double result = 255.0 * Math.sqrt(d);
        return (byte)result;
    }

    public static void convertLogLuv24InterleavedtoRGB24Planar(byte[] logluv, byte[] red, byte[] green, byte[] blue, int num) {
        int srcOffs = 0;
        int destOffs = 0;
        while (num-- != 0) {
            float X = 0.0f;
            float Y = 0.0f;
            float Z = 0.0f;
            int v1 = logluv[srcOffs++] & 0xFF;
            int v2 = logluv[srcOffs++] & 0xFF;
            int v3 = logluv[srcOffs++] & 0xFF;
            double L = LogLuvConversion.convertLogL10toY(v1 << 2 | v2 >> 6 & 3);
            if (L > 0.0) {
                int c = (v2 & 0x3F) << 8 | v3;
                double u = 0.210526316;
                double v = 0.473684211;
                int upper = 163;
                int lower = 0;
                if (c >= 0 && c < 16289) {
                    lower = 0;
                    upper = 163;
                    int ui = 0;
                    int vi = 0;
                    while (upper - lower > 1) {
                        vi = lower + upper >> 1;
                        ui = c - NCUM[vi];
                        if (ui > 0) {
                            lower = vi;
                            continue;
                        }
                        if (ui < 0) {
                            upper = vi;
                            continue;
                        }
                        lower = vi;
                        break;
                    }
                    vi = lower;
                    ui = c - NCUM[vi];
                    u = USTART[vi] + ((double)ui + 0.5) * (double)0.0035f;
                    v = (double)0.01694f + ((double)vi + 0.5) * (double)0.0035f;
                }
                double s = 1.0 / (6.0 * u - 16.0 * v + 12.0);
                double x = 9.0 * u * s;
                double y = 4.0 * v * s;
                X = (float)(x / y * L);
                Y = (float)L;
                Z = (float)((1.0 - x - y) / y * L);
            }
            double r = 2.69 * (double)X + -1.276 * (double)Y + -0.414 * (double)Z;
            double g = -1.022 * (double)X + 1.978 * (double)Y + 0.044 * (double)Z;
            double b = 0.061 * (double)X + -0.224 * (double)Y + 1.163 * (double)Z;
            red[destOffs] = LogLuvConversion.convertDoubleToByte(r);
            green[destOffs] = LogLuvConversion.convertDoubleToByte(g);
            blue[destOffs] = LogLuvConversion.convertDoubleToByte(b);
            ++destOffs;
        }
    }

    public static void convertLogLuv32InterleavedtoRGB24Planar(byte[] logluv, byte[] red, byte[] green, byte[] blue, int num) {
        int srcOffs = 0;
        int destOffs = 0;
        while (num-- != 0) {
            float X = 0.0f;
            float Y = 0.0f;
            float Z = 0.0f;
            int v1 = logluv[srcOffs++] & 0xFF;
            int n = srcOffs++;
            int v2 = logluv[n] & 0xFF;
            double L = LogLuvConversion.convertLogL16toY((short)(v1 << 8 | v2));
            if (L > 0.0) {
                double u = 0.0024390243902439024 * ((double)(logluv[srcOffs++] & 0xFF) + 0.5);
                double v = 0.0024390243902439024 * ((double)(logluv[srcOffs++] & 0xFF) + 0.5);
                double s = 1.0 / (6.0 * u - 16.0 * v + 12.0);
                double x = 9.0 * u * s;
                double y = 4.0 * v * s;
                X = (float)(x / y * L);
                Y = (float)L;
                Z = (float)((1.0 - x - y) / y * L);
            }
            double r = 2.69 * (double)X + -1.276 * (double)Y + -0.414 * (double)Z;
            double g = -1.022 * (double)X + 1.978 * (double)Y + 0.044 * (double)Z;
            double b = 0.061 * (double)X + -0.224 * (double)Y + 1.163 * (double)Z;
            red[destOffs] = LogLuvConversion.convertDoubleToByte(r);
            green[destOffs] = LogLuvConversion.convertDoubleToByte(g);
            blue[destOffs] = LogLuvConversion.convertDoubleToByte(b);
            ++destOffs;
        }
    }

    public static void convertLogL16toGray8(byte[] logl, byte[] gray, int num) {
        int srcOffs = 0;
        int destOffs = 0;
        while (num-- != 0) {
            int v1 = logl[srcOffs++] & 0xFF;
            int v2 = logl[srcOffs++] & 0xFF;
            double L = LogLuvConversion.convertLogL16toY((short)(v1 << 8 | v2));
            gray[destOffs++] = LogLuvConversion.convertDoubleToByte(L);
        }
    }
}

