/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.analysis;

import net.sourceforge.jiu.color.analysis.MatrixCreator;
import net.sourceforge.jiu.color.data.CoOccurrenceMatrix;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.Operation;

public class TextureAnalysis
extends Operation {
    private CoOccurrenceMatrix matrix;
    private int contrast;
    private double correlation;
    private int dissimilarity;
    private int energy;
    private double entropy;
    private double homogeneity;
    private int sum;
    private boolean symmetry;

    public static TextureAnalysis compute(CoOccurrenceMatrix matrix) throws MissingParameterException {
        TextureAnalysis op = new TextureAnalysis();
        op.setMatrix(matrix);
        op.process();
        return op;
    }

    public static TextureAnalysis compute(IntegerImage image, int channelIndex) throws MissingParameterException {
        CoOccurrenceMatrix matrix = MatrixCreator.createCoOccurrenceMatrix(image, channelIndex);
        return TextureAnalysis.compute(matrix);
    }

    public int getContrast() {
        return this.contrast;
    }

    public double getCorrelation() {
        return this.correlation;
    }

    public int getDissimilarity() {
        return this.dissimilarity;
    }

    public int getEnergy() {
        return this.energy;
    }

    public double getEntropy() {
        return this.entropy;
    }

    public double getHomogeneity() {
        return this.homogeneity;
    }

    public int getSum() {
        return this.sum;
    }

    public boolean isSymmetrical() {
        return this.symmetry;
    }

    public void process() throws MissingParameterException {
        double a;
        if (this.matrix == null) {
            throw new MissingParameterException("No input co-occurrence matrix was provided.");
        }
        int DIMENSION = this.matrix.getDimension();
        int items = 0;
        int TOTAL_ITEMS = DIMENSION * 3;
        double[] muI = new double[DIMENSION];
        double[] muJ = new double[DIMENSION];
        for (int k = 0; k < DIMENSION; ++k) {
            muI[k] = 0.0;
            muJ[k] = 0.0;
            for (int i = 0; i < DIMENSION; ++i) {
                for (int j = 0; j < DIMENSION; ++j) {
                    int value = this.matrix.getValue(i, j);
                    int n = k;
                    muI[n] = muI[n] + (double)(i * value);
                    int n2 = k;
                    muJ[n2] = muJ[n2] + (double)(j * value);
                }
            }
            this.setProgress(items++, TOTAL_ITEMS);
        }
        double[] sigmaI = new double[DIMENSION];
        double[] sigmaJ = new double[DIMENSION];
        for (int k = 0; k < DIMENSION; ++k) {
            sigmaI[k] = 0.0;
            sigmaJ[k] = 0.0;
            for (int i = 0; i < DIMENSION; ++i) {
                for (int j = 0; j < DIMENSION; ++j) {
                    int value = this.matrix.getValue(i, j);
                    a = (double)i - muI[i];
                    int n = k;
                    sigmaI[n] = sigmaI[n] + (double)value * a * a;
                    double b = (double)j - muJ[j];
                    int n3 = k;
                    sigmaJ[n3] = sigmaJ[n3] + (double)value * b * b;
                }
            }
            this.setProgress(items++, TOTAL_ITEMS);
        }
        this.contrast = 0;
        this.dissimilarity = 0;
        this.energy = 0;
        this.entropy = 0.0;
        this.homogeneity = 0.0;
        this.sum = 0;
        this.symmetry = true;
        for (int i = 0; i < DIMENSION; ++i) {
            for (int j = 0; j < DIMENSION; ++j) {
                int value = this.matrix.getValue(i, j);
                this.symmetry = this.symmetry && value == this.matrix.getValue(j, i);
                this.sum += value;
                this.energy += value * value;
                int diffAbs = i - j;
                if (diffAbs < 0) {
                    diffAbs = -diffAbs;
                }
                this.dissimilarity += diffAbs * value;
                this.contrast += diffAbs * diffAbs * value;
                if (value != 0) {
                    this.entropy += (double)value * Math.log(value);
                }
                this.homogeneity += (double)value / (1.0 + (double)diffAbs);
                a = sigmaI[i] * sigmaJ[j];
                if (a == 0.0) continue;
                this.correlation += (double)value * ((double)i - muI[i]) * ((double)j - muJ[j]) / Math.sqrt(a);
            }
            this.setProgress(items++, TOTAL_ITEMS);
        }
    }

    public void setMatrix(CoOccurrenceMatrix m) {
        this.matrix = m;
    }
}

