/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.analysis;

import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.Operation;
import net.sourceforge.jiu.ops.WrongParameterException;

public class MeanDifference
extends Operation {
    private double diff;
    private PixelImage image1;
    private PixelImage image2;

    public static Double compute(PixelImage image1, PixelImage image2) {
        MeanDifference diff = new MeanDifference();
        diff.setImages(image1, image2);
        try {
            diff.process();
            return new Double(diff.getDifference());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int computeDiff(int a, int b) {
        int diff = a - b;
        if (diff < 0) {
            return -diff;
        }
        return diff;
    }

    public double getDifference() {
        return this.diff;
    }

    public void process() throws MissingParameterException, WrongParameterException {
        boolean sameType;
        if (this.image1 == null) {
            throw new MissingParameterException("You must specify images using setImages.");
        }
        boolean bl = sameType = this.image1.getImageType() == this.image2.getImageType();
        if (this.image1 instanceof RGB24Image && this.image2 instanceof Paletted8Image) {
            this.process((RGB24Image)this.image1, (Paletted8Image)this.image2);
        } else if (this.image2 instanceof RGB24Image && this.image1 instanceof Paletted8Image) {
            this.process((RGB24Image)this.image2, (Paletted8Image)this.image1);
        } else if (sameType && this.image1 instanceof RGBIntegerImage) {
            this.process((RGBIntegerImage)this.image1, (RGBIntegerImage)this.image2);
        } else if (sameType && this.image1 instanceof GrayIntegerImage) {
            this.process((GrayIntegerImage)this.image1, (GrayIntegerImage)this.image2);
        } else {
            throw new WrongParameterException("Not a supported image type combination.");
        }
    }

    private void process(GrayIntegerImage image1, GrayIntegerImage image2) {
        int HEIGHT = image1.getHeight();
        int WIDTH = image1.getWidth();
        long sum = 0L;
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                sum += (long)MeanDifference.computeDiff(image1.getSample(x, y), image2.getSample(x, y));
            }
            this.setProgress(y, HEIGHT);
        }
        this.setDifference((double)sum / (double)(WIDTH * HEIGHT));
    }

    private void process(RGB24Image image1, Paletted8Image image2) {
        int HEIGHT = image1.getHeight();
        int WIDTH = image1.getWidth();
        long sum = 0L;
        Palette pal = image2.getPalette();
        int[] red = pal.getSamples(0);
        int[] green = pal.getSamples(1);
        int[] blue = pal.getSamples(2);
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                int palSample = image2.getSample(x, y);
                sum += (long)MeanDifference.computeDiff(image1.getSample(0, x, y), red[palSample]);
                sum += (long)MeanDifference.computeDiff(image1.getSample(1, x, y), green[palSample]);
                sum += (long)MeanDifference.computeDiff(image1.getSample(2, x, y), blue[palSample]);
            }
            this.setProgress(y, HEIGHT);
        }
        this.setDifference((double)sum / (double)(WIDTH * HEIGHT * 3));
    }

    private void process(RGBIntegerImage image1, RGBIntegerImage image2) {
        int HEIGHT = image1.getHeight();
        int WIDTH = image1.getWidth();
        long sum = 0L;
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                sum += (long)MeanDifference.computeDiff(image1.getSample(0, x, y), image2.getSample(0, x, y));
                sum += (long)MeanDifference.computeDiff(image1.getSample(1, x, y), image2.getSample(1, x, y));
                sum += (long)MeanDifference.computeDiff(image1.getSample(2, x, y), image2.getSample(2, x, y));
            }
            this.setProgress(y, HEIGHT);
        }
        this.setDifference((double)sum / (double)(WIDTH * HEIGHT * 3));
    }

    private void setDifference(double newValue) {
        this.diff = newValue;
    }

    public void setImages(PixelImage firstImage, PixelImage secondImage) {
        if (firstImage == null || secondImage == null) {
            throw new IllegalArgumentException("Both image arguments must be non-null.");
        }
        if (firstImage.getWidth() != secondImage.getWidth()) {
            throw new IllegalArgumentException("The images must have the same width.");
        }
        if (firstImage.getHeight() != secondImage.getHeight()) {
            throw new IllegalArgumentException("The images must have the same height.");
        }
        this.image1 = firstImage;
        this.image2 = secondImage;
    }
}

