/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.adjustment;

import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.LookupTableOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class GammaCorrection
extends LookupTableOperation {
    public static final double MAX_GAMMA = 10.0;
    private double gamma;

    private final int[] createLookupTable(int numSamples) {
        if (numSamples < 1) {
            throw new IllegalArgumentException("Number of samples argument must be one or larger.");
        }
        double g = 1.0 / this.gamma;
        int[] result = new int[numSamples];
        int MAX_SAMPLE = numSamples - 1;
        double MAX = MAX_SAMPLE;
        for (int i = 0; i < numSamples; ++i) {
            result[i] = (int)Math.round(MAX * Math.pow((double)i / MAX, g));
            if (result[i] < 0) {
                result[i] = 0;
            }
            if (result[i] <= MAX_SAMPLE) continue;
            result[i] = MAX_SAMPLE;
        }
        return result;
    }

    public double getGamma() {
        return this.gamma;
    }

    private void process(Paletted8Image in, Paletted8Image out) {
        if (out == null) {
            out = (Paletted8Image)in.createCompatibleImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        Palette palette = out.getPalette();
        int numSamples = palette.getMaxValue() + 1;
        int[] LUT = this.createLookupTable(numSamples);
        for (int c = 0; c < 3; ++c) {
            for (int i = 0; i < palette.getNumEntries(); ++i) {
                palette.putSample(c, i, LUT[palette.getSample(c, i)]);
            }
        }
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                out.putSample(x, y, in.getSample(x, y));
            }
            this.setProgress(y, in.getHeight());
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        if (in instanceof Paletted8Image) {
            this.process((Paletted8Image)this.getInputImage(), (Paletted8Image)this.getOutputImage());
        } else if (in instanceof GrayIntegerImage || in instanceof RGBIntegerImage) {
            this.setNumTables(in.getNumChannels());
            IntegerImage ii = (IntegerImage)in;
            for (int channelIndex = 0; channelIndex < in.getNumChannels(); ++channelIndex) {
                int numSamples = ii.getMaxSample(channelIndex) + 1;
                int[] table = this.createLookupTable(numSamples);
                this.setTable(channelIndex, table);
            }
            super.process();
        } else {
            throw new WrongParameterException("Unsupported image type: " + in.getClass().getName());
        }
    }

    public void setGamma(double newGamma) {
        if (newGamma <= 0.0) {
            throw new IllegalArgumentException("Gamma must be larger than 0.0; got " + newGamma);
        }
        if (newGamma > 10.0) {
            throw new IllegalArgumentException("Gamma must be at most 10.0; got " + newGamma);
        }
        this.gamma = newGamma;
    }
}

