/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.adjustment;

import net.sourceforge.jiu.color.analysis.Histogram1DCreator;
import net.sourceforge.jiu.color.data.Histogram1D;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.ops.LookupTableOperation;
import net.sourceforge.jiu.ops.OperationFailedException;

public class EqualizeHistogram
extends LookupTableOperation {
    public EqualizeHistogram(IntegerImage in) throws OperationFailedException {
        super(in.getNumChannels());
        this.setInputImage(in);
        this.initTables(in);
    }

    private void initTables(IntegerImage in) throws OperationFailedException {
        for (int channelIndex = 0; channelIndex < in.getNumChannels(); ++channelIndex) {
            Histogram1DCreator hc = new Histogram1DCreator();
            hc.setImage(in, channelIndex);
            hc.process();
            Histogram1D hist = hc.getHistogram();
            int MAX_SAMPLE = in.getMaxSample(channelIndex);
            int[] data = new int[MAX_SAMPLE + 1];
            int NUM_PIXELS = in.getWidth() * in.getHeight();
            long sum = 0L;
            for (int i = 0; i < data.length; ++i) {
                long result = (sum += (long)hist.getEntry(i)) * (long)MAX_SAMPLE / (long)NUM_PIXELS;
                if (result > Integer.MAX_VALUE) {
                    throw new IllegalStateException("Result does not fit into an int.");
                }
                data[i] = (int)result;
            }
            this.setTable(channelIndex, data);
        }
    }
}

