/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.adjustment;

import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.LookupTableOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Brightness
extends LookupTableOperation {
    private int brightness;

    public static PixelImage adjust(PixelImage input, int percentage) {
        try {
            Brightness brightness = new Brightness();
            brightness.setInputImage(input);
            brightness.setBrightness(percentage);
            brightness.process();
            return brightness.getOutputImage();
        }
        catch (Exception exc) {
            return null;
        }
    }

    private int[] createLookupTable(int numSamples, int brightness) {
        if (brightness < -100 || brightness > 100) {
            return null;
        }
        int[] result = new int[numSamples];
        int MAX = numSamples - 1;
        for (int i = 0; i < numSamples; ++i) {
            result[i] = brightness < 0 ? (int)((float)i * (100.0f + (float)brightness) / 100.0f) : (int)((float)i + (float)((MAX - i) * brightness) / 100.0f);
        }
        return result;
    }

    private void process(Paletted8Image in, Paletted8Image out) {
        if (out == null) {
            out = (Paletted8Image)in.createCompatibleImage(in.getWidth(), in.getHeight());
        }
        Palette palette = out.getPalette();
        int numSamples = palette.getNumEntries();
        int[] LUT = this.createLookupTable(numSamples, this.brightness);
        for (int c = 0; c < 3; ++c) {
            for (int i = 0; i < palette.getNumEntries(); ++i) {
                palette.putSample(c, i, LUT[palette.getSample(c, i)]);
            }
        }
        for (int y = 0; y < in.getHeight(); ++y) {
            for (int x = 0; x < in.getWidth(); ++x) {
                out.putSample(0, x, y, in.getSample(0, x, y));
            }
            this.setProgress(y, in.getHeight());
        }
        this.setOutputImage(out);
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.prepareImages();
        IntegerImage in = (IntegerImage)this.getInputImage();
        if (in instanceof GrayIntegerImage || in instanceof RGBIntegerImage) {
            this.setNumTables(in.getNumChannels());
            for (int channelIndex = 0; channelIndex < in.getNumChannels(); ++channelIndex) {
                this.setTable(channelIndex, this.createLookupTable(in.getMaxSample(channelIndex) + 1, this.brightness));
            }
            super.process();
        } else if (in instanceof Paletted8Image) {
            this.process((Paletted8Image)in, (Paletted8Image)this.getOutputImage());
        } else {
            throw new WrongParameterException("Brightness operation cannot operate on input image type: " + in.getClass());
        }
    }

    public void setBrightness(int newBrightness) {
        if (newBrightness < -100) {
            throw new IllegalArgumentException("Brightness must be at least -100: " + newBrightness);
        }
        if (newBrightness > 100) {
            throw new IllegalArgumentException("Brightness must be at most 100: " + newBrightness);
        }
        this.brightness = newBrightness;
    }
}

