/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.tiff;

import java.io.DataInput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoder;
import net.sourceforge.jiu.ops.MissingParameterException;

public class TIFFDecoderLogLuv
extends TIFFDecoder {
    private DataInput in;
    private int compressedSize;
    private int tileWidth;
    private boolean rle;

    public void decode() throws InvalidFileStructureException, IOException {
        byte[] row = new byte[this.getBytesPerRow()];
        this.rle = this.getImageFileDirectory().getCompression() == 34676;
        for (int y = this.getY1(); y <= this.getY2(); ++y) {
            this.decodeRow(row);
            this.putBytes(row, 0, row.length);
        }
    }

    private void decodeRow(byte[] row) throws InvalidFileStructureException, IOException {
        if (this.rle) {
            this.decodeRowRLE(row);
        } else {
            this.decodeRowPacked24(row);
        }
    }

    private void decodeRowPacked24(byte[] row) throws InvalidFileStructureException, IOException {
        int num = this.getImageFileDirectory().getTileWidth() * 3;
        this.in.readFully(row, 0, num);
    }

    private void decodeRowRLE(byte[] row) throws InvalidFileStructureException, IOException {
        int BYTES_PER_PIXEL = this.getImageFileDirectory().getPhotometricInterpretation() == 32844 ? 2 : 4;
        for (int initialOffset = 0; initialOffset < BYTES_PER_PIXEL; ++initialOffset) {
            int offset = initialOffset;
            int numPixels = this.tileWidth;
            do {
                int runCount;
                int v1;
                if (((v1 = this.in.readUnsignedByte()) & 0x80) != 0) {
                    runCount = v1 + -126;
                    numPixels -= runCount;
                    this.compressedSize -= 2;
                    byte v2 = this.in.readByte();
                    while (runCount-- != 0) {
                        row[offset] = v2;
                        offset += BYTES_PER_PIXEL;
                    }
                } else {
                    runCount = v1;
                    numPixels -= runCount;
                    this.compressedSize = this.compressedSize - runCount - 1;
                    while (runCount-- != 0) {
                        row[offset] = this.in.readByte();
                        offset += BYTES_PER_PIXEL;
                    }
                }
                if (this.compressedSize >= 0) continue;
                throw new InvalidFileStructureException("Ran out of compressed input bytes before completing the decoding process.");
            } while (numPixels > 0);
        }
    }

    public Integer[] getCompressionTypes() {
        return new Integer[]{new Integer(34676), new Integer(34677)};
    }

    public void initialize() throws IOException, MissingParameterException {
        super.initialize();
        this.in = this.getInput();
        this.compressedSize = this.getImageFileDirectory().getByteCount(this.getTileIndex());
        this.tileWidth = this.getImageFileDirectory().getTileWidth();
    }
}

