/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.tiff;

import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.tiff.TIFFCodec;
import net.sourceforge.jiu.codecs.tiff.TIFFImageFileDirectory;
import net.sourceforge.jiu.color.conversion.CMYKConversion;
import net.sourceforge.jiu.color.conversion.LogLuvConversion;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.ByteChannelImage;
import net.sourceforge.jiu.data.ShortChannelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.util.ArrayConverter;

public abstract class TIFFDecoder {
    private TIFFCodec codec;
    private TIFFImageFileDirectory ifd;
    private int currentRow;
    private int leftColumn;
    private int rightColumn;
    private int topRow;
    private int bottomRow;
    private byte[] rowBuffer;
    private int bufferIndex;
    private int tileIndex = -1;
    private int processedTileRows;
    private int totalTileRows;

    public abstract void decode() throws InvalidFileStructureException, IOException;

    public int getBytesPerRow() {
        return this.ifd.getBytesPerRow();
    }

    public TIFFCodec getCodec() {
        return this.codec;
    }

    public abstract Integer[] getCompressionTypes();

    public TIFFImageFileDirectory getImageFileDirectory() {
        return this.ifd;
    }

    public DataInput getInput() {
        return this.codec.getRandomAccessFile();
    }

    public int getTileIndex() {
        return this.tileIndex;
    }

    public int getX1() {
        return this.leftColumn;
    }

    public int getX2() {
        return this.rightColumn;
    }

    public int getY1() {
        return this.topRow;
    }

    public int getY2() {
        return this.bottomRow;
    }

    public void initialize() throws IOException, MissingParameterException {
        if (this.tileIndex < 0) {
            throw new MissingParameterException("Tile index was not initialized.");
        }
        if (this.codec == null) {
            throw new MissingParameterException("No TIFFCodec object was given to this decoder.");
        }
        if (this.ifd == null) {
            throw new MissingParameterException("No TIFFImageFileDirectory object was given to this decoder.");
        }
        RandomAccessFile raf = this.codec.getRandomAccessFile();
        long offset = this.ifd.getTileOffset(this.tileIndex) & 0xFFFFFFFFL;
        raf.seek(offset);
        this.leftColumn = this.ifd.getTileX1(this.tileIndex);
        this.rightColumn = this.ifd.getTileX2(this.tileIndex);
        this.topRow = this.ifd.getTileY1(this.tileIndex);
        this.bottomRow = this.ifd.getTileY2(this.tileIndex);
        this.currentRow = this.topRow;
        this.processedTileRows = this.tileIndex * this.ifd.getTileHeight();
        this.totalTileRows = this.ifd.getTileHeight() * this.ifd.getNumTiles();
        this.rowBuffer = new byte[this.ifd.getBytesPerRow()];
    }

    public void putBytes(byte[] data, int offset, int number) {
        while (number > 0) {
            int remaining = this.rowBuffer.length - this.bufferIndex;
            int numCopy = number > remaining ? remaining : number;
            System.arraycopy(data, offset, this.rowBuffer, this.bufferIndex, numCopy);
            number -= numCopy;
            offset += numCopy;
            this.bufferIndex += numCopy;
            if (this.bufferIndex != this.getBytesPerRow()) continue;
            this.storeRow(this.rowBuffer, 0);
            this.bufferIndex = 0;
        }
    }

    public void setCodec(TIFFCodec tiffCodec) {
        this.codec = tiffCodec;
    }

    public void setImageFileDirectory(TIFFImageFileDirectory tiffIfd) {
        this.ifd = tiffIfd;
    }

    public void setTileIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Tile index must be 0 or larger.");
        }
        this.tileIndex = index;
    }

    private void storeRow(byte[] data, int offset) {
        this.codec.setProgress(this.processedTileRows++, this.totalTileRows);
        int y = this.currentRow++;
        this.bufferIndex = 0;
        if (!this.codec.isRowRequired(y)) {
            return;
        }
        y -= this.codec.getBoundsY1();
        int x1 = this.getX1();
        int x2 = this.getX2();
        int numPixels = x2 - x1 + 1;
        int leftPixels = 0;
        if (this.getX1() < this.codec.getBoundsX1()) {
            leftPixels = this.codec.getBoundsX1() - this.getX1();
        }
        int rightPixels = 0;
        if (this.getX2() > this.codec.getBoundsX2()) {
            rightPixels = this.getX2() - this.codec.getBoundsX2();
        }
        numPixels -= rightPixels + leftPixels;
        switch (this.ifd.getImageType()) {
            case 8: {
                BilevelImage image = (BilevelImage)this.codec.getImage();
                int index = offset + leftPixels;
                int x = this.getX1() - this.codec.getBoundsX1() + leftPixels;
                while (numPixels-- > 0) {
                    if (data[index++] == 0) {
                        image.putBlack(x++, y);
                        continue;
                    }
                    image.putWhite(x++, y);
                }
                break;
            }
            case 0: {
                BilevelImage image = (BilevelImage)this.codec.getImage();
                int x = this.getX1() - this.codec.getBoundsX1() + leftPixels;
                image.putPackedBytes(x, y, numPixels, data, offset + leftPixels / 8, leftPixels % 8);
                break;
            }
            case 1: {
                ByteChannelImage image = (ByteChannelImage)this.codec.getImage();
                byte[] dest = new byte[data.length * 2];
                ArrayConverter.decodePacked4Bit(data, 0, dest, 0, data.length);
                for (int i = 0; i < dest.length; ++i) {
                    int value = dest[i] & 0xF;
                    value = value << 4 | value;
                    dest[i] = (byte)value;
                }
                image.putByteSamples(0, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, dest, offset + leftPixels);
                break;
            }
            case 4: {
                ByteChannelImage image = (ByteChannelImage)this.codec.getImage();
                byte[] dest = new byte[data.length * 2];
                ArrayConverter.decodePacked4Bit(data, 0, dest, 0, data.length);
                image.putByteSamples(0, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, dest, offset + leftPixels);
                break;
            }
            case 2: 
            case 5: {
                ByteChannelImage image = (ByteChannelImage)this.codec.getImage();
                image.putByteSamples(0, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, data, offset + leftPixels);
                break;
            }
            case 9: {
                ByteChannelImage image = (ByteChannelImage)this.codec.getImage();
                byte[] dest = new byte[data.length];
                int numSamples = this.ifd.getTileWidth();
                CMYKConversion.convertCMYK32InterleavedToRGB24Planar(data, 0, dest, 0, dest, numSamples, dest, numSamples * 2, numSamples);
                image.putByteSamples(0, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, dest, leftPixels);
                image.putByteSamples(1, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, dest, numSamples + leftPixels);
                image.putByteSamples(2, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, dest, 2 * numSamples + leftPixels);
                break;
            }
            case 6: {
                ByteChannelImage image = (ByteChannelImage)this.codec.getImage();
                offset += leftPixels * 3;
                int i = 0;
                int x = this.getX1() - this.codec.getBoundsX1() + leftPixels;
                while (i < numPixels) {
                    image.putByteSample(0, x, y, data[offset++]);
                    image.putByteSample(1, x, y, data[offset++]);
                    image.putByteSample(2, x, y, data[offset++]);
                    ++i;
                    ++x;
                }
                break;
            }
            case 7: {
                ShortChannelImage image = (ShortChannelImage)this.codec.getImage();
                offset += leftPixels * 3;
                short[] triplet = new short[3];
                boolean littleEndian = this.codec.getByteOrder() == 1;
                int i = 0;
                int x = this.getX1() - this.codec.getBoundsX1() + leftPixels;
                while (i < numPixels) {
                    int j = 0;
                    while (j < 3) {
                        triplet[j] = littleEndian ? ArrayConverter.getShortLE(data, offset) : ArrayConverter.getShortBE(data, offset);
                        ++j;
                        offset += 2;
                    }
                    image.putShortSample(0, x, y, triplet[0]);
                    image.putShortSample(1, x, y, triplet[1]);
                    image.putShortSample(2, x, y, triplet[2]);
                    ++i;
                    ++x;
                }
                break;
            }
            case 11: {
                if (this.getImageFileDirectory().getCompression() == 34676) {
                    ByteChannelImage image = (ByteChannelImage)this.codec.getImage();
                    int numSamples = this.ifd.getTileWidth();
                    byte[] red = new byte[numSamples];
                    byte[] green = new byte[numSamples];
                    byte[] blue = new byte[numSamples];
                    LogLuvConversion.convertLogLuv32InterleavedtoRGB24Planar(data, red, green, blue, numSamples);
                    image.putByteSamples(0, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, red, leftPixels);
                    image.putByteSamples(1, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, green, leftPixels);
                    image.putByteSamples(2, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, blue, leftPixels);
                    break;
                }
                if (this.getImageFileDirectory().getCompression() != 34677) break;
                ByteChannelImage image = (ByteChannelImage)this.codec.getImage();
                int numSamples = this.ifd.getTileWidth();
                byte[] red = new byte[numSamples];
                byte[] green = new byte[numSamples];
                byte[] blue = new byte[numSamples];
                LogLuvConversion.convertLogLuv24InterleavedtoRGB24Planar(data, red, green, blue, numSamples);
                image.putByteSamples(0, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, red, leftPixels);
                image.putByteSamples(1, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, green, leftPixels);
                image.putByteSamples(2, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, blue, leftPixels);
                break;
            }
            case 12: {
                ByteChannelImage image = (ByteChannelImage)this.codec.getImage();
                int numSamples = this.ifd.getTileWidth();
                byte[] gray = new byte[numSamples];
                LogLuvConversion.convertLogL16toGray8(data, gray, numSamples);
                image.putByteSamples(0, this.getX1() - this.codec.getBoundsX1() + leftPixels, y, numPixels, 1, gray, leftPixels);
                break;
            }
        }
    }
}

