/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.tiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedCodecModeException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.codecs.tiff.TIFFConstants;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoder;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoderDeflated;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoderLogLuv;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoderModifiedHuffman;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoderPackbits;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoderUncompressed;
import net.sourceforge.jiu.codecs.tiff.TIFFImageFileDirectory;
import net.sourceforge.jiu.codecs.tiff.TIFFRational;
import net.sourceforge.jiu.codecs.tiff.TIFFTag;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray16Image;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.MemoryRGB48Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class TIFFCodec
extends ImageCodec
implements TIFFConstants {
    public static final int BYTE_ORDER_MOTOROLA = 0;
    public static final int BYTE_ORDER_INTEL = 1;
    private static final int MAGIC_INTEL = 1229531648;
    private static final int MAGIC_MOTOROLA = 1296891946;
    private int byteOrder;
    private int nextIfdOffset;
    private static Hashtable decoders = new Hashtable();

    private int adjustInt(int value, int type) {
        if (this.getByteOrder() == 0) {
            if (type == 1) {
                return value >> 24 & 0xFF;
            }
            if (type == 3) {
                return value >> 16 & 0xFF | (value >> 24 & 0xFF) << 8;
            }
            return value;
        }
        return value;
    }

    private static TIFFDecoder createDecoder(TIFFCodec codec, TIFFImageFileDirectory ifd, int tileIndex) throws IOException, UnsupportedTypeException {
        Object instance;
        Integer compression = new Integer(ifd.getCompression());
        Class decoderClass = (Class)decoders.get(compression);
        if (decoderClass == null) {
            throw new UnsupportedTypeException("Could not create decoder for this compression type: " + compression);
        }
        try {
            instance = decoderClass.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedTypeException("Could not create decoder for this compression type.");
        }
        if (instance instanceof TIFFDecoder) {
            TIFFDecoder decoder = (TIFFDecoder)instance;
            decoder.setCodec(codec);
            decoder.setTileIndex(tileIndex);
            decoder.setImageFileDirectory(ifd);
            try {
                decoder.initialize();
            }
            catch (MissingParameterException mpe) {
                throw new UnsupportedTypeException("Unable to initialize decoder: " + mpe.toString());
            }
            return decoder;
        }
        throw new UnsupportedTypeException("Could not create decoder for this compression type.");
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public String getFormatName() {
        return "Tagged Image File Format (TIFF)";
    }

    public String[] getMimeTypes() {
        return new String[]{"image/tiff", "image/tif"};
    }

    public static String getTagName(int id) {
        switch (id) {
            case 315: {
                return "Artist";
            }
            case 326: {
                return "Bad fax lines";
            }
            case 258: {
                return "Bits per sample";
            }
            case 265: {
                return "Cell length";
            }
            case 264: {
                return "Cell width";
            }
            case 327: {
                return "Clean fax data";
            }
            case 320: {
                return "Color map";
            }
            case 259: {
                return "Compression";
            }
            case 328: {
                return "Consecutive bad fax lines";
            }
            case 33432: {
                return "Copyright";
            }
            case 306: {
                return "Date and time";
            }
            case 269: {
                return "Document name";
            }
            case 338: {
                return "Extra samples";
            }
            case 266: {
                return "Fill order";
            }
            case 289: {
                return "Free byte counts";
            }
            case 288: {
                return "Free offsets";
            }
            case 291: {
                return "Gray response curve";
            }
            case 290: {
                return "Gray response unit";
            }
            case 316: {
                return "Host computer";
            }
            case 270: {
                return "Image description";
            }
            case 257: {
                return "Image length";
            }
            case 256: {
                return "Image width";
            }
            case 271: {
                return "Make";
            }
            case 281: {
                return "Maximum sample value";
            }
            case 280: {
                return "Minimum sample value";
            }
            case 272: {
                return "Model";
            }
            case 254: {
                return "New subfile type";
            }
            case 274: {
                return "Orientation";
            }
            case 262: {
                return "Photometric interpretation";
            }
            case 284: {
                return "Planar configuration";
            }
            case 317: {
                return "Predictor";
            }
            case 296: {
                return "Resolution unit";
            }
            case 282: {
                return "Resolution X";
            }
            case 283: {
                return "Resolution Y";
            }
            case 278: {
                return "Rows per strip";
            }
            case 277: {
                return "Samples per pixel";
            }
            case 305: {
                return "Software";
            }
            case 279: {
                return "Strip byte counts";
            }
            case 273: {
                return "Strip offsets";
            }
            case 325: {
                return "Byte counts";
            }
            case 323: {
                return "Tile height";
            }
            case 324: {
                return "Tile offsets";
            }
            case 322: {
                return "Tile width";
            }
        }
        return "?";
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public boolean isSavingSupported() {
        return false;
    }

    private void load() throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException, WrongParameterException {
        this.readHeader();
        this.skipImageFileDirectories(this.getImageIndex());
        TIFFImageFileDirectory ifd = this.readImageFileDirectory();
        ifd.initFromTags(true);
        int dpiX = ifd.getDpiX();
        int dpiY = ifd.getDpiY();
        if (dpiX > 0 && dpiY > 0) {
            this.setDpi(dpiX, dpiY);
        }
        this.load(ifd);
    }

    private void load(TIFFImageFileDirectory ifd) throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException, WrongParameterException {
        this.setBoundsIfNecessary(ifd.getWidth(), ifd.getHeight());
        this.checkImageResolution();
        int width = this.getBoundsWidth();
        int height = this.getBoundsHeight();
        PixelImage image = this.getImage();
        if (image == null) {
            int imageType = ifd.getImageType();
            switch (imageType) {
                case 0: 
                case 8: {
                    image = new MemoryBilevelImage(width, height);
                    break;
                }
                case 1: 
                case 2: 
                case 12: {
                    image = new MemoryGray8Image(width, height);
                    break;
                }
                case 3: {
                    image = new MemoryGray16Image(width, height);
                    break;
                }
                case 4: 
                case 5: {
                    image = new MemoryPaletted8Image(width, height, ifd.getPalette());
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    image = new MemoryRGB24Image(width, height);
                    break;
                }
                case 7: {
                    image = new MemoryRGB48Image(width, height);
                    break;
                }
                default: {
                    throw new UnsupportedTypeException("Unsupported image type.");
                }
            }
            this.setImage(image);
        }
        int numTiles = ifd.getNumTiles();
        for (int tileIndex = 0; tileIndex < numTiles && !this.getAbort(); ++tileIndex) {
            int y2;
            int x2;
            int y1;
            int x1 = ifd.getTileX1(tileIndex);
            if (!this.isTileRequired(x1, y1 = ifd.getTileY1(tileIndex), x2 = ifd.getTileX2(tileIndex), y2 = ifd.getTileY2(tileIndex))) continue;
            TIFFDecoder decoder = TIFFCodec.createDecoder(this, ifd, tileIndex);
            decoder.decode();
        }
    }

    public void process() throws MissingParameterException, OperationFailedException {
        this.initModeFromIOObjects();
        try {
            if (this.getMode() != CodecMode.LOAD || this.getRandomAccessFile() == null) {
                throw new MissingParameterException("TIFF codec must have RandomAccessFile object opened for reading.");
            }
            this.load();
        }
        catch (IOException ioe) {
            this.close();
            throw new OperationFailedException("I/O error occurred: " + ioe.toString());
        }
    }

    private void readHeader() throws IOException, WrongFileFormatException {
        RandomAccessFile in = this.getRandomAccessFile();
        in.seek(0L);
        int magic = in.readInt();
        if (magic == 1229531648) {
            this.setByteOrder(1);
        } else if (magic == 1296891946) {
            this.setByteOrder(0);
        } else {
            throw new WrongFileFormatException("Not a TIFF file (does not begin with II or MM followed by 42).");
        }
        this.nextIfdOffset = this.readInt();
    }

    private TIFFImageFileDirectory readImageFileDirectory() throws InvalidFileStructureException, IOException {
        TIFFImageFileDirectory result = new TIFFImageFileDirectory();
        RandomAccessFile in = this.getRandomAccessFile();
        in.seek(this.nextIfdOffset);
        int numTags = this.readShort();
        if (numTags < 0) {
            throw new InvalidFileStructureException("Number of tags in IFD smaller than 1 @" + this.nextIfdOffset + ": " + numTags);
        }
        for (int i = 0; i < numTags; ++i) {
            TIFFTag tag = this.readTag();
            if (tag == null) continue;
            result.append(tag);
        }
        this.nextIfdOffset = in.readInt();
        return result;
    }

    private int readInt() throws IOException {
        RandomAccessFile in = this.getRandomAccessFile();
        int result = in.readInt();
        if (this.getByteOrder() == 1) {
            int r1 = result >> 24 & 0xFF;
            int r2 = result >> 16 & 0xFF;
            int r3 = result >> 8 & 0xFF;
            int r4 = result & 0xFF;
            return r1 | r2 << 8 | r3 << 16 | r4 << 24;
        }
        return result;
    }

    private short readShort() throws IOException {
        RandomAccessFile in = this.getRandomAccessFile();
        short result = in.readShort();
        if (this.getByteOrder() == 1) {
            int r1 = result >> 8 & 0xFF;
            int r2 = result & 0xFF;
            return (short)(r2 << 8 | r1);
        }
        return result;
    }

    private String readString(int length) throws IOException {
        RandomAccessFile in = this.getRandomAccessFile();
        StringBuffer sb = new StringBuffer(length - 1);
        while (length-- > 0) {
            int value = in.read();
            if (value < 32 || value >= 256) continue;
            sb.append((char)value);
        }
        return sb.toString();
    }

    private TIFFTag readTag() throws InvalidFileStructureException, IOException {
        RandomAccessFile in = this.getRandomAccessFile();
        int id = this.readShort() & 0xFFFF;
        int type = this.readShort() & 0xFFFF;
        int count = this.readInt();
        int offset = this.readInt();
        if (count < 1) {
            return null;
        }
        Vector<Object> vector = null;
        if (count == 1 && (type == 1 || type == 3 || type == 4)) {
            offset = this.adjustInt(offset, type);
        } else if (count <= 4 && type == 1) {
            vector = new Vector<Object>();
            for (int i = 0; i < count; ++i) {
                byte b = (byte)(offset << i * 8 & 0xFF);
                vector.addElement(new Byte(b));
            }
        } else if (count >= 1) {
            long oldOffset = in.getFilePointer();
            in.seek(offset);
            vector = new Vector();
            if (type == 2) {
                vector.addElement(this.readString(count));
            } else if (type == 1) {
                for (int i = 0; i < count; ++i) {
                    byte b = in.readByte();
                    vector.addElement(new Byte(b));
                }
            } else if (type == 3) {
                for (int i = 0; i < count; ++i) {
                    short s = this.readShort();
                    vector.addElement(new Short(s));
                }
            } else if (type == 4) {
                for (int i = 0; i < count; ++i) {
                    int v = this.adjustInt(this.readInt(), type);
                    vector.addElement(new Integer(v));
                }
            } else if (type == 5) {
                for (int i = 0; i < count; ++i) {
                    int v1 = this.adjustInt(this.readInt(), 4);
                    int v2 = this.adjustInt(this.readInt(), 4);
                    vector.addElement(new TIFFRational(v1, v2));
                }
            }
            in.seek(oldOffset);
        }
        TIFFTag result = new TIFFTag(id, type, count, offset);
        result.setVector(vector);
        return result;
    }

    public static void registerDecoder(Class decoderClass) {
        Object instance;
        if (decoderClass == null) {
            return;
        }
        try {
            instance = decoderClass.newInstance();
        }
        catch (Exception e) {
            return;
        }
        if (instance instanceof TIFFDecoder) {
            TIFFDecoder decoder = (TIFFDecoder)instance;
            Integer[] compressionTypes = decoder.getCompressionTypes();
            if (compressionTypes == null) {
                return;
            }
            int index = 0;
            while (index < compressionTypes.length) {
                Integer type;
                if ((type = compressionTypes[index++]) == null) continue;
                decoders.put(type, decoderClass);
            }
        }
    }

    private void setByteOrder(int newByteOrder) {
        if (newByteOrder != 1 && newByteOrder != 0) {
            throw new IllegalArgumentException("Byte order must be either BYTE_ORDER_INTEL or BYTE_ORDER_MOTOROLA.");
        }
        this.byteOrder = newByteOrder;
    }

    public void setFile(String fileName, CodecMode codecMode) throws IOException, UnsupportedCodecModeException {
        if (codecMode != CodecMode.LOAD) {
            throw new UnsupportedCodecModeException("This TIFF codec can only load images.");
        }
        this.setRandomAccessFile(new RandomAccessFile(fileName, "r"), CodecMode.LOAD);
    }

    private void skipImageFileDirectories(int numDirectories) throws InvalidFileStructureException, IOException {
        RandomAccessFile in = this.getRandomAccessFile();
        if (numDirectories < 0) {
            throw new IllegalArgumentException("Cannot skip negative number of image file directories: " + numDirectories);
        }
        int skipped = 0;
        while (numDirectories-- > 0) {
            in.seek(this.nextIfdOffset);
            short numTags = this.readShort();
            in.skipBytes(numTags * 12);
            this.nextIfdOffset = this.readInt();
            if (this.nextIfdOffset == 0) {
                throw new InvalidFileStructureException("Could only skip " + skipped + " image file directories, no more images in file.");
            }
            ++skipped;
        }
    }

    static {
        TIFFCodec.registerDecoder(TIFFDecoderDeflated.class);
        TIFFCodec.registerDecoder(TIFFDecoderModifiedHuffman.class);
        TIFFCodec.registerDecoder(TIFFDecoderPackbits.class);
        TIFFCodec.registerDecoder(TIFFDecoderUncompressed.class);
        TIFFCodec.registerDecoder(TIFFDecoderLogLuv.class);
    }
}

