/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.jpeg;

import java.io.DataInput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.jpeg.JPEGData;
import net.sourceforge.jiu.codecs.jpeg.JPEGFrame;
import net.sourceforge.jiu.codecs.jpeg.JPEGFrameComponent;
import net.sourceforge.jiu.codecs.jpeg.JPEGHuffmanTable;
import net.sourceforge.jiu.codecs.jpeg.JPEGQuantizationTable;
import net.sourceforge.jiu.codecs.jpeg.JPEGScan;
import net.sourceforge.jiu.codecs.jpeg.JPEGScanComponentSpecification;
import net.sourceforge.jiu.util.ArrayConverter;

public class JPEGMarkerReader {
    private JPEGMarkerReader() {
    }

    public static void readHuffmanTables(DataInput in, JPEGData jpegData, int length) throws InvalidFileStructureException, IOException {
        while (length > 0) {
            if (length < 17) {
                throw new InvalidFileStructureException("DHT marker - less than 17 bytes left.");
            }
            JPEGHuffmanTable table = new JPEGHuffmanTable();
            int classId = in.readUnsignedByte();
            int tableClass = classId >> 4 & 0xF;
            if (tableClass != 1 && tableClass != 0) {
                throw new InvalidFileStructureException("Table class in DHT marker is neither AC nor DC.");
            }
            table.setClassAcDc(tableClass);
            int tableId = classId & 0xF;
            table.setId(tableId);
            byte[] numCodes = new byte[16];
            in.readFully(numCodes);
            length -= 17;
            int[][] codes = new int[16][];
            for (int codeLength = 1; codeLength <= 16; ++codeLength) {
                int number = numCodes[codeLength - 1] & 0xFF;
                if (length < number) {
                    throw new InvalidFileStructureException("Not enough data left in DHT marker for codes of length " + codeLength + ".");
                }
                codes[codeLength - 1] = new int[number];
                for (int codeIndex = 0; codeIndex < number; ++codeIndex) {
                    codes[codeLength - 1][codeIndex] = in.readUnsignedByte();
                }
                length -= number;
            }
            table.setCodes(codes);
            System.out.println(table);
            jpegData.addHuffmanTable(table);
        }
    }

    public static void readQuantizationTables(DataInput in, JPEGData jpegData, int length) throws InvalidFileStructureException, IOException {
        while (length > 0) {
            int precId = in.readUnsignedByte();
            --length;
            JPEGQuantizationTable table = new JPEGQuantizationTable();
            int elementPrecision = precId >> 4 & 0xF;
            switch (elementPrecision) {
                case 0: {
                    table.setElementPrecision(8);
                    break;
                }
                case 1: {
                    table.setElementPrecision(16);
                    break;
                }
                default: {
                    throw new InvalidFileStructureException("Not a valid value for quantization table element precision: " + elementPrecision + " (expected 0 or 1).");
                }
            }
            int id = precId & 0xF;
            if (id > 3) {
                throw new InvalidFileStructureException("Not a valid quantization table id: " + id + " (expected 0 to 3).");
            }
            table.setId(id);
            int tableDataLength = 64 * (elementPrecision + 1);
            if (length < tableDataLength) {
                throw new InvalidFileStructureException("Not enough data left in marker for quantization table data: " + length + "byte(s) (expected at least " + tableDataLength + ").");
            }
            int[] data = new int[64];
            block9: for (int i = 0; i < data.length; ++i) {
                switch (elementPrecision) {
                    case 0: {
                        data[i] = in.readUnsignedByte();
                        continue block9;
                    }
                    case 1: {
                        data[i] = in.readShort() & 0xFFFF;
                    }
                }
            }
            length -= tableDataLength;
            table.setData(data);
            jpegData.addQuantizationTable(table);
        }
    }

    public static void readStartOfFrame(DataInput in, JPEGData jpegData, int marker, int length) throws InvalidFileStructureException, IOException, UnsupportedTypeException {
        if (length < 9) {
            throw new InvalidFileStructureException("JPEG SOF header length must be at least nine bytes; got " + length + ".");
        }
        byte[] data = new byte[6];
        in.readFully(data);
        JPEGFrame frame = new JPEGFrame();
        int samplePrecision = data[0] & 0xFF;
        if (samplePrecision != 8) {
            throw new UnsupportedTypeException("Unsupported JPEG sample precision: " + samplePrecision);
        }
        frame.setSamplePrecision(samplePrecision);
        int height = ArrayConverter.getShortBEAsInt(data, 1);
        if (height < 1) {
            throw new InvalidFileStructureException("JPEG SOF height value must be 1 or higher; got " + height + ".");
        }
        frame.setHeight(height);
        int width = ArrayConverter.getShortBEAsInt(data, 3);
        if (width < 1) {
            throw new InvalidFileStructureException("JPEG SOF width value must be 1 or higher; got " + width + ".");
        }
        frame.setWidth(width);
        int numComponents = data[5] & 0xFF;
        if (numComponents != 1) {
            throw new UnsupportedTypeException("Unsupported number of JPEG components: " + numComponents);
        }
        frame.setNumComponents(numComponents);
        if (length - 6 != numComponents * 3) {
            throw new InvalidFileStructureException("SOF marker has not expected size for " + numComponents + " component(s); got " + length + " instead of " + (6 + numComponents * 3));
        }
        JPEGFrameComponent[] frameComponents = new JPEGFrameComponent[numComponents];
        for (int componentIndex = 0; componentIndex < numComponents; ++componentIndex) {
            in.readFully(data, 0, 3);
            JPEGFrameComponent frameComponent = new JPEGFrameComponent();
            int componentIdentifier = data[0] & 0xFF;
            frameComponent.setComponentId(componentIdentifier);
            int horizontalSamplingFactor = (data[1] & 0xF0) >> 4;
            frameComponent.setHorizontalSamplingFactor(horizontalSamplingFactor);
            int verticalSamplingFactor = data[1] & 0xF;
            frameComponent.setVerticalSamplingFactor(verticalSamplingFactor);
            int quantizationTable = data[2] & 0xFF;
            frameComponent.setQuantizationTableId(quantizationTable);
            frameComponents[componentIndex] = frameComponent;
        }
        frame.setComponents(frameComponents);
        jpegData.setFrame(frame);
        System.out.println(frame);
    }

    public static void readStartOfScan(DataInput in, JPEGData jpegData, int length) throws InvalidFileStructureException, IOException, UnsupportedTypeException {
        if (length < 6) {
            throw new InvalidFileStructureException("SOS marker must be at least six bytes large; got " + length);
        }
        int numScanComponents = in.readUnsignedByte();
        --length;
        if (numScanComponents < 1) {
            throw new InvalidFileStructureException("Number of scan components must be one or larger.");
        }
        JPEGScan scan = new JPEGScan();
        scan.setNumComponents(numScanComponents);
        JPEGScanComponentSpecification[] specs = new JPEGScanComponentSpecification[numScanComponents];
        byte[] data = new byte[2];
        for (int i = 0; i < numScanComponents; ++i) {
            in.readFully(data);
            length -= 2;
            int componentSelector = data[0] & 0xFF;
            int dcTableSelector = (data[1] & 0xF0) >> 4;
            int acTableSelector = data[1] & 0xF;
            JPEGScanComponentSpecification spec = new JPEGScanComponentSpecification();
            spec.setAcEntropyTable(acTableSelector);
            spec.setDcEntropyTable(dcTableSelector);
            spec.setComponent(componentSelector);
            specs[i] = spec;
        }
        scan.setCompSpecs(specs);
        if (length != 3) {
            throw new InvalidFileStructureException("Expected exactly three bytes left after scan component specs; got " + length);
        }
        data = new byte[3];
        in.readFully(data);
        jpegData.addScan(scan);
    }
}

