/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.jpeg;

public class JPEGHuffmanTable {
    public static final int TABLE_CLASS_AC = 1;
    public static final int TABLE_CLASS_DC = 0;
    private int id;
    private int classAcDc;
    private int[][] codes;
    private int[] huffCode;
    private int[] huffSize;
    private int lastK;

    public void createDecoderTables() {
        this.generateSizeTable();
        this.generateCodeTable();
    }

    private void generateCodeTable() {
        this.huffCode = new int[257];
        int k = 0;
        int code = 0;
        int si = this.huffSize[0];
        while (true) {
            this.huffCode[k] = code++;
            if (this.huffSize[++k] == si) continue;
            if (this.huffSize[k] == 0) break;
            do {
                code <<= 1;
            } while (this.huffSize[k] != ++si);
        }
    }

    private void generateSizeTable() {
        this.huffSize = new int[257];
        int i = 1;
        int j = 1;
        int k = 0;
        while (true) {
            if (j <= this.codes[i].length) {
                this.huffSize[k] = i;
                ++k;
                ++j;
                continue;
            }
            j = 1;
            if (++i > 16) break;
        }
        this.huffSize[k] = 0;
        this.lastK = k;
    }

    public int getClassAcDc() {
        return this.classAcDc;
    }

    public int[][] getCodes() {
        return this.codes;
    }

    public int getId() {
        return this.id;
    }

    public void setClassAcDc(int i) {
        this.classAcDc = i;
    }

    public void setCodes(int[][] is) {
        this.codes = is;
    }

    public void setId(int i) {
        this.id = i;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id=");
        sb.append(this.id);
        sb.append("/class=");
        sb.append(this.classAcDc == 1 ? "AC" : "DC");
        if (this.codes != null) {
            sb.append("/codes(length,number)=");
            for (int i = 0; i < this.codes.length; ++i) {
                if (this.codes[i].length <= 0) continue;
                sb.append(" ");
                sb.append(i + 1);
                sb.append(":");
                sb.append(this.codes[i].length);
            }
        }
        return sb.toString();
    }
}

