/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryByteChannelImage;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;
import net.sourceforge.jiu.util.ArrayConverter;

public class RASCodec
extends ImageCodec {
    private static final int RAS_MAGIC = 1504078485;
    private static final int COMPRESSION_NONE = 1;
    private static final int RAS_HEADER_SIZE = 32;
    private int width;
    private int height;
    private int depth;
    private int length;
    private int type;
    private int mapType;
    private int mapLength;
    private int bytesPerRow;
    private int paddingBytes;
    private int numColors;
    private DataInput in;
    private DataOutput out;
    private Palette palette;

    public String getFormatName() {
        return "Sun Raster (RAS)";
    }

    public String[] getMimeTypes() {
        return new String[]{"image/x-ras"};
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public boolean isSavingSupported() {
        return true;
    }

    private void load() throws IOException, OperationFailedException {
        this.in = this.getInputAsDataInput();
        this.readHeader();
        this.readImage();
    }

    public void process() throws OperationFailedException {
        block4: {
            try {
                this.initModeFromIOObjects();
                if (this.getMode() == CodecMode.LOAD) {
                    this.load();
                    break block4;
                }
                if (this.getMode() == CodecMode.SAVE) {
                    this.save();
                    break block4;
                }
                throw new WrongParameterException("Could find neither objects for loading nor for saving.");
            }
            catch (IOException ioe) {
                throw new OperationFailedException("I/O error in RAS codec: " + ioe.toString());
            }
        }
    }

    private void readHeader() throws InvalidFileStructureException, UnsupportedTypeException, WrongFileFormatException, WrongParameterException, IOException {
        byte[] header = new byte[32];
        this.in.readFully(header);
        int magic = ArrayConverter.getIntBE(header, 0);
        if (magic != 1504078485) {
            throw new WrongFileFormatException("This stream is not a valid Sun RAS stream (bad magic: " + Integer.toHexString(magic) + " instead of " + Integer.toHexString(1504078485));
        }
        this.width = ArrayConverter.getIntBE(header, 4);
        this.height = ArrayConverter.getIntBE(header, 8);
        if (this.width < 1 || this.height < 1) {
            throw new InvalidFileStructureException("Width and height must both be larger than zero; found width=" + this.width + ", height=" + this.height + ".");
        }
        this.setBoundsIfNecessary(this.width, this.height);
        this.checkBounds(this.width, this.height);
        this.depth = ArrayConverter.getIntBE(header, 12);
        switch (this.depth) {
            case 1: {
                this.bytesPerRow = (this.width + 7) / 8;
                break;
            }
            case 8: {
                this.bytesPerRow = this.width;
                break;
            }
            case 24: {
                this.bytesPerRow = this.width * 3;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Depths other than 1, 8 and 24 unsupported when reading RAS stream; found " + this.depth);
            }
        }
        this.paddingBytes = this.bytesPerRow % 2;
        this.numColors = 1 << this.depth;
        this.type = ArrayConverter.getIntBE(header, 20);
        if (this.type != 1) {
            throw new UnsupportedTypeException("Only uncompressed RAS streams are read; found " + this.type);
        }
        this.mapType = ArrayConverter.getIntBE(header, 24);
        this.mapLength = ArrayConverter.getIntBE(header, 28);
        if (this.mapLength != 0) {
            if (this.depth != 8) {
                throw new UnsupportedTypeException("Cannot handle Sun RAS input streams with color maps and a depth other than 8 (found " + this.depth + ").");
            }
            if (this.mapLength != 768) {
                throw new UnsupportedTypeException("Cannot handle Sun RAS input streams with color maps of a length different than 768; found " + this.mapLength);
            }
            if (this.mapType != 1) {
                throw new UnsupportedTypeException("Cannot handle Sun RAS input streams with color maps of a type other than 1; found " + this.mapType);
            }
            this.palette = this.readPalette();
        } else {
            this.palette = null;
        }
    }

    private IntegerImage readImage() throws InvalidFileStructureException, IOException {
        MemoryRGB24Image rgb24Image = null;
        MemoryPaletted8Image paletted8Image = null;
        MemoryByteChannelImage result = null;
        int numChannels = 1;
        int bytesPerRow = 0;
        switch (this.depth) {
            case 8: {
                paletted8Image = new MemoryPaletted8Image(this.width, this.height, this.palette);
                result = paletted8Image;
                numChannels = 1;
                bytesPerRow = this.width;
                break;
            }
            case 24: {
                result = rgb24Image = new MemoryRGB24Image(this.width, this.height);
                numChannels = 3;
                bytesPerRow = this.width;
            }
        }
        this.setImage(result);
        byte[][] buffer = new byte[numChannels][];
        for (int i = 0; i < numChannels; ++i) {
            buffer[i] = new byte[bytesPerRow];
        }
        int y = 0;
        for (int destY = -this.getBoundsY1(); destY <= this.getBoundsY2(); ++destY) {
            if (rgb24Image != null) {
                for (int x = 0; x < this.width; ++x) {
                    buffer[2][x] = this.in.readByte();
                    buffer[1][x] = this.in.readByte();
                    buffer[0][x] = this.in.readByte();
                }
                rgb24Image.putByteSamples(0, 0, destY, this.getBoundsWidth(), 1, buffer[0], this.getBoundsX1());
                rgb24Image.putByteSamples(1, 0, destY, this.getBoundsWidth(), 1, buffer[1], this.getBoundsX1());
                rgb24Image.putByteSamples(2, 0, destY, this.getBoundsWidth(), 1, buffer[2], this.getBoundsX1());
            } else if (paletted8Image != null) {
                this.in.readFully(buffer[0], 0, this.width);
                paletted8Image.putByteSamples(0, 0, destY, this.getBoundsWidth(), 1, buffer[0], this.getBoundsX1());
            }
            if (this.in.skipBytes(this.paddingBytes) != this.paddingBytes) {
                throw new InvalidFileStructureException("Could not skip byte after row " + y + ".");
            }
            this.setProgress(y, this.getBoundsY2() + 1);
            ++y;
        }
        return result;
    }

    private Palette readPalette() throws InvalidFileStructureException, IOException {
        Palette result = new Palette(256, 255);
        for (int channel = 0; channel < 3; ++channel) {
            int channelIndex = -1;
            switch (channel) {
                case 0: {
                    channelIndex = 0;
                    break;
                }
                case 1: {
                    channelIndex = 1;
                    break;
                }
                case 2: {
                    channelIndex = 2;
                }
            }
            for (int i = 0; i < this.numColors; ++i) {
                int value = this.in.readUnsignedByte();
                if (value == -1) {
                    throw new InvalidFileStructureException("Unexpected end of file when reading Sun RAS palette.");
                }
                result.putSample(channelIndex, i, value);
            }
        }
        return result;
    }

    private void save() throws IOException, UnsupportedTypeException, WrongParameterException {
        PixelImage image = this.getImage();
        if (image == null || !(image instanceof Paletted8Image)) {
            throw new UnsupportedTypeException("Must have non-null image that is a Paletted8Image.");
        }
        this.saveHeader(image);
        if (image instanceof Paletted8Image) {
            this.saveData((Paletted8Image)image);
        }
    }

    private void saveData(Paletted8Image image) throws IOException {
        byte[] row = new byte[this.getBoundsWidth()];
        int y1 = 0;
        int y2 = this.getBoundsY1();
        while (y1 < this.getBoundsHeight()) {
            image.getByteSamples(0, this.getBoundsX1(), y2, row.length, 1, row, 0);
            this.out.write(row);
            int num = this.paddingBytes;
            while (num-- > 0) {
                this.out.write(0);
            }
            this.setProgress(y1, this.getBoundsHeight());
            ++y1;
            ++y2;
        }
    }

    private void saveHeader(PixelImage image) throws IOException, UnsupportedTypeException, WrongParameterException {
        this.setBoundsIfNecessary(this.width, this.height);
        this.checkBounds(this.width, this.height);
        this.out.writeInt(1504078485);
        int width = this.getBoundsWidth();
        this.out.writeInt(width);
        int height = this.getBoundsHeight();
        this.out.writeInt(height);
        if (image instanceof BilevelImage) {
            this.depth = 1;
            this.bytesPerRow = (width + 7) / 8;
        } else if (image instanceof Gray8Image || image instanceof Paletted8Image) {
            this.depth = 8;
            this.bytesPerRow = width;
        } else if (image instanceof RGB24Image) {
            this.bytesPerRow = width * 3;
            this.depth = 24;
        } else {
            throw new UnsupportedTypeException("Cannot store image types other than bilevel, gray8, paletted8 and RGB24.");
        }
        this.out.writeInt(this.depth);
        this.paddingBytes = this.bytesPerRow % 2;
        this.numColors = 1 << this.depth;
        this.length = this.bytesPerRow * this.getBoundsHeight();
        this.out.writeInt(this.length);
        this.out.writeInt(1);
        this.mapType = 1;
        this.mapLength = 0;
        if (image instanceof Paletted8Image) {
            this.mapLength = 768;
        }
        this.out.writeInt(this.mapType);
        this.out.writeInt(this.mapLength);
        if (image instanceof Paletted8Image) {
            Paletted8Image pal = (Paletted8Image)image;
            this.savePalette(pal.getPalette());
        }
    }

    private void savePalette(Palette palette) throws IOException {
        int numEntries = palette.getNumEntries();
        for (int channel = 0; channel < 3; ++channel) {
            int channelIndex = -1;
            switch (channel) {
                case 0: {
                    channelIndex = 0;
                    break;
                }
                case 1: {
                    channelIndex = 1;
                    break;
                }
                case 2: {
                    channelIndex = 2;
                }
            }
            for (int i = 0; i < 256; ++i) {
                int value = 0;
                if (i < numEntries) {
                    value = palette.getSample(channelIndex, i);
                }
                this.out.write(value);
            }
        }
    }

    public String suggestFileExtension(PixelImage image) {
        return ".ras";
    }
}

