/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class PngIdatInputStream
extends InputStream {
    private static final int IDAT = 1229209940;
    private DataInputStream in;
    private long bytesLeft;

    public PngIdatInputStream(DataInputStream input, long bytes) {
        this.in = input;
        this.bytesLeft = bytes;
    }

    public int read() throws IOException {
        if (this.bytesLeft == 0L) {
            this.skipHeaders();
        }
        --this.bytesLeft;
        return this.in.read();
    }

    private void skipHeaders() throws IOException {
        do {
            this.in.readInt();
            this.bytesLeft = (long)this.in.readInt() & 0xFFFFFFFFL;
            int type = this.in.readInt();
            if (1229209940 == type) continue;
            throw new IOException("Expected IDAT chunk type, got " + Integer.toHexString(type));
        } while (this.bytesLeft == 0L);
    }
}

