/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedCodecModeException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.ByteChannelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;
import net.sourceforge.jiu.util.ArrayConverter;
import net.sourceforge.jiu.util.SeekableByteArrayOutputStream;

public class PalmCodec
extends ImageCodec {
    public static final int COMPRESSION_NONE = 255;
    public static final int COMPRESSION_PACKBITS = 2;
    public static final int COMPRESSION_RLE = 1;
    public static final int COMPRESSION_SCANLINE = 0;
    private static final int FLAG_COMPRESSED = 32768;
    private static final int FLAG_COLOR_TABLE = 16384;
    private static final int FLAG_TRANSPARENCY = 8192;
    private static final int FLAG_DIRECT_COLOR = 1024;
    private static final short[][] PALM_SYSTEM_PALETTE_4_GRAY = new short[][]{{255, 255, 255}, {192, 192, 192}, {128, 128, 128}, {0, 0, 0}};
    private static final short[][] PALM_SYSTEM_PALETTE_16_COLOR = new short[][]{{255, 255, 255}, {128, 128, 128}, {128, 0, 0}, {128, 128, 0}, {0, 128, 0}, {0, 128, 128}, {0, 0, 128}, {128, 0, 128}, {255, 0, 255}, {192, 192, 192}, {255, 0, 0}, {255, 255, 0}, {0, 255, 0}, {0, 255, 255}, {0, 0, 255}, {0, 0, 0}};
    private static final short[][] PALM_SYSTEM_PALETTE_16_GRAY = new short[][]{{255, 255, 255}, {238, 238, 238}, {221, 221, 221}, {204, 204, 204}, {187, 187, 187}, {170, 170, 170}, {153, 153, 153}, {136, 136, 136}, {119, 119, 119}, {102, 102, 102}, {85, 85, 85}, {68, 68, 68}, {51, 51, 51}, {34, 34, 34}, {17, 17, 17}, {0, 0, 0}};
    private static final short[][] PALM_SYSTEM_PALETTE_256 = new short[][]{{255, 255, 255}, {255, 204, 255}, {255, 153, 255}, {255, 102, 255}, {255, 51, 255}, {255, 0, 255}, {255, 255, 204}, {255, 204, 204}, {255, 153, 204}, {255, 102, 204}, {255, 51, 204}, {255, 0, 204}, {255, 255, 153}, {255, 204, 153}, {255, 153, 153}, {255, 102, 153}, {255, 51, 153}, {255, 0, 153}, {204, 255, 255}, {204, 204, 255}, {204, 153, 255}, {204, 102, 255}, {204, 51, 255}, {204, 0, 255}, {204, 255, 204}, {204, 204, 204}, {204, 153, 204}, {204, 102, 204}, {204, 51, 204}, {204, 0, 204}, {204, 255, 153}, {204, 204, 153}, {204, 153, 153}, {204, 102, 153}, {204, 51, 153}, {204, 0, 153}, {153, 255, 255}, {153, 204, 255}, {153, 153, 255}, {153, 102, 255}, {153, 51, 255}, {153, 0, 255}, {153, 255, 204}, {153, 204, 204}, {153, 153, 204}, {153, 102, 204}, {153, 51, 204}, {153, 0, 204}, {153, 255, 153}, {153, 204, 153}, {153, 153, 153}, {153, 102, 153}, {153, 51, 153}, {153, 0, 153}, {102, 255, 255}, {102, 204, 255}, {102, 153, 255}, {102, 102, 255}, {102, 51, 255}, {102, 0, 255}, {102, 255, 204}, {102, 204, 204}, {102, 153, 204}, {102, 102, 204}, {102, 51, 204}, {102, 0, 204}, {102, 255, 153}, {102, 204, 153}, {102, 153, 153}, {102, 102, 153}, {102, 51, 153}, {102, 0, 153}, {51, 255, 255}, {51, 204, 255}, {51, 153, 255}, {51, 102, 255}, {51, 51, 255}, {51, 0, 255}, {51, 255, 204}, {51, 204, 204}, {51, 153, 204}, {51, 102, 204}, {51, 51, 204}, {51, 0, 204}, {51, 255, 153}, {51, 204, 153}, {51, 153, 153}, {51, 102, 153}, {51, 51, 153}, {51, 0, 153}, {0, 255, 255}, {0, 204, 255}, {0, 153, 255}, {0, 102, 255}, {0, 51, 255}, {0, 0, 255}, {0, 255, 204}, {0, 204, 204}, {0, 153, 204}, {0, 102, 204}, {0, 51, 204}, {0, 0, 204}, {0, 255, 153}, {0, 204, 153}, {0, 153, 153}, {0, 102, 153}, {0, 51, 153}, {0, 0, 153}, {255, 255, 102}, {255, 204, 102}, {255, 153, 102}, {255, 102, 102}, {255, 51, 102}, {255, 0, 102}, {255, 255, 51}, {255, 204, 51}, {255, 153, 51}, {255, 102, 51}, {255, 51, 51}, {255, 0, 51}, {255, 255, 0}, {255, 204, 0}, {255, 153, 0}, {255, 102, 0}, {255, 51, 0}, {255, 0, 0}, {204, 255, 102}, {204, 204, 102}, {204, 153, 102}, {204, 102, 102}, {204, 51, 102}, {204, 0, 102}, {204, 255, 51}, {204, 204, 51}, {204, 153, 51}, {204, 102, 51}, {204, 51, 51}, {204, 0, 51}, {204, 255, 0}, {204, 204, 0}, {204, 153, 0}, {204, 102, 0}, {204, 51, 0}, {204, 0, 0}, {153, 255, 102}, {153, 204, 102}, {153, 153, 102}, {153, 102, 102}, {153, 51, 102}, {153, 0, 102}, {153, 255, 51}, {153, 204, 51}, {153, 153, 51}, {153, 102, 51}, {153, 51, 51}, {153, 0, 51}, {153, 255, 0}, {153, 204, 0}, {153, 153, 0}, {153, 102, 0}, {153, 51, 0}, {153, 0, 0}, {102, 255, 102}, {102, 204, 102}, {102, 153, 102}, {102, 102, 102}, {102, 51, 102}, {102, 0, 102}, {102, 255, 51}, {102, 204, 51}, {102, 153, 51}, {102, 102, 51}, {102, 51, 51}, {102, 0, 51}, {102, 255, 0}, {102, 204, 0}, {102, 153, 0}, {102, 102, 0}, {102, 51, 0}, {102, 0, 0}, {51, 255, 102}, {51, 204, 102}, {51, 153, 102}, {51, 102, 102}, {51, 51, 102}, {51, 0, 102}, {51, 255, 51}, {51, 204, 51}, {51, 153, 51}, {51, 102, 51}, {51, 51, 51}, {51, 0, 51}, {51, 255, 0}, {51, 204, 0}, {51, 153, 0}, {51, 102, 0}, {51, 51, 0}, {51, 0, 0}, {0, 255, 102}, {0, 204, 102}, {0, 153, 102}, {0, 102, 102}, {0, 51, 102}, {0, 0, 102}, {0, 255, 51}, {0, 204, 51}, {0, 153, 51}, {0, 102, 51}, {0, 51, 51}, {0, 0, 51}, {0, 255, 0}, {0, 204, 0}, {0, 153, 0}, {0, 102, 0}, {0, 51, 0}, {17, 17, 17}, {34, 34, 34}, {68, 68, 68}, {85, 85, 85}, {119, 119, 119}, {136, 136, 136}, {170, 170, 170}, {187, 187, 187}, {221, 221, 221}, {238, 238, 238}, {192, 192, 192}, {128, 0, 0}, {128, 0, 128}, {0, 128, 0}, {0, 128, 128}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    private int bitsPerPixel;
    private int blueBits;
    private int bytesPerRow;
    private int compression;
    private long compressedDataOffset;
    private int flags;
    private int greenBits;
    private int height;
    private Palette palette;
    private int redBits;
    private byte[] rgb;
    private byte[] transColor;
    private int transparencyIndex = -1;
    private int version;
    private int width;

    private static Palette createPalette(short[][] data) {
        Palette result = new Palette(data.length);
        for (int i = 0; i < data.length; ++i) {
            result.put(i, data[i][0], data[i][1], data[i][2]);
        }
        return result;
    }

    public static Palette createSystem2BitGrayscalePalette() {
        return PalmCodec.createPalette(PALM_SYSTEM_PALETTE_4_GRAY);
    }

    public static Palette createSystem4BitColorPalette() {
        return PalmCodec.createPalette(PALM_SYSTEM_PALETTE_16_COLOR);
    }

    public static Palette createSystem4BitGrayscalePalette() {
        return PalmCodec.createPalette(PALM_SYSTEM_PALETTE_16_GRAY);
    }

    public static Palette createSystem8BitPalette() {
        return PalmCodec.createPalette(PALM_SYSTEM_PALETTE_256);
    }

    public int getCompression() {
        return this.compression;
    }

    public String getFormatName() {
        return "Palm image file format";
    }

    public String[] getMimeTypes() {
        return null;
    }

    public int getTransparencyIndex() {
        return this.transparencyIndex;
    }

    public boolean hasTransparencyIndex() {
        return this.transparencyIndex >= 0;
    }

    private void invertBilevelData(byte[] row) {
        if (row != null) {
            for (int i = 0; i < row.length; ++i) {
                row[i] = ~row[i];
            }
        }
    }

    private static boolean isEqualPalette(Palette palette, short[][] data) {
        if (palette == null || data == null) {
            return false;
        }
        if (palette.getNumEntries() != data.length) {
            return false;
        }
        for (int i = 0; i < data.length; ++i) {
            int red = palette.getSample(0, i);
            int green = palette.getSample(1, i);
            int blue = palette.getSample(2, i);
            short[] color = data[i];
            if (color[0] == red && color[1] == green && color[2] == blue) continue;
            return false;
        }
        return true;
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public static boolean isPalmSystemPaletteGray4(Palette palette) {
        return PalmCodec.isEqualPalette(palette, PALM_SYSTEM_PALETTE_4_GRAY);
    }

    public static boolean isPalmSystemPaletteGray16(Palette palette) {
        return PalmCodec.isEqualPalette(palette, PALM_SYSTEM_PALETTE_16_GRAY);
    }

    public static boolean isPalmSystemPaletteColor16(Palette palette) {
        return PalmCodec.isEqualPalette(palette, PALM_SYSTEM_PALETTE_16_COLOR);
    }

    public static boolean isPalmSystemPalette256(Palette palette) {
        return PalmCodec.isEqualPalette(palette, PALM_SYSTEM_PALETTE_256);
    }

    public boolean isSavingSupported() {
        return true;
    }

    private void load() throws InvalidFileStructureException, IOException, OperationFailedException, UnsupportedTypeException, WrongFileFormatException {
        DataInput in = this.getInputAsDataInput();
        this.loadHeader(in);
        this.loadPalette(in);
        this.loadImage(in);
    }

    private void loadHeader(DataInput in) throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException {
        this.width = in.readShort() & 0xFFFF;
        this.height = in.readShort() & 0xFFFF;
        this.bytesPerRow = in.readShort() & 0xFFFF;
        this.flags = in.readShort() & 0xFFFF;
        this.bitsPerPixel = in.readUnsignedByte();
        this.version = in.readUnsignedByte();
        in.readShort();
        this.transparencyIndex = in.readUnsignedByte() & 0xFFFF;
        this.compression = in.readUnsignedByte() & 0xFFFF;
        in.skipBytes(2);
        if ((this.flags & 0x8000) == 0) {
            this.compression = 255;
        }
        boolean unsupportedDirectColor = false;
        if ((this.flags & 0x400) != 0) {
            this.redBits = in.readUnsignedByte();
            this.greenBits = in.readUnsignedByte();
            this.blueBits = in.readUnsignedByte();
            unsupportedDirectColor = this.redBits != 5 || this.greenBits != 6 || this.blueBits != 5;
            in.skipBytes(2);
            this.transColor = new byte[3];
            in.readFully(this.transColor);
        }
        if (this.width < 1 || this.height < 1 || unsupportedDirectColor || this.bitsPerPixel != 1 && this.bitsPerPixel != 2 && this.bitsPerPixel != 4 && this.bitsPerPixel != 8 && this.bitsPerPixel != 16 || this.compression != 255 && this.compression != 1 && this.compression != 0) {
            throw new WrongFileFormatException("Not a file in Palm image file format.");
        }
    }

    private void loadImage(DataInput in) throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException, WrongParameterException {
        this.setBoundsIfNecessary(this.width, this.height);
        this.checkBounds(this.width, this.height);
        PixelImage image = this.getImage();
        if (this.palette != null) {
            if (image == null) {
                image = new MemoryPaletted8Image(this.getBoundsWidth(), this.getBoundsHeight(), this.palette);
            } else {
                if (!(image instanceof Paletted8Image)) {
                    throw new WrongParameterException("Image to be used for loading must be paletted for this file.");
                }
                ((Paletted8Image)image).setPalette(this.palette);
            }
        } else {
            switch (this.bitsPerPixel) {
                case 1: {
                    if (image == null) {
                        image = new MemoryBilevelImage(this.getBoundsWidth(), this.getBoundsHeight());
                        break;
                    }
                    if (image instanceof BilevelImage) break;
                    throw new WrongParameterException("Image to be used for loading must implement BilevelImage for this file.");
                }
                case 16: {
                    if (image == null) {
                        image = new MemoryRGB24Image(this.getBoundsWidth(), this.getBoundsHeight());
                    } else if (!(image instanceof RGB24Image)) {
                        throw new WrongParameterException("Image to be used for loading must implement RGB24Image.");
                    }
                    this.rgb = new byte[this.width * 3];
                    break;
                }
                default: {
                    if (image == null) {
                        image = new MemoryGray8Image(this.getBoundsWidth(), this.getBoundsHeight());
                        break;
                    }
                    if (image instanceof Gray8Image) break;
                    throw new WrongParameterException("Image to be used for loading must implement Gray8Image for this file.");
                }
            }
        }
        this.setImage(image);
        if (image.getWidth() != this.getBoundsWidth() || image.getHeight() != this.getBoundsHeight()) {
            throw new WrongParameterException("Image to be reused has wrong resolution (must have " + this.getBoundsWidth() + " x " + this.getBoundsHeight() + " pixels).");
        }
        this.loadImageData(in);
    }

    private void loadImageData(DataInput in) throws InvalidFileStructureException, IOException {
        PixelImage image = this.getImage();
        if (this.compression != 255) {
            in.readShort();
        }
        byte[] row = new byte[this.bytesPerRow];
        int NUM_ROWS = this.getBoundsY2() + 1;
        for (int y = 0; y < NUM_ROWS; ++y) {
            switch (this.compression) {
                case 255: {
                    in.readFully(row, 0, this.bytesPerRow);
                    break;
                }
                case 1: {
                    int index = 0;
                    do {
                        int num;
                        if ((num = in.readUnsignedByte()) < 1 || index + num > this.bytesPerRow) {
                            String message = "At index=" + index + ", y=" + y + " there is a run length of " + num;
                            System.err.println("ERROR decoding RLE: " + message);
                            throw new InvalidFileStructureException(message);
                        }
                        byte value = in.readByte();
                        while (num-- > 0) {
                            row[index++] = value;
                        }
                    } while (index < this.bytesPerRow);
                    break;
                }
                case 0: {
                    int index = 0;
                    int pixelMask = 0;
                    int mask = 0;
                    do {
                        if (mask == 0) {
                            pixelMask = in.readUnsignedByte();
                            mask = 128;
                        }
                        if ((pixelMask & mask) == 0) {
                            ++index;
                        } else {
                            row[index++] = in.readByte();
                        }
                        mask >>= 1;
                    } while (index < this.bytesPerRow);
                    break;
                }
            }
            this.store(image, y, row);
            this.setProgress(y, NUM_ROWS);
        }
    }

    private void loadPalette(DataInput in) throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException {
        if ((this.flags & 0x4000) == 0) {
            switch (this.bitsPerPixel) {
                case 2: {
                    this.palette = PalmCodec.createSystem2BitGrayscalePalette();
                    break;
                }
                case 4: {
                    this.palette = PalmCodec.createSystem4BitGrayscalePalette();
                    break;
                }
                case 8: {
                    this.palette = PalmCodec.createSystem8BitPalette();
                }
            }
            return;
        }
        int numEntries = in.readShort() & 0xFFFF;
        if (numEntries < 1 || numEntries > 256) {
            throw new WrongFileFormatException("Not a Palm image file, invalid number of palette entries: " + numEntries);
        }
        this.palette = new Palette(numEntries, 255);
        for (int i = 0; i < numEntries; ++i) {
            in.readUnsignedByte();
            int red = in.readUnsignedByte();
            int green = in.readUnsignedByte();
            int blue = in.readUnsignedByte();
            this.palette.putSample(0, i, red);
            this.palette.putSample(1, i, green);
            this.palette.putSample(2, i, blue);
        }
    }

    public void process() throws InvalidFileStructureException, MissingParameterException, OperationFailedException, WrongParameterException {
        block4: {
            try {
                this.initModeFromIOObjects();
                if (this.getMode() == CodecMode.LOAD) {
                    this.load();
                    break block4;
                }
                if (this.getMode() == CodecMode.SAVE) {
                    this.save();
                    break block4;
                }
                throw new WrongParameterException("Could find neither objects for loading nor for saving.");
            }
            catch (IOException ioe) {
                throw new OperationFailedException("I/O error in Palm codec: " + ioe.toString());
            }
        }
    }

    public void removeTransparencyIndex() {
        this.transparencyIndex = -1;
    }

    private void save() throws IOException, OperationFailedException, UnsupportedTypeException {
        PixelImage image = this.getImage();
        if (image == null) {
            throw new MissingParameterException("Need image to save.");
        }
        this.setBoundsIfNecessary(image.getWidth(), image.getHeight());
        this.checkBounds(image.getWidth(), image.getHeight());
        DataOutput out = this.getOutputAsDataOutput();
        if (out == null) {
            throw new MissingParameterException("Could not get DataOutput object when saving in Palm file format.");
        }
        this.width = this.getBoundsWidth();
        this.height = this.getBoundsHeight();
        this.flags = 0;
        if (this.hasTransparencyIndex()) {
            this.flags |= 0x2000;
        }
        if (this.compression != 255) {
            this.flags |= 0x8000;
        }
        this.version = 0;
        if (this.bitsPerPixel > 1) {
            this.version = 1;
        }
        if (this.hasTransparencyIndex() || this.compression != 255) {
            this.version = 2;
        }
        this.compressedDataOffset = 0L;
        if (image instanceof BilevelImage) {
            this.save(out, (BilevelImage)image);
        } else if (image instanceof Gray8Image) {
            this.save(out, (Gray8Image)image);
        } else if (image instanceof Paletted8Image) {
            this.save(out, (Paletted8Image)image);
        } else if (image instanceof RGB24Image) {
            this.save(out, (RGB24Image)image);
        } else {
            throw new UnsupportedTypeException("Unsupported image type: " + image.getClass().getName());
        }
    }

    private void save(DataOutput out, BilevelImage image) throws IOException {
        this.bytesPerRow = (this.width + 7) / 8;
        if (this.bytesPerRow % 2 == 1) {
            ++this.bytesPerRow;
        }
        this.bitsPerPixel = 1;
        this.setCorrectVersion();
        this.saveHeader(out);
        byte[] row = new byte[this.bytesPerRow];
        byte[] prev = null;
        if (this.compression == 0) {
            prev = new byte[row.length];
        }
        int X1 = this.getBoundsX1();
        int Y1 = this.getBoundsY1();
        for (int y = 0; y < this.height; ++y) {
            image.getPackedBytes(X1, y + Y1, this.width, row, 0, 0);
            this.invertBilevelData(row);
            this.saveRow(out, y == 0, row, prev);
            if (this.compression == 0) {
                System.arraycopy(row, 0, prev, 0, row.length);
            }
            this.setProgress(y, this.height);
        }
        this.saveFinalCompressedSize(out);
    }

    private void save(DataOutput out, Gray8Image image) throws IOException {
        this.bytesPerRow = this.width;
        if (this.bytesPerRow % 2 == 1) {
            ++this.bytesPerRow;
        }
        this.bitsPerPixel = 8;
        this.flags |= 0x4000;
        this.setCorrectVersion();
        this.saveHeader(out);
        out.writeShort(256);
        for (int i = 0; i < 256; ++i) {
            out.writeByte(0);
            out.writeByte(i);
            out.writeByte(i);
            out.writeByte(i);
        }
        this.compressedDataOffset += 1026L;
        this.saveInitialCompressedSize(out);
        byte[] row = new byte[this.width];
        byte[] prev = null;
        if (this.compression == 0) {
            prev = new byte[this.width];
        }
        int X1 = this.getBoundsX1();
        int Y1 = this.getBoundsY1();
        for (int y = 0; y < this.height; ++y) {
            image.getByteSamples(0, X1, y + Y1, this.width, 1, row, 0);
            this.saveRow(out, y == 0, row, prev);
            if (this.compression == 0) {
                System.arraycopy(row, 0, prev, 0, row.length);
            }
            this.setProgress(y, this.height);
        }
        this.saveFinalCompressedSize(out);
    }

    private void save(DataOutput out, Paletted8Image image) throws IOException {
        boolean customPalette;
        Palette palette = image.getPalette();
        boolean system256Palette = PalmCodec.isPalmSystemPalette256(palette);
        boolean system16GrayPalette = PalmCodec.isPalmSystemPaletteGray16(palette);
        boolean system16ColorPalette = PalmCodec.isPalmSystemPaletteColor16(palette);
        boolean system4GrayPalette = PalmCodec.isPalmSystemPaletteGray4(palette);
        boolean bl = customPalette = !system256Palette && !system16GrayPalette && !system16ColorPalette && !system4GrayPalette;
        if (customPalette) {
            this.flags |= 0x4000;
        }
        if (palette.getNumEntries() <= 4) {
            this.bitsPerPixel = 2;
            this.bytesPerRow = (this.width + 3) / 4;
        } else if (palette.getNumEntries() <= 16) {
            this.bitsPerPixel = 4;
            this.bytesPerRow = (this.width + 1) / 2;
        } else {
            this.bitsPerPixel = 8;
            this.bytesPerRow = this.width;
        }
        if (this.bytesPerRow % 2 == 1) {
            ++this.bytesPerRow;
        }
        this.setCorrectVersion();
        this.saveHeader(out);
        if (customPalette) {
            this.savePalette(out, palette);
        }
        this.saveInitialCompressedSize(out);
        byte[] row = new byte[this.width];
        byte[] prev = null;
        if (this.compression == 0) {
            prev = new byte[row.length];
        }
        byte[] temp = null;
        if (this.bitsPerPixel < 8) {
            temp = new byte[this.width];
        }
        int X1 = this.getBoundsX1();
        int Y1 = this.getBoundsY1();
        for (int y = 0; y < this.height; ++y) {
            switch (this.bitsPerPixel) {
                case 2: {
                    image.getByteSamples(0, X1, y + Y1, this.width, 1, temp, 0);
                    ArrayConverter.encodePacked2Bit(temp, 0, row, 0, this.width);
                    break;
                }
                case 4: {
                    image.getByteSamples(0, X1, y + Y1, this.width, 1, temp, 0);
                    ArrayConverter.encodePacked4Bit(temp, 0, row, 0, this.width);
                    break;
                }
                case 8: {
                    image.getByteSamples(0, X1, y + Y1, this.width, 1, row, 0);
                }
            }
            this.saveRow(out, y == 0, row, prev);
            if (this.compression == 0) {
                System.arraycopy(row, 0, prev, 0, row.length);
            }
            this.setProgress(y, this.height);
        }
        this.saveFinalCompressedSize(out);
    }

    private void save(DataOutput out, RGB24Image image) throws IOException {
        this.bytesPerRow = this.width * 2;
        this.bitsPerPixel = 16;
        this.flags |= 0x400;
        this.setCorrectVersion();
        this.saveHeader(out);
        out.write(5);
        out.write(6);
        out.write(5);
        int i = 5;
        while (i-- > 0) {
            out.write(0);
        }
        this.compressedDataOffset += 8L;
        byte[] row = new byte[this.width * 2];
        byte[] prev = null;
        if (this.compression == 0) {
            prev = new byte[row.length];
        }
        byte[] red = new byte[this.width];
        byte[] green = new byte[this.width];
        byte[] blue = new byte[this.width];
        int X1 = this.getBoundsX1();
        int Y1 = this.getBoundsY1();
        for (int y = 0; y < this.height; ++y) {
            image.getByteSamples(0, X1, y + Y1, this.width, 1, red, 0);
            image.getByteSamples(1, X1, y + Y1, this.width, 1, green, 0);
            image.getByteSamples(2, X1, y + Y1, this.width, 1, blue, 0);
            ArrayConverter.encodeRGB24ToPackedRGB565BigEndian(red, 0, green, 0, blue, 0, row, 0, this.width);
            this.saveRow(out, y == 0, row, prev);
            if (this.compression == 0) {
                System.arraycopy(row, 0, prev, 0, row.length);
            }
            this.setProgress(y, this.height);
        }
        this.saveFinalCompressedSize(out);
    }

    private void saveFinalCompressedSize(DataOutput out) throws IOException {
        if ((this.flags & 0x8000) == 0) {
            return;
        }
        if (!(out instanceof RandomAccessFile) && !(out instanceof SeekableByteArrayOutputStream)) {
            return;
        }
        long pos = -1L;
        if (out instanceof RandomAccessFile) {
            RandomAccessFile raf = (RandomAccessFile)out;
            pos = raf.length();
        } else if (out instanceof SeekableByteArrayOutputStream) {
            SeekableByteArrayOutputStream sbaos = (SeekableByteArrayOutputStream)((Object)out);
            pos = sbaos.getPosition();
        }
        long compressedSize = pos - this.compressedDataOffset;
        compressedSize = Math.min(65535L, compressedSize);
        if (out instanceof RandomAccessFile) {
            RandomAccessFile raf = (RandomAccessFile)out;
            raf.seek(this.compressedDataOffset);
            raf.writeShort((int)compressedSize);
        } else if (out instanceof SeekableByteArrayOutputStream) {
            SeekableByteArrayOutputStream sbaos = (SeekableByteArrayOutputStream)((Object)out);
            sbaos.seek((int)this.compressedDataOffset);
            sbaos.write((int)(compressedSize >> 8) & 0xFF);
            sbaos.write((int)compressedSize & 0xFF);
        }
    }

    private void saveHeader(DataOutput out) throws IOException {
        out.writeShort(this.width);
        out.writeShort(this.height);
        out.writeShort(this.bytesPerRow);
        out.writeShort(this.flags);
        out.writeByte(this.bitsPerPixel);
        out.writeByte(this.version);
        out.writeShort(0);
        out.writeByte(this.transparencyIndex);
        out.writeByte(this.compression);
        out.writeShort(0);
        this.compressedDataOffset = 16L;
    }

    private void saveInitialCompressedSize(DataOutput out) throws IOException {
        if ((this.flags & 0x8000) == 0) {
            return;
        }
        out.writeShort(this.bytesPerRow * this.height);
    }

    private void savePalette(DataOutput out, Palette palette) throws IOException {
        out.writeShort(palette.getNumEntries());
        for (int i = 0; i < palette.getNumEntries(); ++i) {
            out.writeByte(0);
            out.writeByte(palette.getSample(0, i));
            out.writeByte(palette.getSample(1, i));
            out.writeByte(palette.getSample(2, i));
        }
        this.compressedDataOffset += (long)(2 + 4 * palette.getNumEntries());
    }

    private void saveRow(DataOutput out, boolean firstRow, byte[] row, byte[] prev) throws IOException {
        switch (this.compression) {
            case 255: {
                out.write(row, 0, this.bytesPerRow);
                break;
            }
            case 1: {
                this.saveRowRLE(out, row);
                break;
            }
            case 0: {
                this.saveRowScanLine(out, firstRow, row, prev);
            }
        }
    }

    private void saveRowRLE(DataOutput out, byte[] row) throws IOException {
        int runLength;
        int srcOffset = 0;
        do {
            runLength = 1;
            int bytesLeft = this.bytesPerRow - srcOffset;
            byte value = row[srcOffset];
            while (bytesLeft != 0 && srcOffset + runLength < row.length && value == row[srcOffset + runLength]) {
                --bytesLeft;
                if (++runLength != 255) continue;
                bytesLeft = 0;
            }
            out.writeByte(runLength);
            out.writeByte(value & 0xFF);
        } while ((srcOffset += runLength) < this.bytesPerRow);
    }

    private void saveRowScanLine(DataOutput out, boolean firstRow, byte[] row, byte[] prev) throws IOException {
        int bytesLeft = this.bytesPerRow;
        int srcOffset = 0;
        byte[] bytes = new byte[8];
        do {
            int pixelMask = 0;
            int bitMask = 128;
            int numBytesToCheck = Math.min(8, bytesLeft);
            int numOutputBytes = 0;
            bytesLeft -= numBytesToCheck;
            while (numBytesToCheck-- != 0) {
                if (row[srcOffset] != prev[srcOffset]) {
                    pixelMask |= bitMask;
                    bytes[numOutputBytes++] = row[srcOffset];
                }
                ++srcOffset;
                bitMask >>= 1;
            }
            out.writeByte(pixelMask);
            out.write(bytes, 0, numOutputBytes);
        } while (bytesLeft != 0);
    }

    public void setCompression(int newCompressionType) {
        if (newCompressionType != 255 && newCompressionType != 1 && newCompressionType != 0) {
            throw new IllegalArgumentException("Unsupported Palm compression type for writing.");
        }
        this.compression = newCompressionType;
    }

    private void setCorrectVersion() {
        this.version = 0;
        if (this.bitsPerPixel > 1) {
            this.version = 1;
        }
        if (this.hasTransparencyIndex() || this.getCompression() == 0 || this.getCompression() == 1) {
            this.version = 2;
        }
    }

    public void setFile(String fileName, CodecMode codecMode) throws IOException, UnsupportedCodecModeException {
        if (codecMode == CodecMode.LOAD) {
            super.setFile(fileName, codecMode);
        } else {
            this.setRandomAccessFile(new RandomAccessFile(fileName, "rw"), CodecMode.SAVE);
        }
    }

    public void setTransparencyIndex(int newIndex) {
        if (newIndex < 0) {
            throw new IllegalArgumentException("Transparency index must be 0 or larger.");
        }
        this.transparencyIndex = newIndex;
    }

    private void store(PixelImage image, int y, byte[] row) {
        if (!this.isRowRequired(y)) {
            return;
        }
        y -= this.getBoundsY1();
        switch (this.bitsPerPixel) {
            case 1: {
                BilevelImage bimage = (BilevelImage)image;
                this.invertBilevelData(row);
                bimage.putPackedBytes(0, y, this.getBoundsWidth(), row, this.getBoundsX1() / 8, this.getBoundsX1() % 8);
                break;
            }
            case 2: {
                byte[] dest = new byte[this.bytesPerRow * 4];
                ArrayConverter.decodePacked2Bit(row, 0, dest, 0, this.bytesPerRow);
                ByteChannelImage bcimg = (ByteChannelImage)image;
                bcimg.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 4: {
                byte[] dest = new byte[this.bytesPerRow * 2];
                ArrayConverter.decodePacked4Bit(row, 0, dest, 0, this.bytesPerRow);
                ByteChannelImage bcimg = (ByteChannelImage)image;
                bcimg.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 8: {
                ByteChannelImage bcimg = (ByteChannelImage)image;
                bcimg.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, row, this.getBoundsX1());
                break;
            }
            case 16: {
                ArrayConverter.decodePackedRGB565BigEndianToRGB24(row, this.getBoundsX1() * 2, this.rgb, 0, this.rgb, this.width, this.rgb, this.width * 2, this.getBoundsWidth());
                RGB24Image img = (RGB24Image)image;
                img.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, this.rgb, 0);
                img.putByteSamples(1, 0, y, this.getBoundsWidth(), 1, this.rgb, this.width);
                img.putByteSamples(2, 0, y, this.getBoundsWidth(), 1, this.rgb, this.width * 2);
                break;
            }
        }
    }

    public String suggestFileExtension(PixelImage image) {
        return ".palm";
    }
}

