/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.GrayImage;
import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray16Image;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.MemoryRGB48Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class PNMCodec
extends ImageCodec {
    public static final int IMAGE_TYPE_UNKNOWN = -1;
    public static final int IMAGE_TYPE_BILEVEL = 0;
    public static final int IMAGE_TYPE_GRAY = 1;
    public static final int IMAGE_TYPE_COLOR = 2;
    private static final String[] IMAGE_TYPE_FILE_EXTENSIONS = new String[]{".pbm", ".pgm", ".ppm"};
    private Boolean ascii;
    private int columns;
    private int imageType;
    private PushbackInputStream in;
    private DataOutput out;
    private int height;
    private int maxSample;
    private int width;

    public static int determineImageTypeFromFileName(String fileName) {
        if (fileName == null || fileName.length() < 4) {
            return -1;
        }
        String ext = fileName.substring(fileName.length() - 3);
        ext = ext.toLowerCase();
        for (int i = 0; i < IMAGE_TYPE_FILE_EXTENSIONS.length; ++i) {
            if (!IMAGE_TYPE_FILE_EXTENSIONS[i].equals(ext)) continue;
            return i;
        }
        return -1;
    }

    public Boolean getAscii() {
        return this.ascii;
    }

    public String getFormatName() {
        return "Portable Anymap (PBM, PGM, PPM)";
    }

    public String[] getMimeTypes() {
        return new String[]{"image/x-ppm", "image/x-pgm", "image/x-pbm", "image/x-pnm", "image/x-portable-pixmap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-anymap"};
    }

    public static String getTypicalFileExtension(int imageType) {
        if (imageType >= 0 && imageType < IMAGE_TYPE_FILE_EXTENSIONS.length) {
            return IMAGE_TYPE_FILE_EXTENSIONS[imageType];
        }
        return null;
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public boolean isSavingSupported() {
        return true;
    }

    private void load() throws InvalidFileStructureException, IOException, MissingParameterException, UnsupportedTypeException, WrongFileFormatException, WrongParameterException {
        InputStream is = this.getInputStream();
        if (is != null) {
            this.in = is instanceof PushbackInputStream ? (PushbackInputStream)is : new PushbackInputStream(is);
        } else {
            throw new MissingParameterException("InputStream object required for loading.");
        }
        this.loadType();
        String resolutionLine = this.loadTextLine();
        this.setResolution(resolutionLine);
        this.setBoundsIfNecessary(this.width, this.height);
        if (this.imageType == 0) {
            this.maxSample = 1;
        } else {
            String maxSampleLine = this.loadTextLine();
            this.setMaximumSample(maxSampleLine);
        }
        if (this.maxSample > 65535) {
            throw new UnsupportedTypeException("Cannot deal with samples larger than 65535.");
        }
        this.checkImageResolution();
        switch (this.imageType) {
            case 0: {
                this.loadBilevelImage();
                break;
            }
            case 2: {
                this.loadColorImage();
                break;
            }
            case 1: {
                this.loadGrayImage();
                break;
            }
            default: {
                throw new UnsupportedTypeException("Cannot deal with image type.");
            }
        }
    }

    private int loadAsciiNumber() throws InvalidFileStructureException, IOException {
        int b;
        boolean hasDigit = false;
        int result = -1;
        while (true) {
            if ((b = this.in.read()) >= 48 && b <= 57) {
                if (hasDigit) {
                    result = result * 10 + (b - 48);
                    continue;
                }
                hasDigit = true;
                result = b - 48;
                continue;
            }
            if (b == 32 || b == 10 || b == 13 || b == 9) {
                if (!hasDigit) continue;
                if (result > this.maxSample) {
                    throw new InvalidFileStructureException("Read number from PNM stream that is larger than allowed maximum sample value " + this.maxSample + " (" + result + ").");
                }
                return result;
            }
            if (b != 35) break;
            if (hasDigit) {
                this.in.unread(b);
                if (result > this.maxSample) {
                    throw new InvalidFileStructureException("Read number from PNM stream that is larger than allowed maximum sample value " + this.maxSample + " (" + result + ").");
                }
                return result;
            }
            while ((b = this.in.read()) != -1 && b != 10 && b != 13) {
            }
            if (b != 13) continue;
        }
        if (b == -1) {
            if (hasDigit) {
                if (result > this.maxSample) {
                    throw new InvalidFileStructureException("Read number from PNM stream that is larger than allowed maximum sample value " + this.maxSample + " (" + result + ")");
                }
                return result;
            }
            throw new InvalidFileStructureException("Unexpected end of file while reading ASCII number from PNM stream.");
        }
        throw new InvalidFileStructureException("Read invalid character from PNM stream: " + b + " dec.");
    }

    private void loadBilevelImage() throws InvalidFileStructureException, IOException, WrongParameterException {
        PixelImage image = this.getImage();
        if (image == null) {
            this.setImage(new MemoryBilevelImage(this.getBoundsWidth(), this.getBoundsHeight()));
        } else if (!(image instanceof BilevelImage)) {
            throw new WrongParameterException("Specified input image must implement BilevelImage for this image type.");
        }
        if (this.getAscii().booleanValue()) {
            this.loadBilevelImageAscii();
        } else {
            this.loadBilevelImageBinary();
        }
    }

    private void loadBilevelImageAscii() throws InvalidFileStructureException, IOException {
        BilevelImage image = (BilevelImage)this.getImage();
        int pixelsToSkip = this.width * this.getBoundsY1();
        for (int i = 0; i < pixelsToSkip; ++i) {
            this.loadAsciiNumber();
        }
        int NUM_ROWS = this.getBoundsHeight();
        int COLUMNS = this.getBoundsWidth();
        int X1 = this.getBoundsX1();
        int[] row = new int[this.width];
        for (int y = 0; y < NUM_ROWS; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int value = this.loadAsciiNumber();
                if (value == 0) {
                    row[x] = 1;
                    continue;
                }
                if (value == 1) {
                    row[x] = 0;
                    continue;
                }
                throw new InvalidFileStructureException("Loaded number for position x=" + x + ", y=" + (y + this.getBoundsY1()) + " is neither 0 nor 1 in PBM stream: " + value);
            }
            image.putSamples(0, 0, y, COLUMNS, 1, row, X1);
            this.setProgress(y, NUM_ROWS);
        }
    }

    private void loadBilevelImageBinary() throws InvalidFileStructureException, IOException {
        BilevelImage image = (BilevelImage)this.getImage();
        int bytesPerRow = (this.width + 7) / 8;
        long bytesToSkip = (long)this.getBoundsY1() * (long)bytesPerRow;
        while (bytesToSkip-- > 0L) {
            this.in.read();
        }
        byte[] row = new byte[bytesPerRow];
        int numRows = this.getBoundsHeight();
        for (int y = 0; y < numRows; ++y) {
            int result;
            int index = 0;
            for (int bytesToRead = bytesPerRow; bytesToRead > 0; bytesToRead -= result) {
                result = this.in.read(row, index, bytesToRead);
                if (result >= 0) {
                    index += result;
                    continue;
                }
                throw new InvalidFileStructureException("Unexpected end of input stream while reading.");
            }
            for (int x = 0; x < row.length; ++x) {
                row[x] = ~row[x];
            }
            if (this.isRowRequired(y)) {
                image.putPackedBytes(0, y - this.getBoundsY1(), this.getBoundsWidth(), row, this.getBoundsX1() >> 3, this.getBoundsX1() & 7);
            }
            this.setProgress(y, numRows);
        }
    }

    private int read16BitBinaryValue() throws IOException {
        int byte1 = this.in.read();
        if (byte1 < 0) {
            return -1;
        }
        int byte2 = this.in.read();
        if (byte2 < 0) {
            return -1;
        }
        return byte1 << 8 | byte2;
    }

    private void loadColorImage() throws InvalidFileStructureException, IOException {
        RGBIntegerImage image = null;
        MemoryRGB24Image image24 = null;
        MemoryRGB48Image image48 = null;
        if (this.maxSample <= 255) {
            image24 = new MemoryRGB24Image(this.width, this.height);
            image = image24;
            this.setImage(image);
        } else {
            image48 = new MemoryRGB48Image(this.width, this.height);
            image = image48;
            this.setImage(image);
        }
        int y = 0;
        int destY = -this.getBoundsY1();
        while (y < this.height) {
            int blue;
            int green;
            int red;
            int x;
            if (this.getAscii().booleanValue()) {
                for (x = 0; x < this.width; ++x) {
                    red = this.loadAsciiNumber();
                    if (red < 0 || red > this.maxSample) {
                        throw new InvalidFileStructureException("Invalid sample value " + red + " for red sample at (x=" + x + ", y=" + y + ").");
                    }
                    image.putSample(0, x, y, red);
                    green = this.loadAsciiNumber();
                    if (green < 0 || green > this.maxSample) {
                        throw new InvalidFileStructureException("Invalid sample value " + green + " for green sample at (x=" + x + ", y=" + y + ").");
                    }
                    image.putSample(1, x, y, green);
                    blue = this.loadAsciiNumber();
                    if (blue < 0 || blue > this.maxSample) {
                        throw new InvalidFileStructureException("Invalid sample value " + blue + " for blue sample at (x=" + x + ", y=" + y + ").");
                    }
                    image.putSample(2, x, y, blue);
                }
            } else if (image24 != null) {
                for (x = 0; x < this.width; ++x) {
                    red = this.in.read();
                    if (red == -1) {
                        throw new InvalidFileStructureException("Unexpected end of file while reading red sample for pixel x=" + x + ", y=" + y + ".");
                    }
                    image24.putByteSample(0, x, y, (byte)(red & 0xFF));
                    green = this.in.read();
                    if (green == -1) {
                        throw new InvalidFileStructureException("Unexpected end of file while reading green sample for pixel x=" + x + ", y=" + y + ".");
                    }
                    image24.putByteSample(1, x, y, (byte)(green & 0xFF));
                    blue = this.in.read();
                    if (blue == -1) {
                        throw new InvalidFileStructureException("Unexpected end of file while reading blue sample for pixel x=" + x + ", y=" + y + ".");
                    }
                    image24.putByteSample(2, x, y, (byte)(blue & 0xFF));
                }
            } else if (image48 != null) {
                for (x = 0; x < this.width; ++x) {
                    red = this.read16BitBinaryValue();
                    if (red == -1) {
                        throw new InvalidFileStructureException("Unexpected end of file while reading red sample for pixel x=" + x + ", y=" + y + ".");
                    }
                    image48.putShortSample(0, x, y, (short)(red & 0xFFFF));
                    green = this.read16BitBinaryValue();
                    if (green == -1) {
                        throw new InvalidFileStructureException("Unexpected end of file while reading green sample for pixel x=" + x + ", y=" + y + ".");
                    }
                    image48.putShortSample(1, x, y, (short)(green & 0xFFFF));
                    blue = this.read16BitBinaryValue();
                    if (blue == -1) {
                        throw new InvalidFileStructureException("Unexpected end of file while reading blue sample for pixel x=" + x + ", y=" + y + ".");
                    }
                    image48.putShortSample(2, x, y, (short)(blue & 0xFFFF));
                }
            }
            this.setProgress(y, this.getBoundsHeight());
            ++y;
            ++destY;
        }
    }

    private void loadGrayImage() throws InvalidFileStructureException, IOException, UnsupportedTypeException {
        int WIDTH = this.getBoundsWidth();
        int HEIGHT = this.getBoundsHeight();
        PixelImage pimage = this.getImage();
        if (pimage == null) {
            if (this.maxSample < 256) {
                pimage = new MemoryGray8Image(WIDTH, HEIGHT);
            } else if (this.maxSample < 65536) {
                pimage = new MemoryGray16Image(WIDTH, HEIGHT);
            } else {
                throw new UnsupportedTypeException("Gray images with more than 16 bits per pixel are not supported.");
            }
            this.setImage(pimage);
        }
        GrayIntegerImage image = (GrayIntegerImage)pimage;
        int[] buffer = new int[this.width];
        int y = 0;
        for (int destY = -this.getBoundsY1(); destY < this.getBoundsHeight(); ++destY) {
            int x;
            if (this.getAscii().booleanValue()) {
                for (x = 0; x < this.width; ++x) {
                    buffer[x] = this.loadAsciiNumber();
                }
            } else if (this.maxSample < 256) {
                for (x = 0; x < this.width; ++x) {
                    buffer[x] = this.in.read();
                }
            } else {
                for (x = 0; x < this.width; ++x) {
                    int msb = this.in.read();
                    int lsb = this.in.read();
                    buffer[x] = msb << 8 | lsb;
                }
            }
            if (destY >= 0 && destY < this.getBoundsHeight()) {
                image.putSamples(0, 0, destY, this.getBoundsWidth(), 1, buffer, this.getBoundsX1());
            }
            this.setProgress(y, this.getBoundsY2() + 1);
            ++y;
        }
    }

    private String loadTextLine() throws InvalidFileStructureException, IOException {
        StringBuffer sb;
        boolean isComment;
        do {
            int b;
            boolean crOrLf;
            sb = new StringBuffer();
            do {
                if ((b = this.in.read()) == -1) {
                    throw new InvalidFileStructureException("Unexpected end of file in PNM stream.");
                }
                boolean bl = crOrLf = b == 10 || b == 13;
                if (crOrLf) continue;
                sb.append((char)b);
            } while (!crOrLf);
            if (b == 13 && (b = this.in.read()) != 10) {
                throw new InvalidFileStructureException("Unexpected end of file in PNM stream.");
            }
            boolean bl = isComment = sb.length() > 0 && sb.charAt(0) == '#';
            if (!isComment) continue;
            StringBuffer result = new StringBuffer(sb.length() - 1);
            int i = 1;
            while (i < sb.length()) {
                result.append(sb.charAt(i++));
            }
            this.appendComment(result.toString());
        } while (isComment);
        return sb.toString();
    }

    private void loadType() throws InvalidFileStructureException, IOException, WrongFileFormatException {
        int b;
        int v1 = this.in.read();
        int v2 = this.in.read();
        if (v1 != 80) {
            throw new WrongFileFormatException("Not a PNM stream. First byte in PNM stream is expected to be 0x50 ('P'); found: " + v1 + " (dec).");
        }
        if (v2 < 49 || v2 > 54) {
            throw new WrongFileFormatException("Not a PNM stream. Second byte in PNM stream is expected to be the ASCII value of decimal digit between 1 and 6 (49 dec to 54 dec); found " + v2 + " dec.");
        }
        this.ascii = new Boolean(v2 < 52);
        this.imageType = ((v2 -= 48) - 1) % 3;
        while ((b = this.in.read()) == 10 || b == 13 || b == 32) {
        }
        if (b == -1) {
            throw new InvalidFileStructureException("Read type (" + v2 + "). Unexpected end of file in input PNM stream.");
        }
        this.in.unread(b);
    }

    public void process() throws MissingParameterException, OperationFailedException {
        this.initModeFromIOObjects();
        try {
            if (this.getMode() == CodecMode.LOAD) {
                this.load();
            } else {
                this.save();
            }
        }
        catch (IOException ioe) {
            throw new OperationFailedException("I/O error: " + ioe.toString());
        }
    }

    private void save() throws IOException, MissingParameterException, WrongParameterException {
        this.out = this.getOutputAsDataOutput();
        if (this.out == null) {
            throw new WrongParameterException("Cannot get a DataOutput object to use for saving.");
        }
        PixelImage pi = this.getImage();
        if (pi == null) {
            throw new MissingParameterException("Input image missing.");
        }
        if (!(pi instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must implement IntegerImage.");
        }
        IntegerImage image = (IntegerImage)pi;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.setBoundsIfNecessary(this.width, this.height);
        if (image instanceof RGB24Image) {
            this.imageType = 2;
            this.maxSample = 255;
            this.save((RGB24Image)image);
        } else if (image instanceof RGB48Image) {
            this.imageType = 2;
            this.maxSample = 65535;
            this.save((RGB48Image)image);
        } else if (image instanceof BilevelImage) {
            this.imageType = 0;
            this.maxSample = 1;
            this.save((BilevelImage)image);
        } else if (image instanceof Gray8Image) {
            this.imageType = 1;
            this.maxSample = 255;
            this.save((Gray8Image)image);
        } else if (image instanceof Gray16Image) {
            this.imageType = 1;
            this.maxSample = 65535;
            this.save((Gray16Image)image);
        } else {
            throw new WrongParameterException("Unsupported input image type: " + image.getClass().getName());
        }
        this.close();
    }

    private void save(BilevelImage image) throws IOException {
        this.saveHeader();
        int WIDTH = this.getBoundsWidth();
        int HEIGHT = this.getBoundsHeight();
        int BYTES_PER_ROW = (WIDTH + 7) / 8;
        byte[] buffer = new byte[BYTES_PER_ROW];
        int y = 0;
        int srcY = this.getBoundsY1();
        while (y < HEIGHT) {
            int x;
            if (this.getAscii().booleanValue()) {
                x = 0;
                int srcX = this.getBoundsX1();
                while (x < WIDTH) {
                    if (image.isBlack(srcX, srcY)) {
                        this.out.write(49);
                    } else {
                        this.out.write(48);
                    }
                    ++this.columns;
                    if (this.columns > 70) {
                        this.columns = 0;
                        this.out.write(10);
                    } else {
                        this.out.write(32);
                        ++this.columns;
                    }
                    ++x;
                    ++srcX;
                }
            } else {
                image.getPackedBytes(this.getBoundsX1(), srcY, WIDTH, buffer, 0, 0);
                for (x = 0; x < buffer.length; ++x) {
                    buffer[x] = ~buffer[x];
                }
                this.out.write(buffer);
            }
            this.setProgress(y, HEIGHT);
            ++y;
            ++srcY;
        }
    }

    private void save(Gray8Image image) throws IOException {
        this.saveHeader();
        int HEIGHT = this.getBoundsHeight();
        int WIDTH = this.getBoundsWidth();
        int X1 = this.getBoundsX1();
        System.out.println(WIDTH + " " + HEIGHT + " " + X1);
        byte[] buffer = new byte[WIDTH];
        int y = 0;
        int srcY = this.getBoundsY1();
        while (y < HEIGHT) {
            image.getByteSamples(0, X1, srcY, WIDTH, 1, buffer, 0);
            if (this.getAscii().booleanValue()) {
                for (int x = 0; x < WIDTH; ++x) {
                    this.saveAsciiNumber(buffer[x] & 0xFF);
                    this.out.write(32);
                    this.columns += 2;
                    if (this.columns > 70) {
                        this.columns = 0;
                        this.out.write(10);
                        continue;
                    }
                    this.out.write(32);
                    ++this.columns;
                }
            } else {
                this.out.write(buffer);
            }
            this.setProgress(y, HEIGHT);
            ++y;
            ++srcY;
        }
    }

    private void save(Gray16Image image) throws IOException {
        this.saveHeader();
        int HEIGHT = this.getBoundsHeight();
        int WIDTH = this.getBoundsWidth();
        int X1 = this.getBoundsX1();
        short[] buffer = new short[WIDTH];
        int y = 0;
        int srcY = this.getBoundsY1();
        while (y < HEIGHT) {
            int x;
            image.getShortSamples(0, X1, srcY, WIDTH, 1, buffer, 0);
            if (this.getAscii().booleanValue()) {
                for (x = 0; x < WIDTH; ++x) {
                    this.saveAsciiNumber(buffer[x] & 0xFFFF);
                    this.out.write(32);
                    this.columns += 4;
                    if (this.columns > 70) {
                        this.columns = 0;
                        this.out.write(10);
                        continue;
                    }
                    this.out.write(32);
                    ++this.columns;
                }
            } else {
                for (x = 0; x < WIDTH; ++x) {
                    int sample = buffer[x] & 0xFFFF;
                    this.out.write(sample >> 8 & 0xFF);
                    this.out.write(sample & 0xFF);
                }
            }
            this.setProgress(y, HEIGHT);
            ++y;
            ++srcY;
        }
    }

    private void save(RGB24Image image) throws IOException {
        this.saveHeader();
        int WIDTH = this.getBoundsWidth();
        int HEIGHT = this.getBoundsHeight();
        int y = 0;
        int srcY = this.getBoundsY1();
        while (y < HEIGHT) {
            int srcX;
            int x;
            if (this.getAscii().booleanValue()) {
                x = 0;
                srcX = this.getBoundsX1();
                while (x < WIDTH) {
                    int red = image.getSample(0, srcX, srcY);
                    int green = image.getSample(1, srcX, srcY);
                    int blue = image.getSample(2, srcX, srcY);
                    this.saveAsciiNumber(red);
                    this.out.write(32);
                    this.saveAsciiNumber(green);
                    this.out.write(32);
                    this.saveAsciiNumber(blue);
                    this.columns += 11;
                    if (this.columns > 80) {
                        this.columns = 0;
                        this.out.write(10);
                    } else {
                        this.out.write(32);
                        ++this.columns;
                    }
                    ++x;
                    ++srcX;
                }
            } else {
                x = 0;
                srcX = this.getBoundsX1();
                while (x < WIDTH) {
                    this.out.write(image.getSample(0, srcX, srcY));
                    this.out.write(image.getSample(1, srcX, srcY));
                    this.out.write(image.getSample(2, srcX, srcY));
                    ++x;
                    ++srcX;
                }
            }
            this.setProgress(y, HEIGHT);
            ++y;
            ++srcY;
        }
    }

    private void save(RGB48Image image) throws IOException {
        this.saveHeader();
        int WIDTH = this.getBoundsWidth();
        int HEIGHT = this.getBoundsHeight();
        int y = 0;
        int srcY = this.getBoundsY1();
        while (y < HEIGHT) {
            if (this.getAscii().booleanValue()) {
                int x = 0;
                int srcX = this.getBoundsX1();
                while (x < WIDTH) {
                    int red = image.getSample(0, srcX, srcY);
                    int green = image.getSample(1, srcX, srcY);
                    int blue = image.getSample(2, srcX, srcY);
                    this.saveAsciiNumber(red);
                    this.out.write(32);
                    this.saveAsciiNumber(green);
                    this.out.write(32);
                    this.saveAsciiNumber(blue);
                    this.columns += 13;
                    if (this.columns > 80) {
                        this.columns = 0;
                        this.out.write(10);
                    } else {
                        this.out.write(32);
                        ++this.columns;
                    }
                    ++x;
                    ++srcX;
                }
            }
            this.setProgress(y, HEIGHT);
            ++y;
            ++srcY;
        }
    }

    private void saveAsciiNumber(int number) throws IOException {
        String s = Integer.toString(number);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.out.write(c);
        }
        this.columns += s.length();
    }

    private void saveHeader() throws IOException {
        this.out.write(80);
        int pnmType = 49 + this.imageType;
        if (this.getAscii() == null) {
            this.setAscii(this.maxSample > 255);
        }
        if (!this.getAscii().booleanValue()) {
            pnmType += 3;
        }
        this.out.write(pnmType);
        this.out.write(10);
        this.saveAsciiNumber(this.getBoundsWidth());
        this.out.write(32);
        this.saveAsciiNumber(this.getBoundsHeight());
        this.out.write(10);
        if (this.imageType != 0) {
            this.saveAsciiNumber(this.maxSample);
            this.out.write(10);
        }
    }

    public void setAscii(boolean asciiMode) {
        this.ascii = new Boolean(asciiMode);
    }

    private void setMaximumSample(String line) throws InvalidFileStructureException {
        line = line.trim();
        try {
            this.maxSample = Integer.parseInt(line);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidFileStructureException("Not a valid value for the maximum sample: " + line);
        }
        if (this.maxSample < 0) {
            throw new InvalidFileStructureException("The value for the maximum sample must not be negative; found " + this.maxSample);
        }
    }

    private void setResolution(String line) throws InvalidFileStructureException {
        line = line.trim();
        StringTokenizer st = new StringTokenizer(line, " ");
        try {
            if (!st.hasMoreTokens()) {
                throw new InvalidFileStructureException("No width value found in line \"" + line + "\".");
            }
            String number = st.nextToken();
            try {
                this.width = Integer.parseInt(number);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidFileStructureException("Not a valid int value for width: " + number);
            }
            if (this.width < 1) {
                throw new InvalidFileStructureException("The width value must be larger than zero; found " + this.width + ".");
            }
            if (!st.hasMoreTokens()) {
                throw new InvalidFileStructureException("No height value found in line \"" + line + "\".");
            }
            number = st.nextToken();
            try {
                this.height = Integer.parseInt(number);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidFileStructureException("Not a valid int value for height: " + number);
            }
            if (this.height < 1) {
                throw new InvalidFileStructureException("The height value must be larger than zero; found " + this.width + ".");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public String suggestFileExtension(PixelImage image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BilevelImage) {
            return IMAGE_TYPE_FILE_EXTENSIONS[0];
        }
        if (image instanceof GrayImage) {
            return IMAGE_TYPE_FILE_EXTENSIONS[1];
        }
        if (image instanceof RGB24Image) {
            return IMAGE_TYPE_FILE_EXTENSIONS[2];
        }
        return null;
    }
}

