/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import net.sourceforge.jiu.codecs.BMPCodec;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.IFFCodec;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.InvalidImageIndexException;
import net.sourceforge.jiu.codecs.PCDCodec;
import net.sourceforge.jiu.codecs.PNGCodec;
import net.sourceforge.jiu.codecs.PNMCodec;
import net.sourceforge.jiu.codecs.PSDCodec;
import net.sourceforge.jiu.codecs.RASCodec;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.codecs.tiff.TIFFCodec;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.gui.awt.ImageCreator;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;

public class ImageLoader {
    private static Vector fileExtensions;
    private static Vector imageCodecClasses;

    private ImageLoader() {
    }

    public static ImageCodec createCodec(int index) {
        ImageCodec result = null;
        if (index >= 0 && index < ImageLoader.getNumCodecs()) {
            Class c = (Class)imageCodecClasses.elementAt(index);
            try {
                Object obj = c.newInstance();
                if (obj != null && obj instanceof ImageCodec) {
                    result = (ImageCodec)obj;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return result;
    }

    public static FilenameFilter createFilenameFilter() {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                if (fileExtensions == null) {
                    ImageLoader.updateFileExtensions();
                }
                name = name.toLowerCase();
                int index = 0;
                while (index < fileExtensions.size()) {
                    String ext = (String)fileExtensions.elementAt(index++);
                    if (!name.endsWith(ext)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static int getNumCodecs() {
        return imageCodecClasses.size();
    }

    public static PixelImage load(File file) throws IOException, InvalidFileStructureException, InvalidImageIndexException, UnsupportedTypeException {
        return ImageLoader.load(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PixelImage load(File file, Vector listeners) throws IOException, InvalidFileStructureException, InvalidImageIndexException, UnsupportedTypeException {
        for (int i = 0; i < ImageLoader.getNumCodecs(); ++i) {
            PixelImage result = null;
            ImageCodec codec = null;
            try {
                codec = ImageLoader.createCodec(i);
                codec.setFile(file, CodecMode.LOAD);
                codec.addProgressListeners(listeners);
                codec.process();
                result = codec.getImage();
                if (result == null) continue;
                PixelImage pixelImage = result;
                return pixelImage;
            }
            catch (MissingParameterException missingParameterException) {
                continue;
            }
            catch (WrongFileFormatException wrongFileFormatException) {
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (OperationFailedException operationFailedException) {
                continue;
            }
            finally {
                if (codec != null) {
                    codec.close();
                }
            }
        }
        return null;
    }

    public static PixelImage load(String fileName) throws IOException, InvalidFileStructureException, InvalidImageIndexException, UnsupportedTypeException {
        return ImageLoader.load(fileName, null);
    }

    public static PixelImage load(String fileName, Vector listeners) throws IOException, InvalidFileStructureException, InvalidImageIndexException, UnsupportedTypeException {
        return ImageLoader.load(new File(fileName), listeners);
    }

    public static PixelImage loadToolkitImageUri(String uri) throws IOException, InvalidFileStructureException, InvalidImageIndexException, UnsupportedTypeException {
        try {
            int b;
            ImageLoader loader = new ImageLoader();
            InputStream in = loader.getClass().getResourceAsStream(uri);
            if (in == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
            byte[] data = out.toByteArray();
            Image awtImage = Toolkit.getDefaultToolkit().createImage(data);
            MediaTracker mediaTracker = new MediaTracker(new Frame());
            mediaTracker.addImage(awtImage, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException ie) {
                return null;
            }
            RGB24Image image = ImageCreator.convertImageToRGB24Image(awtImage);
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void registerCodecClass(ImageCodec codec) {
        if (codec == null) {
            return;
        }
        if (imageCodecClasses.contains(codec.getClass())) {
            return;
        }
        if (!codec.isLoadingSupported()) {
            throw new IllegalArgumentException("Codec does not support loading.");
        }
        imageCodecClasses.addElement(codec.getClass());
        ImageLoader.updateFileExtensions();
    }

    public static void removeAllCodecClasses() {
        imageCodecClasses = new Vector();
        ImageLoader.updateFileExtensions();
    }

    public static void removeCodecClass(ImageCodec codec) {
        if (codec == null) {
            return;
        }
        int index = imageCodecClasses.indexOf(codec.getClass());
        if (index == -1) {
            throw new IllegalArgumentException("The argument codec's class could not be found in the internal list of codec classes.");
        }
        imageCodecClasses.remove(index);
        ImageLoader.updateFileExtensions();
    }

    private static void updateFileExtensions() {
        fileExtensions = new Vector();
        int index = 0;
        while (index < ImageLoader.getNumCodecs()) {
            try {
                ImageCodec codec;
                String[] extArray;
                if ((extArray = (codec = ImageLoader.createCodec(index++)).getFileExtensions()) == null || extArray.length <= 0) continue;
                for (int i = 0; i < extArray.length; ++i) {
                    fileExtensions.addElement(extArray[i].toLowerCase());
                }
            }
            catch (Exception exception) {
            }
        }
    }

    static {
        imageCodecClasses = new Vector();
        ImageLoader.registerCodecClass(new BMPCodec());
        ImageLoader.registerCodecClass(new IFFCodec());
        ImageLoader.registerCodecClass(new PCDCodec());
        ImageLoader.registerCodecClass(new PNGCodec());
        ImageLoader.registerCodecClass(new PNMCodec());
        ImageLoader.registerCodecClass(new PSDCodec());
        ImageLoader.registerCodecClass(new RASCodec());
        ImageLoader.registerCodecClass(new TIFFCodec());
    }
}

