/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.apps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import net.sourceforge.jiu.apps.Strings;

public class StringLoader {
    private BufferedReader in;
    private Integer langCode;
    public static String resourceDirectory = "/resources/lang/";

    public StringLoader() {
        this(Strings.determineSuitableIsoCode());
    }

    public StringLoader(String iso639Code) {
        InputStream input = this.getClass().getResourceAsStream(resourceDirectory + iso639Code + ".txt");
        if (input == null && !"en".equals(iso639Code)) {
            input = this.getClass().getResourceAsStream(resourceDirectory + "en.txt");
        }
        if (input == null) {
            return;
        }
        this.in = new BufferedReader(new InputStreamReader(input));
        this.langCode = Strings.findLanguageCode(iso639Code);
    }

    public Strings load() throws IOException {
        String line;
        if (this.in == null) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        while ((line = this.in.readLine()) != null) {
            list.addElement(line);
        }
        if (list.size() < 1) {
            return null;
        }
        String[] data = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            data[i] = (String)list.elementAt(i);
        }
        this.in.close();
        return new Strings(this.langCode, data);
    }
}

