/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.apps;

import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import net.sourceforge.jiu.apps.MenuIndexConstants;
import net.sourceforge.jiu.apps.StringLoader;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.Operation;
import net.sourceforge.jiu.ops.ProgressListener;

public class EditorState
implements MenuIndexConstants {
    public static final int DEFAULT_MAX_UNDO_IMAGES = 2;
    public static final int DEFAULT_MAX_REDO_IMAGES = 2;
    public static final int[] ZOOM_LEVELS = new int[]{5, 7, 10, 15, 20, 30, 50, 70, 100, 150, 200, 300, 500, 700, 1000, 2000, 3000, 5000};
    public static final int ORIGINAL_SIZE_ZOOM_INDEX = 8;
    public static final int INTERPOLATION_NEAREST_NEIGHBOR = 0;
    public static final int INTERPOLATION_BILINEAR = 1;
    public static final int INTERPOLATION_BICUBIC = 2;
    public static final int DEFAULT_INTERPOLATION = 0;
    private String currentDirectory;
    private String fileName;
    private PixelImage currentImage;
    private int interpolation;
    private Locale locale = Locale.getDefault();
    private int maxRedoImages;
    private int maxUndoImages;
    private boolean modified;
    private Vector progressListeners;
    private Vector redoImages;
    private Vector redoModified;
    private String startupImageName;
    private Strings strings;
    private Vector undoImages;
    private Vector undoModified;
    private int zoomIndex = 8;
    private double zoomFactorX;
    private double zoomFactorY;
    private boolean zoomToFit;

    public EditorState() {
        this.setStrings(null);
        this.progressListeners = new Vector();
        this.maxRedoImages = 2;
        this.maxUndoImages = 2;
        this.redoImages = new Vector(this.maxRedoImages);
        this.redoModified = new Vector(this.maxRedoImages);
        this.undoImages = new Vector(this.maxUndoImages);
        this.undoModified = new Vector(this.maxUndoImages);
        this.zoomFactorX = 1.0;
        this.zoomFactorY = 1.0;
        this.zoomToFit = false;
    }

    private void addImageToRedo(PixelImage image, boolean modifiedState) {
        if (this.maxRedoImages < 1) {
            return;
        }
        if (this.redoImages.size() == this.maxRedoImages) {
            this.redoImages.setElementAt(null, 0);
            this.redoImages.removeElementAt(0);
            this.redoModified.removeElementAt(0);
        }
        this.redoImages.addElement(image);
        this.redoModified.addElement(new Boolean(modifiedState));
    }

    private void addImageToUndo(PixelImage image, boolean modifiedState) {
        if (this.maxUndoImages < 1) {
            return;
        }
        if (this.undoImages.size() == this.maxUndoImages) {
            this.undoImages.setElementAt(null, 0);
            this.undoImages.removeElementAt(0);
            this.undoModified.removeElementAt(0);
        }
        this.undoImages.addElement(image);
        this.undoModified.addElement(new Boolean(modifiedState));
    }

    public void addProgressListener(ProgressListener pl) {
        this.progressListeners.addElement(pl);
    }

    public boolean canRedo() {
        return this.redoImages.size() > 0;
    }

    public boolean canUndo() {
        return this.undoImages.size() > 0;
    }

    public void clearRedo() {
        int index = 0;
        while (index < this.redoImages.size()) {
            this.redoImages.setElementAt(null, index++);
        }
        this.redoImages.setSize(0);
        this.redoModified.setSize(0);
    }

    public void clearUndo() {
        int index = 0;
        while (index < this.undoImages.size()) {
            this.undoImages.setElementAt(null, index++);
        }
        this.undoImages.setSize(0);
        this.undoModified.setSize(0);
    }

    public void ensureStringsAvailable() {
        if (this.getStrings() == null) {
            this.setStrings(Strings.DEFAULT_LANGUAGE_ISO_639_CODE);
        }
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public PixelImage getImage() {
        return this.currentImage;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean getModified() {
        return this.modified;
    }

    public Vector getProgressListeners() {
        return this.progressListeners;
    }

    public String getStartupImageName() {
        return this.startupImageName;
    }

    public Strings getStrings() {
        return this.strings;
    }

    public double getZoomFactorX() {
        return this.zoomFactorX;
    }

    public double getZoomFactorY() {
        return this.zoomFactorY;
    }

    public boolean getZoomToFit() {
        return this.zoomToFit;
    }

    public boolean hasImage() {
        return this.currentImage != null;
    }

    public void installProgressListeners(Operation op) {
        if (op == null) {
            return;
        }
        int index = 0;
        while (index < this.progressListeners.size()) {
            ProgressListener pl = (ProgressListener)this.progressListeners.elementAt(index++);
            op.addProgressListener(pl);
        }
    }

    public boolean isMaximumZoom() {
        return this.zoomIndex == ZOOM_LEVELS.length - 1;
    }

    public boolean isMinimumZoom() {
        return this.zoomIndex == 0;
    }

    public boolean isZoomOriginalSize() {
        return this.zoomIndex == 8;
    }

    public void redo() {
        if (this.redoImages.size() < 1) {
            return;
        }
        this.addImageToUndo(this.currentImage, this.modified);
        int redoIndex = this.redoImages.size() - 1;
        this.currentImage = (PixelImage)this.redoImages.elementAt(redoIndex);
        this.redoImages.setElementAt(null, redoIndex);
        this.redoImages.setSize(redoIndex);
        this.modified = (Boolean)this.redoModified.elementAt(redoIndex);
        this.redoModified.setSize(redoIndex);
    }

    public void resetZoomFactors() {
        this.setZoomFactors(1.0, 1.0);
    }

    public void setCurrentDirectory(String newCurrentDirectory) {
        this.currentDirectory = newCurrentDirectory;
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public void setImage(PixelImage image, boolean newModifiedState) {
        if (this.hasImage()) {
            this.addImageToUndo(this.currentImage, this.modified);
        }
        this.currentImage = image;
        this.modified = newModifiedState;
        this.clearRedo();
    }

    public void setStartupImageName(String name) {
        this.startupImageName = name;
    }

    public void setInterpolation(int newInterpolation) {
        if (newInterpolation == 0 || newInterpolation == 1 || newInterpolation == 2) {
            this.interpolation = newInterpolation;
        }
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
    }

    public void setStrings(String iso639Code) {
        Strings newStrings = null;
        try {
            StringLoader loader = iso639Code == null ? new StringLoader() : new StringLoader(iso639Code);
            newStrings = loader.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (newStrings != null) {
            this.strings = newStrings;
        }
    }

    public void setZoomFactors(double zoomX, double zoomY) {
        this.zoomFactorX = zoomX;
        this.zoomFactorY = zoomY;
    }

    public void undo() {
        if (this.undoImages.size() < 1) {
            return;
        }
        this.addImageToRedo(this.currentImage, this.modified);
        int undoIndex = this.undoImages.size() - 1;
        this.currentImage = (PixelImage)this.undoImages.elementAt(undoIndex);
        this.undoImages.setElementAt(null, undoIndex);
        this.undoImages.setSize(undoIndex);
        this.modified = (Boolean)this.undoModified.elementAt(undoIndex);
        this.undoModified.setSize(undoIndex);
    }

    public void zoomIn() {
        if (this.zoomIndex + 1 == ZOOM_LEVELS.length) {
            return;
        }
        ++this.zoomIndex;
        this.zoomFactorY = this.zoomFactorX = 1.0 * (double)ZOOM_LEVELS[this.zoomIndex] / 100.0;
    }

    public void zoomOut() {
        if (this.zoomIndex == 0) {
            return;
        }
        --this.zoomIndex;
        this.zoomFactorY = this.zoomFactorX = 1.0 * (double)ZOOM_LEVELS[this.zoomIndex] / 100.0;
    }

    public void zoomSetOriginalSize() {
        this.zoomIndex = 8;
        this.zoomFactorX = 1.0;
        this.zoomFactorY = 1.0;
    }
}

