/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleAsymmetricConfig;
import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleAsymmetricStringEncryptor;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import com.ulisesbocchio.jasyptspringboot.util.AsymmetricCryptography;
import com.ulisesbocchio.jasyptspringboot.util.Functional;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.util.Optional;
import java.util.function.Supplier;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class DefaultLazyEncryptor
implements StringEncryptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultLazyEncryptor.class);
    private final Singleton<StringEncryptor> singleton;

    public DefaultLazyEncryptor(ConfigurableEnvironment e, String customEncryptorBeanName, boolean isCustom, BeanFactory bf) {
        this.singleton = new Singleton<StringEncryptor>(() -> Optional.of(customEncryptorBeanName).filter(arg_0 -> ((BeanFactory)bf).containsBean(arg_0)).map(name -> (StringEncryptor)bf.getBean(name)).map(Functional.tap(bean -> log.info("Found Custom Encryptor Bean {} with name: {}", bean, (Object)customEncryptorBeanName))).orElseGet(() -> {
            if (isCustom) {
                throw new IllegalStateException(String.format("String Encryptor custom Bean not found with name '%s'", customEncryptorBeanName));
            }
            log.info("String Encryptor custom Bean not found with name '{}'. Initializing Default String Encryptor", (Object)customEncryptorBeanName);
            return this.createDefault(e);
        }));
    }

    public DefaultLazyEncryptor(ConfigurableEnvironment e) {
        this.singleton = new Singleton<StringEncryptor>(() -> this.createDefault(e));
    }

    private StringEncryptor createDefault(ConfigurableEnvironment e) {
        JasyptEncryptorConfigurationProperties configProps = JasyptEncryptorConfigurationProperties.bindConfigProps(e);
        return Optional.of(configProps).filter(DefaultLazyEncryptor::isPBEConfig).map(this::createPBEDefault).orElseGet(() -> Optional.of(configProps).filter(DefaultLazyEncryptor::isAsymmetricConfig).map(this::createAsymmetricDefault).orElseThrow(() -> new IllegalStateException("either 'jasypt.encryptor.password' or one of ['jasypt.encryptor.private-key-string', 'jasypt.encryptor.private-key-location'] must be provided for Password-based or Asymmetric encryption")));
    }

    private StringEncryptor createAsymmetricDefault(JasyptEncryptorConfigurationProperties configProps) {
        SimpleAsymmetricConfig config = new SimpleAsymmetricConfig();
        config.setPrivateKey(DefaultLazyEncryptor.get(configProps::getPrivateKeyString, "jasypt.encryptor.private-key-string", null));
        config.setPrivateKeyLocation(DefaultLazyEncryptor.get(configProps::getPrivateKeyLocation, "jasypt.encryptor.private-key-location", null));
        config.setPrivateKeyFormat(DefaultLazyEncryptor.get(configProps::getPrivateKeyFormat, "jasypt.encryptor.private-key-format", AsymmetricCryptography.KeyFormat.DER));
        return new SimpleAsymmetricStringEncryptor(config);
    }

    private StringEncryptor createPBEDefault(JasyptEncryptorConfigurationProperties configProps) {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(DefaultLazyEncryptor.getRequired(configProps::getPassword, "jasypt.encryptor.password"));
        config.setAlgorithm(DefaultLazyEncryptor.get(configProps::getAlgorithm, "jasypt.encryptor.algorithm", "PBEWITHHMACSHA512ANDAES_256"));
        config.setKeyObtentionIterations(DefaultLazyEncryptor.get(configProps::getKeyObtentionIterations, "jasypt.encryptor.key-obtention-iterations", "1000"));
        config.setPoolSize(DefaultLazyEncryptor.get(configProps::getPoolSize, "jasypt.encryptor.pool-size", "1"));
        config.setProviderName((String)DefaultLazyEncryptor.get(configProps::getProviderName, "jasypt.encryptor.provider-name", null));
        config.setProviderClassName((String)DefaultLazyEncryptor.get(configProps::getProviderClassName, "jasypt.encryptor.provider-class-name", null));
        config.setSaltGeneratorClassName(DefaultLazyEncryptor.get(configProps::getSaltGeneratorClassname, "jasypt.encryptor.salt-generator-classname", "org.jasypt.salt.RandomSaltGenerator"));
        config.setIvGeneratorClassName(DefaultLazyEncryptor.get(configProps::getIvGeneratorClassname, "jasypt.encryptor.iv-generator-classname", "org.jasypt.iv.RandomIvGenerator"));
        config.setStringOutputType(DefaultLazyEncryptor.get(configProps::getStringOutputType, "jasypt.encryptor.string-output-type", "base64"));
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    }

    private static boolean isAsymmetricConfig(JasyptEncryptorConfigurationProperties config) {
        return config.getPrivateKeyString() != null || config.getPrivateKeyLocation() != null;
    }

    private static boolean isPBEConfig(JasyptEncryptorConfigurationProperties config) {
        return config.getPassword() != null;
    }

    private static <T> T getRequired(Supplier<T> supplier, String key) {
        T value = supplier.get();
        if (value == null) {
            throw new IllegalStateException(String.format("Required Encryption configuration property missing: %s", key));
        }
        return value;
    }

    private static <T> T get(Supplier<T> supplier, String key, T defaultValue) {
        T value = supplier.get();
        if (value == defaultValue) {
            log.info("Encryptor config not found for property {}, using default value: {}", (Object)key, value);
        }
        return value;
    }

    public String encrypt(String message) {
        return this.singleton.get().encrypt(message);
    }

    public String decrypt(String encryptedMessage) {
        return this.singleton.get().decrypt(encryptedMessage);
    }
}

