/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.environment;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.encryptor.DefaultLazyEncryptor;
import com.ulisesbocchio.jasyptspringboot.resolver.DefaultPropertyResolver;
import java.util.Map;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.core.env.MutablePropertySources;

public class EncryptableEnvironment
implements ConfigurableEnvironment {
    private final ConfigurableEnvironment delegate;
    private final EncryptablePropertyResolver resolver;

    public EncryptableEnvironment(ConfigurableEnvironment delegate) {
        this(delegate, EncryptableEnvironment.discoverEncryptor(delegate));
    }

    public EncryptableEnvironment(ConfigurableEnvironment delegate, EncryptablePropertyDetector detector) {
        this(delegate, new DefaultPropertyResolver(EncryptableEnvironment.discoverEncryptor(delegate), detector));
    }

    public EncryptableEnvironment(ConfigurableEnvironment delegate, StringEncryptor encryptor) {
        this(delegate, new DefaultPropertyResolver(encryptor, new DefaultPropertyDetector()));
    }

    public EncryptableEnvironment(ConfigurableEnvironment delegate, StringEncryptor encryptor, EncryptablePropertyDetector detector) {
        this(delegate, new DefaultPropertyResolver(encryptor, detector));
    }

    public EncryptableEnvironment(ConfigurableEnvironment delegate, EncryptablePropertyResolver resolver) {
        this.delegate = delegate;
        this.resolver = resolver;
    }

    private static StringEncryptor discoverEncryptor(ConfigurableEnvironment delegate) {
        return new DefaultLazyEncryptor((Environment)delegate);
    }

    public void addActiveProfile(String profile) {
        this.delegate.addActiveProfile(profile);
    }

    public MutablePropertySources getPropertySources() {
        return this.delegate.getPropertySources();
    }

    public Map<String, Object> getSystemEnvironment() {
        return this.delegate.getSystemEnvironment();
    }

    public Map<String, Object> getSystemProperties() {
        return this.delegate.getSystemProperties();
    }

    public void merge(ConfigurableEnvironment parent) {
        this.delegate.merge(parent);
    }

    public ConfigurableConversionService getConversionService() {
        return this.delegate.getConversionService();
    }

    public void setConversionService(ConfigurableConversionService conversionService) {
        this.delegate.setConversionService(conversionService);
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.delegate.setPlaceholderPrefix(placeholderPrefix);
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.delegate.setPlaceholderSuffix(placeholderSuffix);
    }

    public void setValueSeparator(String valueSeparator) {
        this.delegate.setValueSeparator(valueSeparator);
    }

    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.delegate.setIgnoreUnresolvableNestedPlaceholders(ignoreUnresolvableNestedPlaceholders);
    }

    public void setRequiredProperties(String ... requiredProperties) {
        this.delegate.setRequiredProperties(requiredProperties);
    }

    public void validateRequiredProperties() throws MissingRequiredPropertiesException {
        this.delegate.validateRequiredProperties();
    }

    public String[] getActiveProfiles() {
        return this.delegate.getActiveProfiles();
    }

    public void setActiveProfiles(String ... profiles) {
        this.delegate.setActiveProfiles(profiles);
    }

    public String[] getDefaultProfiles() {
        return this.delegate.getDefaultProfiles();
    }

    public void setDefaultProfiles(String ... profiles) {
        this.delegate.setDefaultProfiles(profiles);
    }

    public boolean acceptsProfiles(String ... profiles) {
        return this.delegate.acceptsProfiles(profiles);
    }

    public boolean containsProperty(String key) {
        return this.delegate.containsProperty(key);
    }

    public String getProperty(String key) {
        return this.maybeDecrypt(this.delegate.getProperty(key));
    }

    private String maybeDecrypt(String property) {
        return this.resolver.resolvePropertyValue(property);
    }

    public String getProperty(String key, String defaultValue) {
        return this.maybeDecrypt(this.delegate.getProperty(key, defaultValue));
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        Object property = this.delegate.getProperty(key, targetType);
        if (property != null && targetType == String.class) {
            property = this.maybeDecrypt((String)property);
        }
        return (T)property;
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        Object property = this.delegate.getProperty(key, targetType, defaultValue);
        if (property != null && targetType == String.class) {
            property = this.maybeDecrypt((String)property);
        }
        return (T)property;
    }

    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetType) {
        return this.delegate.getPropertyAsClass(key, targetType);
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.maybeDecrypt(this.delegate.getRequiredProperty(key));
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        Object property = this.delegate.getRequiredProperty(key, targetType);
        if (property != null && targetType == String.class) {
            property = this.maybeDecrypt((String)property);
        }
        return (T)property;
    }

    public String resolvePlaceholders(String text) {
        return this.delegate.resolvePlaceholders(text);
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.delegate.resolveRequiredPlaceholders(text);
    }
}

