/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;

public class FileService {
    public static String read(Path path) throws MojoExecutionException {
        try {
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read file " + String.valueOf(path), (Exception)e);
        }
    }

    public static void write(Path path, String contents) throws MojoExecutionException {
        try {
            Files.write(path, contents.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write file " + String.valueOf(path), (Exception)e);
        }
    }

    public static void load(Path path, Properties properties) throws MojoExecutionException {
        try {
            properties.load(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to load file " + String.valueOf(path), (Exception)e);
        }
    }
}

