/*
 * Decompiled with CFR 0.152.
 */
package com.wei.android.lib.fingerprintidentify.impl;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.fingerprints.service.FingerprintManager;
import com.wei.android.lib.fingerprintidentify.base.BaseFingerprint;

public class MeiZuFingerprint
extends BaseFingerprint {
    private FingerprintManager mMeiZuFingerprintManager;

    public MeiZuFingerprint(Context context, BaseFingerprint.ExceptionListener exceptionListener) {
        super(context, exceptionListener);
        try {
            this.mMeiZuFingerprintManager = FingerprintManager.open();
            if (this.mMeiZuFingerprintManager != null) {
                this.setHardwareEnable(this.isMeiZuDevice(Build.MANUFACTURER));
                int[] fingerprintIds = this.mMeiZuFingerprintManager.getIds();
                this.setRegisteredFingerprint(fingerprintIds != null && fingerprintIds.length > 0);
            }
        }
        catch (Throwable e) {
            this.onCatchException(e);
        }
        this.releaseMBack();
    }

    @Override
    protected void doIdentify() {
        try {
            this.mMeiZuFingerprintManager = FingerprintManager.open();
            this.mMeiZuFingerprintManager.startIdentify(new FingerprintManager.IdentifyCallback(){

                public void onIdentified(int i, boolean b) {
                    MeiZuFingerprint.this.onSucceed();
                }

                public void onNoMatch() {
                    MeiZuFingerprint.this.onNotMatch();
                }
            }, this.mMeiZuFingerprintManager.getIds());
        }
        catch (Throwable e) {
            this.onCatchException(e);
            this.onFailed(false);
        }
    }

    @Override
    protected void doCancelIdentify() {
        this.releaseMBack();
    }

    private void releaseMBack() {
        try {
            if (this.mMeiZuFingerprintManager != null) {
                this.mMeiZuFingerprintManager.release();
            }
        }
        catch (Throwable e) {
            this.onCatchException(e);
        }
    }

    private boolean isMeiZuDevice(String manufacturer) {
        return !TextUtils.isEmpty((CharSequence)manufacturer) && manufacturer.toUpperCase().contains("MEIZU");
    }
}

