/*
 * Decompiled with CFR 0.152.
 */
package com.wei.android.lib.fingerprintidentify.impl;

import android.content.Context;
import android.os.Build;
import androidx.core.os.CancellationSignal;
import com.wei.android.lib.fingerprintidentify.aosp.FingerprintManagerCompat;
import com.wei.android.lib.fingerprintidentify.base.BaseFingerprint;

public class AndroidFingerprint
extends BaseFingerprint {
    private CancellationSignal mCancellationSignal;
    private FingerprintManagerCompat mFingerprintManagerCompat;

    public AndroidFingerprint(Context context, BaseFingerprint.ExceptionListener exceptionListener, boolean iSupportAndroidL) {
        super(context, exceptionListener);
        if (!iSupportAndroidL && Build.VERSION.SDK_INT < 23) {
            return;
        }
        try {
            this.mFingerprintManagerCompat = FingerprintManagerCompat.from(this.mContext);
            this.setHardwareEnable(this.mFingerprintManagerCompat.isHardwareDetected());
            this.setRegisteredFingerprint(this.mFingerprintManagerCompat.hasEnrolledFingerprints());
        }
        catch (Throwable e) {
            this.onCatchException(e);
        }
    }

    @Override
    protected void doIdentify() {
        try {
            this.mCancellationSignal = new CancellationSignal();
            this.mFingerprintManagerCompat.authenticate(null, 0, this.mCancellationSignal, new FingerprintManagerCompat.AuthenticationCallback(){

                @Override
                public void onAuthenticationSucceeded(FingerprintManagerCompat.AuthenticationResult result) {
                    super.onAuthenticationSucceeded(result);
                    AndroidFingerprint.this.onSucceed();
                }

                @Override
                public void onAuthenticationFailed() {
                    super.onAuthenticationFailed();
                    AndroidFingerprint.this.onNotMatch();
                }

                @Override
                public void onAuthenticationError(int errMsgId, CharSequence errString) {
                    super.onAuthenticationError(errMsgId, errString);
                    if (errMsgId == 5 || errMsgId == 10) {
                        return;
                    }
                    AndroidFingerprint.this.onFailed(errMsgId == 7 || errMsgId == 9);
                }
            }, null);
        }
        catch (Throwable e) {
            this.onCatchException(e);
            this.onFailed(false);
        }
    }

    @Override
    protected void doCancelIdentify() {
        try {
            if (this.mCancellationSignal != null) {
                this.mCancellationSignal.cancel();
            }
        }
        catch (Throwable e) {
            this.onCatchException(e);
        }
    }

    @Override
    protected boolean needToCallDoIdentifyAgainAfterNotMatch() {
        return false;
    }
}

