/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprints.service;

import android.graphics.Point;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.fingerprints.service.IFingerprintClient;
import com.fingerprints.service.IFingerprintService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class FingerprintManager {
    public static final int MSG_WAITING_FINGER = 1;
    public static final int MSG_FINGER_PRESENT = 2;
    public static final int MSG_FINGER_UP = 3;
    static final int MSG_ENROL_PROGRESS = 4;
    static final int MSG_ENROLMENT_DONE = 5;
    public static final int MSG_IDENTIFY_MATCH = 6;
    public static final int MSG_IDENTIFY_NO_MATCH = 7;
    static final int MSG_ENROLMENT_FAILED = 8;
    static final int MSG_ENROLMENT_TOUCHES_QUALITY = 9;
    static final int MSG_ENROLMENT_SEND_GUIDE_DATA = 10;
    static final int MSG_ENROLMENT_LAST_TOUCH = 11;
    static final int MSG_ENROLMENT_NEXT_TOUCH = 12;
    static final int MSG_ENROLMENT_MASK_LIST = 13;
    static final int MSG_ENROLMENT_DATA_IMAGE_QUALITY = 14;
    static final int MSG_ENROLMENT_DATA_IMMOBILE = 15;
    static final int MSG_ENROLMENT_DATA_NEXT_DIRECTION = 16;
    static final int MSG_ENROLMENT_DATA_PROGRESS = 17;
    static final int MSG_ENROLMENT_DATA_IMAGE_STITCHED = 18;
    public static final int MSG_CAPTURE_FAILED = 19;
    static final int MEG_FINGERDOWN_TIMEOUT = 26;
    static final int INTERNEL_FINGERDOWN_TIMEOUT = 3000;
    static final int ARG_IDENTIFY_UPDATED = 1;
    static final int FPC_GUIDE_DIRECTION_NA = 0;
    static final int FPC_GUIDE_DIRECTION_SW = 1;
    static final int FPC_GUIDE_DIRECTION_S = 2;
    static final int FPC_GUIDE_DIRECTION_SE = 3;
    static final int FPC_GUIDE_DIRECTION_NW = 4;
    static final int FPC_GUIDE_DIRECTION_N = 5;
    static final int FPC_GUIDE_DIRECTION_NE = 6;
    static final int FPC_GUIDE_DIRECTION_E = 7;
    static final int FPC_GUIDE_DIRECTION_W = 8;
    static final int FPC_GUIDE_DATA_INVALID = Integer.MIN_VALUE;
    public static final int CAPTURE_FAILED_TOO_FAST = 1;
    public static final int MSG_NOT_ENROLLED = 20;
    public static final int MEG_WAIT_FINGERDOWN_TIMEOUT = 21;
    public static final int MSG_NOT_ENABLED = 22;
    public static final int MSG_UNKNOWN = 23;
    public static final int MSG_USER_CANCEL = 24;
    public static final int MSG_SENSOR_ERROR = 25;
    HandlerThread mzHanderThread;
    private int mUserdata = Integer.MIN_VALUE;
    private static String TAG = "MzFingerManager";
    private boolean mReadyToStore = false;
    public static final int MSG_DELETE_RESULT = 30;
    public static final int DELETE_TEMPLATES_SUCCESS = 1;
    private IFingerprintService mService;
    private IFingerprintClient mClient;
    private EventHandler mEventhHandler;
    private CaptureCallback mCaptureCallback;
    private EnrolCallback mEnrolCallback;
    private IdentifyCallback mIdentifyCallback;
    private GuidedDataCallback mGuidedDataCallback;
    private static Bundle mBundle;
    private static Bundle mGuidedDataBundle;
    private DeleteTemplateCallback mDeleteTemplateCallback;
    private IdentifyListener mIdentifyListener;

    private void PackGuidedData() {
        int mGuidedProgress = mGuidedDataBundle.getInt("progress");
        int mGuidedNextDirection = mGuidedDataBundle.getInt("next_direction");
        int mGuidedAcceptance = mGuidedDataBundle.getInt("acceptance");
        boolean mGuidedStitched = mGuidedDataBundle.getInt("stitched") != 0;
        boolean mGuidedImmobile = mGuidedDataBundle.getInt("immobile") != 0;
        int reason = mGuidedDataBundle.getInt("reject_reason");
        int mGuidedNumberOfMask = mGuidedDataBundle.getInt("maskNumber");
        boolean mGuidedLowCoverage = false;
        boolean mGuidedLowQuality = false;
        switch (reason) {
            case 1: 
            case 17: {
                mGuidedLowQuality = true;
                break;
            }
            case 16: {
                mGuidedLowCoverage = true;
                break;
            }
        }
        GuidedRejectReasons mGuidedRejectReasons = new GuidedRejectReasons(mGuidedLowCoverage, mGuidedLowQuality);
        GuidedResult mGuidedResult = new GuidedResult(mGuidedAcceptance, mGuidedStitched, mGuidedImmobile, mGuidedRejectReasons);
        Point lastTouch_bottom_left = new Point(mGuidedDataBundle.getIntArray("lastTouch")[0], mGuidedDataBundle.getIntArray("lastTouch")[1]);
        Point lastTouch_bottom_right = new Point(mGuidedDataBundle.getIntArray("lastTouch")[2], mGuidedDataBundle.getIntArray("lastTouch")[3]);
        Point lastTouch_top_left = new Point(mGuidedDataBundle.getIntArray("lastTouch")[4], mGuidedDataBundle.getIntArray("lastTouch")[5]);
        Point lastTouch_top_right = new Point(mGuidedDataBundle.getIntArray("lastTouch")[6], mGuidedDataBundle.getIntArray("lastTouch")[7]);
        Point nextTouch_bottom_left = new Point(mGuidedDataBundle.getIntArray("nextTouch")[0], mGuidedDataBundle.getIntArray("nextTouch")[1]);
        Point nextTouch_bottom_right = new Point(mGuidedDataBundle.getIntArray("nextTouch")[2], mGuidedDataBundle.getIntArray("nextTouch")[3]);
        Point nextTouch_top_left = new Point(mGuidedDataBundle.getIntArray("nextTouch")[4], mGuidedDataBundle.getIntArray("nextTouch")[5]);
        Point nextTouch_top_right = new Point(mGuidedDataBundle.getIntArray("nextTouch")[6], mGuidedDataBundle.getIntArray("nextTouch")[7]);
        GuidedRect mGuidedLastTouch = new GuidedRect(lastTouch_bottom_left, lastTouch_bottom_right, lastTouch_top_left, lastTouch_top_right);
        GuidedRect mGuidedNextTouch = new GuidedRect(nextTouch_bottom_left, nextTouch_bottom_right, nextTouch_top_left, nextTouch_top_right);
        ArrayList<GuidedRect> guidedMaskList = new ArrayList<GuidedRect>();
        for (int i = 0; i < mGuidedNumberOfMask; ++i) {
            int bottomLeftX = mGuidedDataBundle.getIntArray("maskList")[i * 8 + 0];
            int bottomLeftY = mGuidedDataBundle.getIntArray("maskList")[i * 8 + 1];
            int bottomRightX = mGuidedDataBundle.getIntArray("maskList")[i * 8 + 2];
            int bottomRightY = mGuidedDataBundle.getIntArray("maskList")[i * 8 + 3];
            int topLeftX = mGuidedDataBundle.getIntArray("maskList")[i * 8 + 4];
            int topLeftY = mGuidedDataBundle.getIntArray("maskList")[i * 8 + 5];
            int topRightX = mGuidedDataBundle.getIntArray("maskList")[i * 8 + 6];
            int topRightY = mGuidedDataBundle.getIntArray("maskList")[i * 8 + 7];
            Point pointTopLeft = new Point(topLeftX, topLeftY);
            Point pointTopRight = new Point(topRightX, topRightY);
            Point pointBottomLeft = new Point(bottomLeftX, bottomLeftY);
            Point pointBottomRight = new Point(bottomRightX, bottomRightY);
            GuidedRect mask = new GuidedRect(pointBottomLeft, pointBottomRight, pointTopLeft, pointTopRight);
            guidedMaskList.add(mask);
        }
        GuidedMaskList mGuidedMaskList = new GuidedMaskList(guidedMaskList, mGuidedNumberOfMask);
        GuidedData mGuidedData = new GuidedData(mGuidedProgress, mGuidedNextDirection, mGuidedResult, mGuidedLastTouch, mGuidedNextTouch, mGuidedMaskList);
        this.mEnrolCallback.onProgress(mGuidedData);
    }

    public static FingerprintManager open() {
        try {
            Class<?> servicemanager = Class.forName("android.os.ServiceManager");
            Method getService = servicemanager.getMethod("getService", String.class);
            return new FingerprintManager((IBinder)getService.invoke(null, "fingerprints_service"), Looper.myLooper());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return null;
    }

    private FingerprintManager(IBinder service, Looper looper) throws RemoteException {
        this.mService = IFingerprintService.Stub.asInterface(service);
        if (looper == null) {
            Log.d((String)TAG, (String)" create--------HandlerThread  ");
            this.mzHanderThread = new HandlerThread("result_handler");
            this.mzHanderThread.start();
            looper = this.mzHanderThread.getLooper();
        }
        Log.e((String)TAG, (String)("get fp method time, mService = " + this.mService));
        EventHandler handler = new EventHandler(looper);
        mBundle = new Bundle();
        mGuidedDataBundle = new Bundle();
        this.mClient = new IFingerprintClient.Stub(){

            @Override
            public void onMessage(int what, int arg1, int arg2) throws RemoteException {
                Log.i((String)TAG, (String)(" onMessage--------what  " + what));
                FingerprintManager.this.mEventhHandler.sendMessage(FingerprintManager.this.mEventhHandler.obtainMessage(what, arg1, arg2));
            }

            @Override
            public void onBundleMessage2(int what, int arg1, int[] rect) throws RemoteException {
                Message mMessage = FingerprintManager.this.mEventhHandler.obtainMessage(what, arg1, 0);
                switch (what) {
                    case 11: {
                        mBundle.putIntArray("lastTouch", rect);
                        mMessage.setData(mBundle);
                        break;
                    }
                    case 12: {
                        mBundle.putIntArray("nextTouch", rect);
                        mMessage.setData(mBundle);
                        break;
                    }
                    case 13: {
                        mBundle.putIntArray("maskList", rect);
                        mBundle.putInt("maskNumber", arg1);
                        mMessage.setData(mBundle);
                    }
                }
                FingerprintManager.this.mEventhHandler.sendMessage(mMessage);
            }

            @Override
            public void onBundleMessage(int what, int arg1, int arg2, Bundle arr) throws RemoteException {
                Message mMessage = FingerprintManager.this.mEventhHandler.obtainMessage(what, arg1, arg2);
                mMessage.setData(arr);
                FingerprintManager.this.mEventhHandler.sendMessage(mMessage);
            }
        };
        if (this.mService == null || !this.mService.open(this.mClient)) {
            throw new RuntimeException();
        }
        this.mEventhHandler = handler;
    }

    public void setCaptureCallback(CaptureCallback captureCallback) {
        this.mCaptureCallback = captureCallback;
    }

    public void release() {
        Log.i((String)TAG, (String)" release--------              ");
        if (this.mzHanderThread != null) {
            Log.i((String)TAG, (String)" release--------  mzHanderThread");
            this.mzHanderThread.quit();
            this.mzHanderThread = null;
        }
        try {
            this.mService.release(this.mClient);
            if (this.mCaptureCallback != null) {
                this.mCaptureCallback = null;
            }
            if (this.mEnrolCallback != null && !this.mReadyToStore) {
                this.mEnrolCallback = null;
            }
            if (this.mIdentifyCallback != null) {
                this.mIdentifyCallback = null;
            }
            this.mIdentifyListener = null;
            this.mClient = null;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void startEnrol(EnrolCallback enrolCallback, int fingerId) {
        if (enrolCallback == null) {
            throw new NullPointerException();
        }
        this.mEnrolCallback = enrolCallback;
        try {
            this.mService.startGuidedEnrol(this.mClient, fingerId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int[] getIds() {
        try {
            Log.i((String)TAG, (String)"getIds      ");
            return this.mService.getIds(this.mClient);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void startIdentify(IdentifyCallback identifyCallback, int[] ids) {
        if (ids == null || identifyCallback == null) {
            return;
        }
        this.mIdentifyCallback = identifyCallback;
        try {
            this.mService.startIdentify(this.mClient, ids);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void startIdentify(IdentifyListener identifyListener, int[] ids, int timeout, int userdata) {
        if (ids == null || identifyListener == null) {
            throw new NullPointerException();
        }
        this.mIdentifyListener = identifyListener;
        this.mUserdata = userdata;
        Log.i((String)TAG, (String)(" startIdentify--------  " + ids[0]));
        if (timeout > 0) {
            this.mEventhHandler.sendMessageDelayed(this.mEventhHandler.obtainMessage(21, -1, userdata), timeout);
        }
        try {
            this.mService.startIdentify(this.mClient, ids);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void abort() {
        try {
            this.mService.cancel(this.mClient);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void deleteFingerData(DeleteTemplateCallback deleteTemplateCallback, int[] fingerIds) {
        if (deleteTemplateCallback == null) {
            return;
        }
        this.mDeleteTemplateCallback = deleteTemplateCallback;
        try {
            this.mService.removeData(this.mClient, fingerIds);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean updateTA(String taPath) {
        try {
            return this.mService.updateTA(taPath);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isFingerEnable() {
        try {
            return this.mService.isFingerEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isSurpport() {
        try {
            return this.mService.isSurpport();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void notifyScreenOn() {
        try {
            Log.i((String)TAG, (String)(" notifyScreenOn--------  " + Thread.currentThread().hashCode()));
            IBinder iBinder = ServiceManager.getService((String)"fingerprints_service");
            if (iBinder != null) {
                IFingerprintService mService = IFingerprintService.Stub.asInterface(iBinder);
                mService.notifyScreenOn();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void notifyScreenOff() {
        try {
            Log.i((String)TAG, (String)(" notifyScreenOff--------  " + Thread.currentThread().hashCode()));
            IBinder iBinder = ServiceManager.getService((String)"fingerprints_service");
            if (iBinder != null) {
                IFingerprintService mService = IFingerprintService.Stub.asInterface(iBinder);
                mService.notifyScreenOff();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void shouldRestartByScreenOn() {
        try {
            Log.i((String)TAG, (String)(" shouldRestartByScreenOn--------  " + Thread.currentThread().hashCode()));
            this.mService.shouldRestartByScreenOn(this.mClient);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            Log.i((String)TAG, (String)("Message     what  " + msg.what));
            switch (msg.what) {
                case 1: {
                    if (FingerprintManager.this.mCaptureCallback != null) {
                        FingerprintManager.this.mCaptureCallback.onWaitingForInput();
                    }
                    if (FingerprintManager.this.mIdentifyListener == null) break;
                    FingerprintManager.this.mIdentifyListener.onStatus(1, FingerprintManager.this.mUserdata);
                    break;
                }
                case 2: {
                    if (FingerprintManager.this.mCaptureCallback != null) {
                        FingerprintManager.this.mCaptureCallback.onInput();
                    }
                    if (FingerprintManager.this.mEnrolCallback != null) {
                        this.sendMessageDelayed(this.obtainMessage(26), 3000L);
                    }
                    if (FingerprintManager.this.mIdentifyListener == null) break;
                    FingerprintManager.this.mIdentifyListener.onStatus(2, FingerprintManager.this.mUserdata);
                    this.removeMessages(21);
                    break;
                }
                case 3: {
                    if (FingerprintManager.this.mCaptureCallback != null) {
                        FingerprintManager.this.mCaptureCallback.onCaptureCompleted();
                    }
                    if (FingerprintManager.this.mEnrolCallback != null) {
                        this.removeMessages(26);
                    }
                    if (FingerprintManager.this.mIdentifyListener == null) break;
                    FingerprintManager.this.mIdentifyListener.onStatus(3, FingerprintManager.this.mUserdata);
                    break;
                }
                case 19: {
                    if (FingerprintManager.this.mCaptureCallback != null) {
                        FingerprintManager.this.mCaptureCallback.onCaptureFailed(msg.arg1);
                    }
                    if (FingerprintManager.this.mIdentifyListener == null) break;
                    FingerprintManager.this.mIdentifyListener.onResult(19, msg.arg1, FingerprintManager.this.mUserdata);
                    break;
                }
                case 6: {
                    if (FingerprintManager.this.mIdentifyCallback != null) {
                        FingerprintManager.this.mIdentifyCallback.onIdentified(msg.arg1, msg.arg2 == 1);
                    }
                    if (FingerprintManager.this.mIdentifyListener == null) break;
                    FingerprintManager.this.mIdentifyListener.onResult(6, msg.arg1, FingerprintManager.this.mUserdata);
                    break;
                }
                case 5: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    FingerprintManager.this.mEnrolCallback.onEnrolled(msg.arg1);
                    if (!FingerprintManager.this.mReadyToStore) break;
                    FingerprintManager.this.mReadyToStore = false;
                    FingerprintManager.this.mEnrolCallback = null;
                    break;
                }
                case 4: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    break;
                }
                case 10: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    FingerprintManager.this.PackGuidedData();
                    break;
                }
                case 11: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    Bundle tmpBundle = msg.getData();
                    int[] tmpArray = tmpBundle.getIntArray("lastTouch");
                    mGuidedDataBundle.putIntArray("lastTouch", tmpArray);
                    break;
                }
                case 12: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    Bundle tmpBundle = msg.getData();
                    int[] tmpArray = tmpBundle.getIntArray("nextTouch");
                    mGuidedDataBundle.putIntArray("nextTouch", tmpArray);
                    break;
                }
                case 13: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    Bundle tmpBundle = msg.getData();
                    int[] tmpArray = tmpBundle.getIntArray("maskList");
                    mGuidedDataBundle.putIntArray("maskList", tmpArray);
                    mGuidedDataBundle.putInt("maskNumber", msg.arg1);
                    break;
                }
                case 14: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    mGuidedDataBundle.putInt("acceptance", msg.arg1);
                    mGuidedDataBundle.putInt("reject_reason", msg.arg2);
                    break;
                }
                case 18: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    mGuidedDataBundle.putInt("stitched", msg.arg1);
                    break;
                }
                case 15: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    mGuidedDataBundle.putInt("immobile", msg.arg1);
                    break;
                }
                case 16: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    mGuidedDataBundle.putInt("next_direction", msg.arg1);
                    break;
                }
                case 17: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    mGuidedDataBundle.putInt("progress", msg.arg1);
                    if (msg.arg1 != 100) break;
                    FingerprintManager.this.mReadyToStore = true;
                    break;
                }
                case 7: {
                    if (FingerprintManager.this.mIdentifyCallback != null) {
                        FingerprintManager.this.mIdentifyCallback.onNoMatch();
                    }
                    if (FingerprintManager.this.mIdentifyListener == null) break;
                    FingerprintManager.this.mIdentifyListener.onResult(7, msg.arg1, FingerprintManager.this.mUserdata);
                    break;
                }
                case 8: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    FingerprintManager.this.mEnrolCallback.onEnrollmentFailed();
                    break;
                }
                case 26: {
                    if (FingerprintManager.this.mEnrolCallback == null) break;
                    FingerprintManager.this.mEnrolCallback.onFingerDownTimeOut();
                    break;
                }
                case 24: {
                    if (FingerprintManager.this.mIdentifyListener == null) break;
                    FingerprintManager.this.mIdentifyListener.onResult(24, msg.arg1, FingerprintManager.this.mUserdata);
                    break;
                }
                case 21: {
                    if (FingerprintManager.this.mIdentifyListener == null) break;
                    FingerprintManager.this.mIdentifyListener.onResult(21, msg.arg1, FingerprintManager.this.mUserdata);
                    break;
                }
                case 30: {
                    if (FingerprintManager.this.mDeleteTemplateCallback == null) break;
                    Log.d((String)TAG, (String)(" MSG_DELETE_RESULT    msg.arg1:  " + msg.arg1));
                    FingerprintManager.this.mDeleteTemplateCallback.onDeleteResult(msg.arg1 == 1);
                }
            }
        }
    }

    public static interface DeleteTemplateCallback {
        public void onDeleteResult(boolean var1);
    }

    public static interface AlipayIdentifyCallback
    extends IdentifyCallback {
        public void onCancel();
    }

    public static interface IdentifyCallback {
        public void onIdentified(int var1, boolean var2);

        public void onNoMatch();
    }

    public static interface EnrolCallback {
        public void onProgress(GuidedData var1);

        public void onEnrolled(int var1);

        public void onEnrollmentFailed();

        public void onFingerDownTimeOut();
    }

    public class GuidedRect {
        public Point guidedBottomLeft;
        public Point guidedBottomRight;
        public Point guidedTopLeft;
        public Point guidedTopRight;

        public GuidedRect(Point guidedBottomLeft, Point guidedBottomRight, Point guidedTopLeft, Point guidedTopRight) {
            this.guidedBottomLeft = guidedBottomLeft;
            this.guidedBottomRight = guidedBottomRight;
            this.guidedTopLeft = guidedTopLeft;
            this.guidedTopRight = guidedTopRight;
        }
    }

    public class GuidedRejectReasons {
        public boolean guidedLowCoverage;
        public boolean guidedLowQuality;

        public GuidedRejectReasons(boolean guidedLowCoverage, boolean guidedLowQuality) {
            this.guidedLowCoverage = guidedLowCoverage;
            this.guidedLowQuality = guidedLowQuality;
        }
    }

    public class GuidedResult {
        public int guidedAcceptance;
        public boolean guidedStitched;
        public boolean guidedImmobile;
        public GuidedRejectReasons guidedRejectReasons;

        public GuidedResult(int guidedAcceptance, boolean guidedStitched, boolean guidedImmobile, GuidedRejectReasons guidedRejectReasons) {
            this.guidedAcceptance = guidedAcceptance;
            this.guidedStitched = guidedStitched;
            this.guidedImmobile = guidedImmobile;
            this.guidedRejectReasons = guidedRejectReasons;
        }
    }

    public class GuidedMaskList {
        public ArrayList<GuidedRect> guidedMaskList;
        public int guidedNumberOfMask;

        public GuidedMaskList(ArrayList<GuidedRect> guidedMaskList, int guidedNumberOfMask) {
            this.guidedMaskList = guidedMaskList;
            this.guidedNumberOfMask = guidedNumberOfMask;
        }
    }

    public class GuidedData {
        public GuidedRect guidedLastTouch;
        public GuidedRect guidedNextTouch;
        public GuidedMaskList guidedMaskList;
        public GuidedResult guidedResult;
        public int guidedProgress;
        public int guidedNextDirection;

        public GuidedData(int guidedProgress, int guidedNextDirection, GuidedResult guidedResult, GuidedRect guidedLastTouch, GuidedRect guidedNextTouch, GuidedMaskList guidedMaskList) {
            this.guidedProgress = guidedProgress;
            this.guidedNextDirection = guidedNextDirection;
            this.guidedResult = guidedResult;
            this.guidedLastTouch = guidedLastTouch;
            this.guidedNextTouch = guidedNextTouch;
            this.guidedMaskList = guidedMaskList;
        }
    }

    public static interface GuidedDataCallback {
        public void onLastTouch(int[] var1);

        public void onNextTouch(int[] var1);

        public void onMaskList(int var1, int[] var2);

        public void onImageQuality(int var1, int var2);

        public void onImageStitched(int var1);

        public void onImmobile(int var1);

        public void onNextDirection(int var1);

        public void onProgressPercentage(int var1);

        public void onSendGuideData();
    }

    public static interface CaptureCallback {
        public void onWaitingForInput();

        public void onInput();

        public void onCaptureCompleted();

        public void onCaptureFailed(int var1);
    }

    public static interface IdentifyListener {
        public void onStatus(int var1, int var2);

        public void onResult(int var1, int var2, int var3);
    }
}

