/*
 * Decompiled with CFR 0.152.
 */
package com.wei.android.lib.fingerprintidentify;

import android.content.Context;
import com.wei.android.lib.fingerprintidentify.base.BaseFingerprint;
import com.wei.android.lib.fingerprintidentify.impl.AndroidFingerprint;
import com.wei.android.lib.fingerprintidentify.impl.MeiZuFingerprint;
import com.wei.android.lib.fingerprintidentify.impl.SamsungFingerprint;

public class FingerprintIdentify {
    protected Context mContext;
    protected BaseFingerprint.ExceptionListener mExceptionListener;
    protected boolean mIsSupportAndroidL = false;
    protected BaseFingerprint mFingerprint;
    protected BaseFingerprint mSubFingerprint;

    public FingerprintIdentify(Context context) {
        this.mContext = context;
    }

    public void setSupportAndroidL(boolean supportAndroidL) {
        this.mIsSupportAndroidL = supportAndroidL;
    }

    public void setExceptionListener(BaseFingerprint.ExceptionListener exceptionListener) {
        this.mExceptionListener = exceptionListener;
    }

    public void init() {
        MeiZuFingerprint meiZuFingerprint;
        SamsungFingerprint samsungFingerprint;
        AndroidFingerprint androidFingerprint = new AndroidFingerprint(this.mContext, this.mExceptionListener, this.mIsSupportAndroidL);
        if (androidFingerprint.isHardwareEnable()) {
            this.mSubFingerprint = androidFingerprint;
            if (androidFingerprint.isRegisteredFingerprint()) {
                this.mFingerprint = androidFingerprint;
                return;
            }
        }
        if ((samsungFingerprint = new SamsungFingerprint(this.mContext, this.mExceptionListener)).isHardwareEnable()) {
            this.mSubFingerprint = samsungFingerprint;
            if (samsungFingerprint.isRegisteredFingerprint()) {
                this.mFingerprint = samsungFingerprint;
                return;
            }
        }
        if ((meiZuFingerprint = new MeiZuFingerprint(this.mContext, this.mExceptionListener)).isHardwareEnable()) {
            this.mSubFingerprint = meiZuFingerprint;
            if (meiZuFingerprint.isRegisteredFingerprint()) {
                this.mFingerprint = meiZuFingerprint;
            }
        }
    }

    public void startIdentify(int maxAvailableTimes, BaseFingerprint.IdentifyListener listener) {
        if (!this.isFingerprintEnable()) {
            return;
        }
        this.mFingerprint.startIdentify(maxAvailableTimes, listener);
    }

    public void cancelIdentify() {
        if (this.mFingerprint != null) {
            this.mFingerprint.cancelIdentify();
        }
    }

    public void resumeIdentify() {
        if (!this.isFingerprintEnable()) {
            return;
        }
        this.mFingerprint.resumeIdentify();
    }

    public boolean isFingerprintEnable() {
        return this.mFingerprint != null && this.mFingerprint.isEnable();
    }

    public boolean isHardwareEnable() {
        return this.isFingerprintEnable() || this.mSubFingerprint != null && this.mSubFingerprint.isHardwareEnable();
    }

    public boolean isRegisteredFingerprint() {
        return this.isFingerprintEnable() || this.mSubFingerprint != null && this.mSubFingerprint.isRegisteredFingerprint();
    }
}

