/*
 * Decompiled with CFR 0.152.
 */
package com.tzutalin.dlib;

import android.graphics.Bitmap;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.tzutalin.dlib.VisionDetRet;
import java.util.Arrays;
import java.util.List;

public class FaceDet {
    private static final String TAG = "dlib";
    private long mNativeFaceDetContext;
    private String mLandMarkPath = "";

    public FaceDet() {
        this.jniInit(this.mLandMarkPath);
    }

    public FaceDet(String landMarkPath) {
        this.mLandMarkPath = landMarkPath;
        this.jniInit(this.mLandMarkPath);
    }

    @Nullable
    @WorkerThread
    public List<VisionDetRet> detect(@NonNull String path) {
        VisionDetRet[] detRets = this.jniDetect(path);
        return Arrays.asList(detRets);
    }

    @Nullable
    @WorkerThread
    public List<VisionDetRet> detect(@NonNull Bitmap bitmap) {
        VisionDetRet[] detRets = this.jniBitmapDetect(bitmap);
        return Arrays.asList(detRets);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public void release() {
        this.jniDeInit();
    }

    @Keep
    private static native void jniNativeClassInit();

    @Keep
    private synchronized native int jniInit(String var1);

    @Keep
    private synchronized native int jniDeInit();

    @Keep
    private synchronized native VisionDetRet[] jniBitmapDetect(Bitmap var1);

    @Keep
    private synchronized native VisionDetRet[] jniDetect(String var1);

    static {
        try {
            System.loadLibrary("android_dlib");
            FaceDet.jniNativeClassInit();
            Log.d((String)TAG, (String)"jniNativeClassInit success");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"library not found");
        }
    }
}

