/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import com.tylersuehr.esr.AbstractStateDisplay;
import com.tylersuehr.esr.EmptyStateRecyclerView;

public class ImageTextStateDisplay
extends AbstractStateDisplay {
    private final int sixteenDp;
    private boolean configured = false;
    private final TextPaint titlePaint = new TextPaint(1);
    private StaticLayout titleLayout;
    private String title;
    private final TextPaint subtitlePaint = new TextPaint(1);
    private StaticLayout subtitleLayout;
    private String subtitle;
    private Bitmap image;
    private int titleSpacing;
    private int textImageSpacing;
    private boolean drawTextFirst = false;

    public ImageTextStateDisplay(Context c, @DrawableRes int res) {
        this(c, res, "", "");
    }

    public ImageTextStateDisplay(Context c, @DrawableRes int res, @NonNull String title, @Nullable String subtitle) {
        this(c, BitmapFactory.decodeResource((Resources)c.getResources(), (int)res), title, subtitle);
    }

    public ImageTextStateDisplay(Context c, @NonNull Bitmap bitmap, @NonNull String title, @Nullable String subtitle) {
        DisplayMetrics dm = c.getResources().getDisplayMetrics();
        this.sixteenDp = (int)(16.0f * dm.density);
        this.setPadding(this.sixteenDp, this.sixteenDp, this.sixteenDp, this.sixteenDp);
        this.titleSpacing = (int)(4.0f * dm.scaledDensity);
        this.textImageSpacing = this.sixteenDp;
        this.titlePaint.setTextAlign(Paint.Align.CENTER);
        this.titlePaint.setTextSize(18.0f * dm.scaledDensity);
        this.titlePaint.setColor(-16777216);
        this.title = title;
        this.titleLayout = new StaticLayout((CharSequence)title, this.titlePaint, (int)this.titlePaint.measureText(title), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        this.subtitlePaint.setTextSize(14.0f * dm.scaledDensity);
        this.subtitlePaint.setTextAlign(Paint.Align.CENTER);
        this.subtitlePaint.setColor(-7829368);
        this.subtitle = subtitle == null ? "Dank yo hommie future is a rapper sdlkfjsldjfslkdjfsldjfasdjfasljdfasjdflasjdflsajd" : subtitle;
        this.subtitleLayout = new StaticLayout((CharSequence)this.subtitle, this.subtitlePaint, (int)this.subtitlePaint.measureText(this.subtitle), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        this.image = bitmap;
    }

    @Override
    public void onDrawState(EmptyStateRecyclerView rv, Canvas canvas) {
        if (this.drawTextFirst) {
            this.drawTextFirst(rv, canvas);
        } else {
            this.drawImageFirst(rv, canvas);
        }
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.invalidateConfig();
    }

    public void setTitleSpacing(int spacing) {
        this.titleSpacing = spacing;
    }

    public void setTitleTextColor(@ColorInt int color) {
        this.titlePaint.setColor(color);
        this.invalidateConfig();
    }

    public void setTitleTextSize(float textSize) {
        this.titlePaint.setTextSize(textSize);
        this.invalidateConfig();
    }

    public void setTitleTextAlign(Paint.Align align) {
        this.titlePaint.setTextAlign(align);
        this.invalidateConfig();
    }

    public void setTitle(String title) {
        this.title = title;
        this.invalidateConfig();
    }

    public void setSubtitleTextColor(@ColorInt int color) {
        this.subtitlePaint.setColor(color);
        this.invalidateConfig();
    }

    public void setSubtitleTextSize(float textSize) {
        this.subtitlePaint.setTextSize(textSize);
        this.invalidateConfig();
    }

    public void setSubtitleTextAlign(Paint.Align align) {
        this.subtitlePaint.setTextAlign(align);
        this.invalidateConfig();
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        this.invalidateConfig();
    }

    public void setTypeface(Typeface typeface) {
        this.titlePaint.setTypeface(typeface);
        this.subtitlePaint.setTypeface(typeface);
        this.invalidateConfig();
    }

    public void setImage(Bitmap bitmap) {
        this.image = bitmap;
        this.invalidateConfig();
    }

    public void setImage(Context c, @DrawableRes int res) {
        this.image = BitmapFactory.decodeResource((Resources)c.getResources(), (int)res);
        this.invalidateConfig();
    }

    public void setTextImageSpacing(int spacing) {
        this.textImageSpacing = spacing;
        this.invalidateConfig();
    }

    public void setDrawTextFirst(boolean value) {
        this.drawTextFirst = value;
    }

    private void drawImageFirst(EmptyStateRecyclerView rv, Canvas canvas) {
        int width = rv.getMeasuredWidth();
        int height = rv.getMeasuredHeight();
        this.configure(width);
        float dy = (height >> 1) - (this.image.getHeight() + this.sixteenDp + (int)this.getFullTextHeight() >> 1);
        canvas.drawBitmap(this.image, (float)((width >> 1) - (this.image.getWidth() >> 1)), dy, null);
        canvas.save();
        canvas.translate((float)(width >> 1), dy += (float)(this.image.getHeight() + this.textImageSpacing));
        this.titleLayout.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.translate((float)(width >> 1), dy += (float)(this.titleLayout.getHeight() + this.titleSpacing));
        this.subtitleLayout.draw(canvas);
        canvas.restore();
    }

    private void drawTextFirst(EmptyStateRecyclerView rv, Canvas canvas) {
        int width = rv.getMeasuredWidth();
        int height = rv.getMeasuredHeight();
        this.configure(width);
        float dy = (height >> 1) - (this.image.getHeight() + this.sixteenDp + (int)this.getFullTextHeight() >> 1);
        canvas.save();
        canvas.translate((float)(width >> 1), dy);
        this.titleLayout.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.translate((float)(width >> 1), dy += (float)(this.titleLayout.getHeight() + this.titleSpacing));
        this.subtitleLayout.draw(canvas);
        canvas.restore();
        canvas.drawBitmap(this.image, (float)((width >> 1) - (this.image.getWidth() >> 1)), dy += (float)(this.subtitleLayout.getHeight() + this.textImageSpacing), null);
    }

    private void invalidateConfig() {
        this.configured = false;
    }

    private float getFullTextHeight() {
        return this.titleLayout.getHeight() + this.subtitleLayout.getHeight() + this.titleSpacing + this.getPaddingTop() + this.getPaddingBottom();
    }

    private void configure(int availableWidth) {
        if (!this.configured) {
            int totalNeededPadding = this.getPaddingLeft() + this.getPaddingRight();
            if (this.titleLayout.getWidth() + totalNeededPadding > availableWidth) {
                this.titleLayout = new StaticLayout((CharSequence)this.title, this.titlePaint, availableWidth, Layout.Alignment.ALIGN_NORMAL, 1.15f, 0.0f, false);
            }
            if (this.subtitleLayout.getWidth() + totalNeededPadding > availableWidth) {
                this.subtitleLayout = new StaticLayout((CharSequence)this.subtitle, this.subtitlePaint, availableWidth, Layout.Alignment.ALIGN_NORMAL, 1.15f, 0.0f, false);
            }
            int newImageSize = (availableWidth + this.getPaddingLeft() + this.getPaddingRight()) / 3;
            this.image = Bitmap.createScaledBitmap((Bitmap)this.image, (int)newImageSize, (int)newImageSize, (boolean)false);
            this.configured = true;
        }
    }
}

