/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import com.tylersuehr.esr.EmptyStateRecyclerView;

public class DefaultLoadingState
implements EmptyStateRecyclerView.StateDisplay {
    private final Paint textPaint = new Paint(1);
    private final String title;
    private ValueAnimator anim;

    public DefaultLoadingState(@NonNull Context c, @NonNull String title) {
        this.title = title;
        this.textPaint.setColor(Color.parseColor((String)"#212121"));
        this.textPaint.setTextSize(21.0f * c.getResources().getDisplayMetrics().scaledDensity);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
    }

    @Override
    public void onDrawState(final EmptyStateRecyclerView rv, Canvas canvas) {
        canvas.drawText(this.title, (float)(rv.getMeasuredWidth() >> 1), (float)(rv.getMeasuredHeight() >> 1), this.textPaint);
        if (this.anim == null) {
            this.anim = ObjectAnimator.ofObject((Object)this.textPaint, (String)"color", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{Color.parseColor((String)"#E0E0E0"), Color.parseColor((String)"#BDBDBD"), Color.parseColor((String)"#9E9E9E")});
            this.anim.setDuration(900L);
            this.anim.setRepeatMode(2);
            this.anim.setRepeatCount(-1);
            this.anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    rv.invalidate();
                }
            });
            this.anim.start();
        }
    }
}

