/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.esr;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import com.tylersuehr.esr.EmptyStateRecyclerView;

public class DefaultEmptyState
implements EmptyStateRecyclerView.StateDisplay {
    private final TextPaint titlePaint = new TextPaint(1);
    private final TextPaint subtitlePaint = new TextPaint(1);
    private final String title;
    private final String subtitle;
    private final int spacing;

    public DefaultEmptyState(@NonNull Context c, @NonNull String title, @Nullable String subtitle) {
        this.title = title;
        this.subtitle = subtitle;
        DisplayMetrics dm = c.getResources().getDisplayMetrics();
        this.spacing = (int)(4.0f * dm.density);
        this.titlePaint.setColor(Color.parseColor((String)"#212121"));
        this.titlePaint.setTextSize(21.0f * dm.scaledDensity);
        this.titlePaint.setTextAlign(Paint.Align.CENTER);
        this.subtitlePaint.setColor(Color.parseColor((String)"#757575"));
        this.subtitlePaint.setTextSize(16.0f * dm.scaledDensity);
        this.subtitlePaint.setTextAlign(Paint.Align.CENTER);
    }

    @Override
    public void onDrawState(EmptyStateRecyclerView rv, Canvas canvas) {
        int width = rv.getMeasuredWidth();
        int height = rv.getMeasuredHeight();
        float dx = width >> 1;
        float dy = height >> 1;
        canvas.drawText(this.title, dx, dy, (Paint)this.titlePaint);
        if (this.subtitle != null) {
            canvas.drawText(this.subtitle, dx, dy -= this.titlePaint.getTextSize() + (float)this.spacing, (Paint)this.subtitlePaint);
        }
    }
}

