/*
 * Decompiled with CFR 0.152.
 */
package com.tylersuehr.bubbles;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.tylersuehr.bubbles.R;

public class CircleImageView
extends AppCompatImageView {
    private final Paint borderPaint = new Paint(1);
    private final Paint mainPaint = new Paint(1);
    private final Rect circleRect = new Rect();
    private int borderWidth;
    private int borderColor;
    private int backColor;
    private int circleRadius;
    private int viewSize;

    public CircleImageView(Context context) {
        this(context, null);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleImageView(Context c, AttributeSet attrs, int defStyleAttr) {
        super(c, attrs, defStyleAttr);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.CircleImageView);
        this.borderWidth = a.getDimensionPixelSize(R.styleable.CircleImageView_borderWidth, (int)(1.0f * dm.density));
        this.borderColor = a.getColor(R.styleable.CircleImageView_borderColor, ContextCompat.getColor((Context)c, (int)R.color.default_circle_border_color));
        this.backColor = a.getColor(R.styleable.CircleImageView_circleColor, ContextCompat.getColor((Context)c, (int)R.color.default_circle_text_color));
        a.recycle();
        this.borderPaint.setStyle(Paint.Style.FILL);
        this.borderPaint.setColor(this.borderColor);
        this.mainPaint.setColor(ContextCompat.getColor((Context)c, (int)R.color.default_circle_text_color));
        this.mainPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(width, width);
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable;
        Bitmap bitmap;
        if (this.isInEditMode()) {
            super.onDraw(canvas);
            return;
        }
        int viewWidth = this.getMeasuredWidth();
        int viewHeight = this.getMeasuredHeight();
        this.viewSize = Math.min(viewWidth, viewHeight);
        this.circleRadius = (this.viewSize - this.borderWidth * 2) / 2;
        this.circleRect.set(0, 0, this.viewSize, this.viewSize);
        if (this.viewSize == 0) {
            return;
        }
        if (this.viewSize / 3 < this.borderWidth) {
            this.borderWidth = this.viewSize / 3;
        }
        if ((bitmap = this.cutIntoCircle(this.drawableToBitmap(drawable = this.getDrawable()))) == null) {
            return;
        }
        this.borderPaint.setColor(this.borderColor);
        int radius = this.circleRadius + this.borderWidth;
        canvas.drawCircle((float)radius, (float)radius, (float)radius, this.borderPaint);
        this.borderPaint.setColor(this.backColor);
        canvas.drawCircle((float)radius, (float)radius, (float)this.circleRadius, this.borderPaint);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public void setBorderColor(@ColorInt int color2) {
        this.borderColor = color2;
        this.borderPaint.setColor(color2);
        this.invalidate();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderBackColor(@ColorInt int color2) {
        this.backColor = color2;
        this.borderPaint.setColor(color2);
        this.invalidate();
    }

    public int getBackColor() {
        return this.backColor;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
        this.borderPaint.setStrokeWidth((float)this.borderWidth);
        this.invalidate();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    private Bitmap cutIntoCircle(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap output = Bitmap.createBitmap((int)this.viewSize, (int)this.viewSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int radius = this.circleRadius + this.borderWidth;
        Canvas canvas = new Canvas(output);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)radius, (float)radius, (float)this.circleRadius, this.borderPaint);
        canvas.drawBitmap(bitmap, this.circleRect, this.circleRect, this.mainPaint);
        return output;
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.viewSize, (int)this.viewSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, this.viewSize, this.viewSize);
        drawable.draw(canvas);
        return bitmap;
    }
}

