/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Map;

public class ScalaPrimitiveTypeMapSerializer
implements ObjectSerializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaPrimitiveTypeMapSerializer.class.getName());
    private final BeakerObjectConverter parent;

    public ScalaPrimitiveTypeMapSerializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(Object obj, boolean expand) {
        if (!expand) {
            return false;
        }
        if (!(obj instanceof scala.collection.immutable.Map)) {
            return false;
        }
        java.util.Map m = JavaConversions.mapAsJavaMap((Map)((Map)obj));
        Set keys = m.keySet();
        for (Object key : keys) {
            if (key != null && !this.parent.isPrimitiveType(key.getClass().getName())) {
                return false;
            }
            Object val = m.get(key);
            if (val == null || this.parent.isPrimitiveType(val.getClass().getName())) continue;
            return false;
        }
        return true;
    }

    public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
        logger.debug("primitive type map");
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("Key");
        columns.add("Value");
        ArrayList values = new ArrayList();
        java.util.Map m = JavaConversions.mapAsJavaMap((Map)((Map)obj));
        Set keys = m.keySet();
        for (Object key : keys) {
            Object val = m.get(key);
            ArrayList<String> l = new ArrayList<String>();
            l.add(key.toString());
            l.add((String)val);
            values.add(l);
        }
        jgen.writeStartObject();
        jgen.writeObjectField("type", (Object)"TableDisplay");
        jgen.writeObjectField("columnNames", columns);
        jgen.writeObjectField("values", values);
        jgen.writeObjectField("subtype", (Object)"Dictionary");
        jgen.writeEndObject();
        return true;
    }
}

