/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.groovy.evaluator.GroovyNotFoundException;
import com.twosigma.beakerx.jvm.classloader.DynamicClassLoaderSimple;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyClassLoaderFactory {
    public static String GROOVY_JAR_PATH = "GROOVY_JAR_PATH";
    private static final String STATIC_WORD_WITH_SPACE = "static ";
    private static final String DOT_STAR_POSTFIX = ".*";

    public static GroovyClassLoader newEvaluator(Imports imports, Classpath classpath, String outDir) throws MalformedURLException {
        try {
            Class.forName("org.codehaus.groovy.control.customizers.ImportCustomizer");
        }
        catch (ClassNotFoundException e1) {
            String gjp = System.getenv(GROOVY_JAR_PATH);
            String errorMsg = null;
            errorMsg = gjp != null && !gjp.isEmpty() ? "Groovy libary not found, GROOVY_JAR_PATH = " + gjp : "Default groovy libary not found. No GROOVY_JAR_PATH variable set.";
            throw new GroovyNotFoundException(errorMsg);
        }
        ImportCustomizer icz = new ImportCustomizer();
        if (!imports.isEmpty()) {
            for (ImportPath importLine : imports.getImportPaths()) {
                if (importLine.asString().startsWith(STATIC_WORD_WITH_SPACE)) {
                    String pureImport = importLine.asString().replace(STATIC_WORD_WITH_SPACE, "").replace(DOT_STAR_POSTFIX, "");
                    if (importLine.asString().endsWith(DOT_STAR_POSTFIX)) {
                        icz.addStaticStars(new String[]{pureImport});
                        continue;
                    }
                    int index = pureImport.lastIndexOf(46);
                    if (index == -1) continue;
                    icz.addStaticImport(pureImport.substring(0, index), pureImport.substring(index + 1));
                    continue;
                }
                if (importLine.asString().endsWith(DOT_STAR_POSTFIX)) {
                    icz.addStarImports(new String[]{importLine.asString().replace(DOT_STAR_POSTFIX, "")});
                    continue;
                }
                icz.addImports(new String[]{importLine.asString()});
            }
        }
        CompilerConfiguration config = new CompilerConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{icz});
        String acloader_cp = "";
        for (int i = 0; i < classpath.size(); ++i) {
            acloader_cp = acloader_cp + classpath.get(i);
            acloader_cp = acloader_cp + File.pathSeparatorChar;
        }
        acloader_cp = acloader_cp + outDir;
        config.setClasspath(acloader_cp);
        return new GroovyClassLoader(GroovyClassLoaderFactory.newClassLoader(classpath, outDir), config);
    }

    protected static ClassLoader newClassLoader(Classpath classpath, String outDir) throws MalformedURLException {
        DynamicClassLoaderSimple loader = new DynamicClassLoaderSimple(ClassLoader.getSystemClassLoader());
        loader.addJars(classpath.getPathsAsStrings());
        loader.addDynamicDir(outDir);
        return loader;
    }
}

