/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.evaluator;

import clojure.lang.Compiler;
import clojure.lang.DynamicClassLoader;
import clojure.lang.RT;
import clojure.lang.Var;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.clojure.autocomplete.ClojureAutocomplete;
import com.twosigma.beakerx.clojure.evaluator.ClojureClassLoaderFactory;
import com.twosigma.beakerx.clojure.evaluator.ClojureWorkerThread;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.ImportPath;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClojureEvaluator
extends BaseEvaluator {
    public static final String beaker_clojure_ns = "beaker_clojure_shell";
    private static final Logger logger = LoggerFactory.getLogger((String)ClojureEvaluator.class.getName());
    private List<String> requirements = new ArrayList<String>();
    private ClojureWorkerThread workerThread;
    private DynamicClassLoader loader;
    private Var clojureLoadString = null;

    public ClojureEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory) {
        super(id, sId, cellExecutor, tempFolderFactory);
        this.init();
        this.workerThread = new ClojureWorkerThread(this);
        this.workerThread.start();
    }

    public ClojureEvaluator(String id, String sId) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("clojure"), (TempFolderFactory)new TempFolderFactoryImpl());
    }

    public void resetEnvironment() {
        this.killClojureThreads();
        super.resetEnvironment();
    }

    private void killClojureThreads() {
        this.runCode("(import 'clojure.lang.Agent)\n(.shutdownNow Agent/soloExecutor)\n(import 'java.util.concurrent.Executors) \n(set! Agent/soloExecutor (Executors/newCachedThreadPool))");
    }

    protected void doResetEnvironment() {
        this.loader = ClojureClassLoaderFactory.newInstance(this.classPath, this.outDir);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.loader);
        for (ImportPath importPath : this.imports.getImportPaths()) {
            String ss = importPath.asString();
            if (ss.isEmpty()) continue;
            try {
                this.loader.loadClass(ss);
                this.clojureLoadString.invoke((Object)String.format("(import '%s)", ss));
            }
            catch (ClassNotFoundException e) {
                logger.error("Could not find class while loading notebook: " + ss);
            }
        }
        for (String string : this.requirements) {
            if (string == null || string.isEmpty()) continue;
            try {
                this.clojureLoadString.invoke((Object)String.format("(require '%s)", string));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        Thread.currentThread().setContextClassLoader(oldLoader);
        this.workerThread.halt();
    }

    public void exit() {
        super.exit();
        this.workerThread.doExit();
        this.cancelExecution();
        this.workerThread.halt();
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        this.workerThread.add(new JobDescriptor(code, seo));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return ClojureAutocomplete.autocomplete(code, caretPosition, this.clojureLoadString, this.shellId);
    }

    Object runCode(String theCode) {
        return this.clojureLoadString.invoke((Object)theCode);
    }

    private void init() {
        this.loader = ClojureClassLoaderFactory.newInstance(this.classPath, this.outDir);
        String loadFunctionPrefix = "run_str";
        try {
            String clojureInitScript = String.format(this.initScriptSource(), beaker_clojure_ns, this.shellId, loadFunctionPrefix);
            this.clojureLoadString = RT.var((String)String.format("%1$s_%2$s", beaker_clojure_ns, this.shellId), (String)String.format("%1$s_%2$s", loadFunctionPrefix, this.shellId));
            Compiler.load((Reader)new StringReader(clojureInitScript));
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    private String initScriptSource() throws IOException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("init_clojure_script.txt");
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    DynamicClassLoader getLoader() {
        return this.loader;
    }
}

