/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.histogram;

import com.twosigma.beakerx.chart.AbstractChart;
import com.twosigma.beakerx.chart.ChartToJson;
import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.ListColorConverter;
import java.util.List;

public class Histogram
extends AbstractChart {
    private Integer rangeMin;
    private Integer rangeMax;
    private int binCount;
    private boolean rightClose;
    private boolean cumulative;
    private boolean normed;
    protected Color baseColor;
    private List<Color> colors;
    protected List<Number> data;
    private List<List<Number>> listData;
    private List<String> names;
    private DisplayMode displayMode = DisplayMode.OVERLAP;

    public Histogram() {
        this.openComm();
    }

    @Override
    public String getModelNameValue() {
        return "PlotModel";
    }

    @Override
    public String getViewNameValue() {
        return "PlotView";
    }

    public Integer getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(Integer rangeMin) {
        this.rangeMin = rangeMin;
    }

    public Integer getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(Integer rangeMax) {
        this.rangeMax = rangeMax;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public void setBinCount(int binCount) {
        this.binCount = binCount;
        this.sendModelUpdate(ChartToJson.serializeBinCount(this.binCount));
    }

    public boolean getRightClose() {
        return this.rightClose;
    }

    public void setRightClose(boolean rightClose) {
        this.rightClose = rightClose;
    }

    public boolean getCumulative() {
        return this.cumulative;
    }

    public void setCumulative(boolean cumulative) {
        this.cumulative = cumulative;
        this.sendModelUpdate(ChartToJson.serializeCumulative(this.cumulative));
    }

    public boolean getNormed() {
        return this.normed;
    }

    public void setNormed(boolean normed) {
        this.normed = normed;
        this.sendModelUpdate(ChartToJson.serializeNormed(this.normed));
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.sendModelUpdate(ChartToJson.serializeDisplayMode(this.displayMode));
    }

    public boolean getLog() {
        return this.getLogY();
    }

    public void setLog(boolean log) {
        this.setLogY(log);
    }

    @Override
    public AbstractChart setLogY(boolean logY) {
        this.yAxis.setLog(logY);
        this.sendModelUpdate(ChartToJson.serializeHistogramLog(this.yAxis.getLog()));
        return this;
    }

    public void setColor(Color color) {
        this.baseColor = color;
        this.sendModelUpdate(ChartToJson.serializeColor(this.baseColor));
    }

    public void setColor(java.awt.Color color) {
        this.setColor(new Color(color));
    }

    public void setColor(List<Object> colorList) {
        this.setColors(colorList);
    }

    private void setColors(List<Object> colorList) {
        if (colorList != null) {
            this.colors = ListColorConverter.convert(colorList);
            this.sendModelUpdate(ChartToJson.serializeColors(this.colors));
        } else {
            this.colors = null;
        }
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public Color getColor() {
        return this.baseColor;
    }

    public void setData(Object data) {
        List list = (List)data;
        if (list.size() > 0) {
            try {
                if (list.get(0) instanceof List) {
                    this.listData = (List)data;
                    this.sendModelUpdate(ChartToJson.serializeHistogramListData(this.listData));
                } else {
                    this.data = (List)data;
                    this.sendModelUpdate(ChartToJson.serializeHistogramData(this.data));
                }
            }
            catch (Throwable x) {
                throw new IllegalArgumentException("setData takes List of Number or List of List of Number");
            }
        }
    }

    public List<Number> getData() {
        return this.data;
    }

    public List<List<Number>> getListData() {
        return this.listData;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
        this.sendModelUpdate(ChartToJson.serializeHistogramNames(this.names));
    }

    public static enum DisplayMode {
        OVERLAP,
        STACK,
        SIDE_BY_SIDE;

    }
}

