/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.forms;

import android.content.Context;
import android.content.SharedPreferences;
import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.communications.TwinPushRequestFactory;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.communications.requests.forms.ReportFormRequest;
import com.twincoders.twinpush.sdk.forms.TwinFormsSDK;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import java.util.Map;

public class DefaultTwinFormsSDK
extends TwinFormsSDK {
    private static final String PREF_FILE_NAME = "TwinFormsPrefs";
    private static final String APP_TOKEN = "APP_TOKEN";
    private static final String REPORTER_TOKEN = "REPORTER_TOKEN";
    private Context _context = null;
    private TwinPushRequest request = null;
    TwinPushSDK twinPush = null;
    private String appToken = null;
    private String reporterToken = null;

    protected DefaultTwinFormsSDK(Context context) {
        this._context = context.getApplicationContext();
        this.twinPush = TwinPushSDK.getInstance(this._context);
    }

    @Override
    public void report(PushNotification notification, Map<String, Object> form) {
        this.report(notification, form, null);
    }

    @Override
    public void report(PushNotification notification, Map<String, Object> form, final TwinFormsSDK.ReportListener listener) {
        if (this.request != null) {
            this.request.cancel();
        }
        this.request = this.getRequestFactory().reportForm(this.twinPush.getDeviceId(), this.twinPush.getDeviceAlias(), this.getAppToken(), this.getReporterToken(), notification, form, new ReportFormRequest.Listener(){

            @Override
            public void onError(Exception exception) {
                if (listener != null) {
                    listener.onReportError(exception);
                }
                DefaultTwinFormsSDK.this.request = null;
            }

            @Override
            public void onSuccess() {
                if (listener != null) {
                    listener.onReportSuccess();
                }
                DefaultTwinFormsSDK.this.request = null;
            }
        });
    }

    @Override
    public void setup(String appToken, String reporterToken) {
        this.setAppToken(appToken);
        this.setReporterToken(reporterToken);
    }

    private SharedPreferences getSharedPreferences() {
        return this.getSharedPreferences(PREF_FILE_NAME);
    }

    private SharedPreferences getSharedPreferences(String preferencesName) {
        SharedPreferences prefs = this.getContext().getSharedPreferences(preferencesName, 0);
        return prefs;
    }

    public Context getContext() {
        return this._context;
    }

    public void setAppToken(String token) {
        this.getSharedPreferences().edit().putString(APP_TOKEN, token).commit();
        this.appToken = token;
    }

    public String getAppToken() {
        if (this.appToken == null) {
            this.appToken = this.getSharedPreferences().getString(APP_TOKEN, null);
        }
        return this.appToken;
    }

    public void setReporterToken(String token) {
        this.getSharedPreferences().edit().putString(REPORTER_TOKEN, token).commit();
        this.reporterToken = token;
    }

    public String getReporterToken() {
        if (this.reporterToken == null) {
            this.reporterToken = this.getSharedPreferences().getString(REPORTER_TOKEN, null);
        }
        return this.reporterToken;
    }

    private TwinPushRequestFactory getRequestFactory() {
        return TwinPushRequestFactory.getSharedinstance(this.getContext());
    }
}

