/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications.requests.register;

import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushTokenRequest;
import com.twincoders.twinpush.sdk.entities.RegistrationInfo;
import com.twincoders.twinpush.sdk.logging.Ln;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RegisterRequest
extends TwinPushTokenRequest {
    private static final String DEVICES_SEGMENT = "devices";
    private static final String REGISTER_SEGMENT = "register";
    private static final String PLATFORM_KEY = "platform";
    private static final String ALIAS_KEY = "alias_device";
    private static final String UDID_KEY = "udid";
    private static final String PUSH_TOKEN_KEY = "push_token";
    private static final String APP_VERSION_KEY = "app_version";
    private static final String SDK_VERSION_KEY = "sdk_version";
    private static final String OS_VERSION_KEY = "os_version";
    private static final String OS_VERSION_CODE_KEY = "os_version_code";
    private static final String MANUFACTURER_KEY = "device_manufacturer";
    private static final String DEVICE_MODEL_KEY = "device_model";
    private static final String DEVICE_CODE_KEY = "device_code";
    private static final String LANGUAGE_KEY = "language";
    private static final String RESPONSE_OBJECTS_KEY = "objects";
    private static final String RESPONSE_DEVICE_ALIAS_KEY = "alias_device";
    private static final String RESPONSE_DEVICE_ID_KEY = "id";
    Listener listener;

    public RegisterRequest(String applicationId, RegistrationInfo registrationInfo, Listener listener) {
        super(applicationId);
        this.sequential = true;
        this.listener = listener;
        this.httpMethod = TwinRequest.HttpMethod.POST;
        this.addSegmentParam(DEVICES_SEGMENT);
        this.addSegmentParam(REGISTER_SEGMENT);
        this.addParam(PLATFORM_KEY, registrationInfo.getPlatform().getKey());
        this.addParam(UDID_KEY, registrationInfo.getUdid());
        this.addParam("alias_device", registrationInfo.getDeviceAlias());
        this.addParam(PUSH_TOKEN_KEY, registrationInfo.getPushToken());
        this.addParam(APP_VERSION_KEY, registrationInfo.getAppVersion());
        this.addParam(SDK_VERSION_KEY, registrationInfo.getSdkVersion());
        this.addParam(OS_VERSION_KEY, registrationInfo.getOsVersion());
        this.addParam(OS_VERSION_CODE_KEY, registrationInfo.getOsVersionInt());
        this.addParam(MANUFACTURER_KEY, registrationInfo.getDeviceManufacturer());
        this.addParam(DEVICE_MODEL_KEY, registrationInfo.getDeviceModel());
        this.addParam(DEVICE_CODE_KEY, registrationInfo.getDeviceCode());
        this.addParam(LANGUAGE_KEY, registrationInfo.getLanguage());
    }

    @Override
    protected void onSuccess(JSONObject response) {
        String deviceAlias = null;
        String deviceId = null;
        try {
            JSONArray objectArray = response.getJSONArray(RESPONSE_OBJECTS_KEY);
            JSONObject deviceObject = objectArray.getJSONObject(0);
            try {
                if (!deviceObject.isNull("alias_device")) {
                    deviceAlias = deviceObject.getString("alias_device");
                }
            }
            catch (JSONException e) {
                Ln.w(e, (Object)"Could not find field %1$s on response", "alias_device");
            }
            try {
                deviceId = deviceObject.getString(RESPONSE_DEVICE_ID_KEY);
            }
            catch (JSONException e) {
                Ln.w(e, (Object)"Could not find field %1$s on response", RESPONSE_DEVICE_ID_KEY);
            }
        }
        catch (JSONException e) {
            Ln.w(e, (Object)"Could obtain device object on response", new Object[0]);
        }
        this.getListener().onRegistrationSuccess(deviceId, deviceAlias);
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    public static interface Listener
    extends TwinRequest.ErrorListener {
        public void onRegistrationSuccess(String var1, String var2);
    }
}

