/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications.requests.notifications;

import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.logging.Ln;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetNotificationDetailsRequest
extends TwinPushRequest {
    private static final String RESPONSE_RESULTS_KEY = "objects";
    Listener listener;

    public GetNotificationDetailsRequest(String appId, String deviceId, String notificationId, Listener listener) {
        super(appId, deviceId, notificationId);
        this.listener = listener;
        this.httpMethod = TwinRequest.HttpMethod.GET;
    }

    @Override
    protected void onSuccess(JSONObject response) {
        try {
            JSONArray notifJsonArray = response.getJSONArray(RESPONSE_RESULTS_KEY);
            if (notifJsonArray.length() > 0) {
                JSONObject json = notifJsonArray.getJSONObject(0);
                PushNotification n = this.parseNotification(json);
                this.getListener().onSuccess(n);
            } else {
                this.getListener().onError(new Exception("Notification not found"));
            }
        }
        catch (JSONException e) {
            Ln.e(e, (Object)"Error while trying to parse notifications from response", new Object[0]);
            this.getListener().onError((Exception)((Object)e));
        }
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    public static interface Listener
    extends TwinRequest.ErrorListener {
        public void onSuccess(PushNotification var1);
    }
}

